/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.v4;

import com.android.apksig.apk.ApkUtils;
import com.android.apksig.internal.apk.ApkSigningBlockUtils;
import com.android.apksig.internal.apk.ContentDigestAlgorithm;
import com.android.apksig.internal.apk.SignatureAlgorithm;
import com.android.apksig.internal.apk.SignatureInfo;
import com.android.apksig.internal.apk.v2.V2SchemeVerifier;
import com.android.apksig.internal.apk.v3.V3SchemeSigner;
import com.android.apksig.internal.apk.v3.V3SchemeVerifier;
import com.android.apksig.internal.apk.v4.V4Signature;
import com.android.apksig.internal.util.Pair;
import com.android.apksig.util.DataSource;
import com.android.apksig.zip.ZipFormatException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public abstract class V4SchemeSigner {
    private V4SchemeSigner() {
    }

    public static List<SignatureAlgorithm> getSuggestedSignatureAlgorithms(PublicKey signingKey, int minSdkVersion, boolean apkSigningBlockPaddingSupported, boolean deterministicDsaSigning) throws InvalidKeyException {
        List<SignatureAlgorithm> algorithms = V3SchemeSigner.getSuggestedSignatureAlgorithms(signingKey, minSdkVersion, apkSigningBlockPaddingSupported, deterministicDsaSigning);
        ListIterator<SignatureAlgorithm> iter = algorithms.listIterator();
        while (iter.hasNext()) {
            SignatureAlgorithm algorithm = (SignatureAlgorithm)((Object)iter.next());
            if (V4SchemeSigner.isSupported(algorithm.getContentDigestAlgorithm(), false)) continue;
            iter.remove();
        }
        return algorithms;
    }

    public static void generateV4Signature(DataSource apkContent, SignerConfig signerConfig, File outputFile) throws IOException, InvalidKeyException, NoSuchAlgorithmException {
        Pair<V4Signature, byte[]> pair = V4SchemeSigner.generateV4Signature(apkContent, signerConfig);
        try (FileOutputStream output = new FileOutputStream(outputFile);){
            pair.getFirst().writeTo(output);
            V4Signature.writeBytes(output, pair.getSecond());
        }
        catch (IOException e) {
            outputFile.delete();
            throw e;
        }
    }

    public static Pair<V4Signature, byte[]> generateV4Signature(DataSource apkContent, SignerConfig signerConfig) throws IOException, InvalidKeyException, NoSuchAlgorithmException {
        V4Signature signature;
        byte[] salt = null;
        byte[] additionalData = null;
        long fileSize = apkContent.size();
        Map<Integer, byte[]> apkDigests = V4SchemeSigner.getApkDigests(apkContent);
        ApkSigningBlockUtils.VerityTreeAndDigest verityContentDigestInfo = ApkSigningBlockUtils.computeChunkVerityTreeAndDigest(apkContent);
        ContentDigestAlgorithm verityContentDigestAlgorithm = verityContentDigestInfo.contentDigestAlgorithm;
        byte[] rootHash = verityContentDigestInfo.rootHash;
        byte[] tree = verityContentDigestInfo.tree;
        Pair<Integer, Byte> hashingAlgorithmBlockSizePair = V4SchemeSigner.convertToV4HashingInfo(verityContentDigestAlgorithm);
        V4Signature.HashingInfo hashingInfo = new V4Signature.HashingInfo(hashingAlgorithmBlockSizePair.getFirst(), hashingAlgorithmBlockSizePair.getSecond(), salt, rootHash);
        try {
            signature = V4SchemeSigner.generateSignature(signerConfig, hashingInfo, apkDigests, additionalData, fileSize);
        }
        catch (InvalidKeyException | SignatureException | CertificateEncodingException e) {
            throw new InvalidKeyException("Signer failed", e);
        }
        return Pair.of(signature, tree);
    }

    private static V4Signature.SigningInfo generateSigningInfo(ApkSigningBlockUtils.SignerConfig signerConfig, V4Signature.HashingInfo hashingInfo, byte[] apkDigest, byte[] additionalData, long fileSize) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, CertificateEncodingException {
        if (signerConfig.certificates.isEmpty()) {
            throw new SignatureException("No certificates configured for signer");
        }
        PublicKey publicKey = signerConfig.certificates.get(0).getPublicKey();
        List<byte[]> encodedCertificates = ApkSigningBlockUtils.encodeCertificates(signerConfig.certificates);
        byte[] encodedCertificate = encodedCertificates.get(0);
        V4Signature.SigningInfo signingInfoNoSignature = new V4Signature.SigningInfo(apkDigest, encodedCertificate, additionalData, publicKey.getEncoded(), -1, null);
        byte[] data = V4Signature.getSignedData(fileSize, hashingInfo, signingInfoNoSignature);
        List<Pair<Integer, byte[]>> signatures = ApkSigningBlockUtils.generateSignaturesOverData(signerConfig, data);
        if (signatures.size() != 1) {
            throw new SignatureException("Should only be one signature generated");
        }
        int signatureAlgorithmId = signatures.get(0).getFirst();
        byte[] signature = signatures.get(0).getSecond();
        return new V4Signature.SigningInfo(apkDigest, encodedCertificate, additionalData, publicKey.getEncoded(), signatureAlgorithmId, signature);
    }

    private static V4Signature generateSignature(SignerConfig signerConfig, V4Signature.HashingInfo hashingInfo, Map<Integer, byte[]> apkDigests, byte[] additionalData, long fileSize) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, CertificateEncodingException {
        V4Signature.SigningInfos signingInfos;
        byte[] apkDigest = apkDigests.containsKey(3) ? apkDigests.get(3) : apkDigests.get(2);
        V4Signature.SigningInfo signingInfo = V4SchemeSigner.generateSigningInfo(signerConfig.v4Config, hashingInfo, apkDigest, additionalData, fileSize);
        if (signerConfig.v41Config != null) {
            if (!apkDigests.containsKey(31)) {
                throw new IllegalStateException("V4.1 cannot be signed without a V3.1 content digest");
            }
            apkDigest = apkDigests.get(31);
            V4Signature.SigningInfoBlock extSigningBlock = new V4Signature.SigningInfoBlock(462663009, V4SchemeSigner.generateSigningInfo(signerConfig.v41Config, hashingInfo, apkDigest, additionalData, fileSize).toByteArray());
            signingInfos = new V4Signature.SigningInfos(signingInfo, extSigningBlock);
        } else {
            signingInfos = new V4Signature.SigningInfos(signingInfo);
        }
        return new V4Signature(2, hashingInfo.toByteArray(), signingInfos.toByteArray());
    }

    private static Map<Integer, byte[]> getApkDigests(DataSource apk) throws IOException {
        ApkUtils.ZipSections zipSections;
        try {
            zipSections = ApkUtils.findZipSections(apk);
        }
        catch (ZipFormatException e) {
            throw new IOException("Malformed APK: not a ZIP archive", e);
        }
        HashMap<Integer, byte[]> sigSchemeToDigest = new HashMap<Integer, byte[]>(1);
        try {
            byte[] digest = V4SchemeSigner.getBestV3Digest(apk, zipSections, 31);
            sigSchemeToDigest.put(31, digest);
        }
        catch (SignatureException digest) {
            // empty catch block
        }
        SignatureException v3Exception = null;
        try {
            byte[] digest = V4SchemeSigner.getBestV3Digest(apk, zipSections, 3);
            sigSchemeToDigest.put(3, digest);
        }
        catch (SignatureException e) {
            v3Exception = e;
        }
        SignatureException v2Exception = null;
        try {
            byte[] digest = V4SchemeSigner.getBestV2Digest(apk, zipSections);
            sigSchemeToDigest.put(2, digest);
        }
        catch (SignatureException e) {
            v2Exception = e;
        }
        if (sigSchemeToDigest.size() > 0) {
            return sigSchemeToDigest;
        }
        throw new IOException("Failed to obtain v2/v3 digest, v3 exception: " + v3Exception + ", v2 exception: " + v2Exception);
    }

    private static byte[] getBestV3Digest(DataSource apk, ApkUtils.ZipSections zipSections, int v3SchemeVersion) throws SignatureException {
        int blockId;
        HashSet<ContentDigestAlgorithm> contentDigestsToVerify = new HashSet<ContentDigestAlgorithm>(1);
        ApkSigningBlockUtils.Result result = new ApkSigningBlockUtils.Result(v3SchemeVersion);
        switch (v3SchemeVersion) {
            case 31: {
                blockId = 462663009;
                break;
            }
            case 3: {
                blockId = -262969152;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid V3 scheme provided: " + v3SchemeVersion);
            }
        }
        try {
            SignatureInfo signatureInfo = ApkSigningBlockUtils.findSignature(apk, zipSections, blockId, result);
            ByteBuffer apkSignatureSchemeV3Block = signatureInfo.signatureBlock;
            V3SchemeVerifier.parseSigners(apkSignatureSchemeV3Block, contentDigestsToVerify, result);
        }
        catch (Exception e) {
            throw new SignatureException("Failed to extract and parse v3 block", e);
        }
        if (result.signers.size() != 1) {
            throw new SignatureException("Should only have one signer, errors: " + result.getErrors());
        }
        ApkSigningBlockUtils.Result.SignerInfo signer = result.signers.get(0);
        if (signer.containsErrors()) {
            throw new SignatureException("Parsing failed: " + signer.getErrors());
        }
        List<ApkSigningBlockUtils.Result.SignerInfo.ContentDigest> contentDigests = result.signers.get((int)0).contentDigests;
        return V4SchemeSigner.pickBestDigest(contentDigests);
    }

    private static byte[] getBestV2Digest(DataSource apk, ApkUtils.ZipSections zipSections) throws SignatureException {
        HashSet<ContentDigestAlgorithm> contentDigestsToVerify = new HashSet<ContentDigestAlgorithm>(1);
        HashSet<Integer> foundApkSigSchemeIds = new HashSet<Integer>(1);
        ApkSigningBlockUtils.Result result = new ApkSigningBlockUtils.Result(2);
        try {
            SignatureInfo signatureInfo = ApkSigningBlockUtils.findSignature(apk, zipSections, 1896449818, result);
            ByteBuffer apkSignatureSchemeV2Block = signatureInfo.signatureBlock;
            V2SchemeVerifier.parseSigners(apkSignatureSchemeV2Block, contentDigestsToVerify, Collections.emptyMap(), foundApkSigSchemeIds, Integer.MAX_VALUE, Integer.MAX_VALUE, result);
        }
        catch (Exception e) {
            throw new SignatureException("Failed to extract and parse v2 block", e);
        }
        if (result.signers.size() != 1) {
            throw new SignatureException("Should only have one signer, errors: " + result.getErrors());
        }
        ApkSigningBlockUtils.Result.SignerInfo signer = result.signers.get(0);
        if (signer.containsErrors()) {
            throw new SignatureException("Parsing failed: " + signer.getErrors());
        }
        List<ApkSigningBlockUtils.Result.SignerInfo.ContentDigest> contentDigests = signer.contentDigests;
        return V4SchemeSigner.pickBestDigest(contentDigests);
    }

    private static byte[] pickBestDigest(List<ApkSigningBlockUtils.Result.SignerInfo.ContentDigest> contentDigests) throws SignatureException {
        if (contentDigests == null || contentDigests.isEmpty()) {
            throw new SignatureException("Should have at least one digest");
        }
        int bestAlgorithmOrder = -1;
        byte[] bestDigest = null;
        for (ApkSigningBlockUtils.Result.SignerInfo.ContentDigest contentDigest : contentDigests) {
            int algorithmOrder;
            SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.findById(contentDigest.getSignatureAlgorithmId());
            ContentDigestAlgorithm contentDigestAlgorithm = signatureAlgorithm.getContentDigestAlgorithm();
            if (!V4SchemeSigner.isSupported(contentDigestAlgorithm, true) || bestAlgorithmOrder >= (algorithmOrder = V4SchemeSigner.digestAlgorithmSortingOrder(contentDigestAlgorithm))) continue;
            bestAlgorithmOrder = algorithmOrder;
            bestDigest = contentDigest.getValue();
        }
        if (bestDigest == null) {
            throw new SignatureException("Failed to find a supported digest in the source APK");
        }
        return bestDigest;
    }

    public static int digestAlgorithmSortingOrder(ContentDigestAlgorithm contentDigestAlgorithm) {
        switch (contentDigestAlgorithm) {
            case CHUNKED_SHA256: {
                return 0;
            }
            case VERITY_CHUNKED_SHA256: {
                return 1;
            }
            case CHUNKED_SHA512: {
                return 2;
            }
        }
        return -1;
    }

    private static boolean isSupported(ContentDigestAlgorithm contentDigestAlgorithm, boolean forV3Digest) {
        if (contentDigestAlgorithm == null) {
            return false;
        }
        return contentDigestAlgorithm == ContentDigestAlgorithm.CHUNKED_SHA256 || contentDigestAlgorithm == ContentDigestAlgorithm.CHUNKED_SHA512 || forV3Digest && contentDigestAlgorithm == ContentDigestAlgorithm.VERITY_CHUNKED_SHA256;
    }

    private static Pair<Integer, Byte> convertToV4HashingInfo(ContentDigestAlgorithm algorithm) throws NoSuchAlgorithmException {
        switch (algorithm) {
            case VERITY_CHUNKED_SHA256: {
                return Pair.of(1, (byte)12);
            }
        }
        throw new NoSuchAlgorithmException("Invalid hash algorithm, only SHA2-256 over 4 KB chunks supported.");
    }

    public static class SignerConfig {
        public final ApkSigningBlockUtils.SignerConfig v4Config;
        public final ApkSigningBlockUtils.SignerConfig v41Config;

        public SignerConfig(List<ApkSigningBlockUtils.SignerConfig> v4Configs, List<ApkSigningBlockUtils.SignerConfig> v41Configs) throws InvalidKeyException {
            if (v4Configs == null || v4Configs.size() != 1) {
                throw new InvalidKeyException("Only accepting one signer config for V4 Signature.");
            }
            if (v41Configs != null && v41Configs.size() != 1) {
                throw new InvalidKeyException("Only accepting one signer config for V4.1 Signature.");
            }
            this.v4Config = v4Configs.get(0);
            this.v41Config = v41Configs != null ? v41Configs.get(0) : null;
        }
    }
}

