/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import org.conscrypt.DuckTypedHpkeSpi;
import org.conscrypt.HpkeSpi;

public abstract class HpkeContext {
    protected final HpkeSpi spi;

    protected HpkeContext(HpkeSpi spi) {
        this.spi = spi;
    }

    public byte[] export(int length, byte[] context) {
        return this.spi.engineExport(length, context);
    }

    public HpkeSpi getSpi() {
        return this.spi;
    }

    protected static HpkeSpi findSpi(String algorithm) throws NoSuchAlgorithmException {
        if (algorithm == null) {
            throw new NoSuchAlgorithmException("null algorithm");
        }
        return HpkeContext.findSpi(algorithm, HpkeContext.findFirstProvider(algorithm));
    }

    private static Provider findFirstProvider(String algorithm) throws NoSuchAlgorithmException {
        for (Provider p : Security.getProviders()) {
            Provider.Service service = p.getService("ConscryptHpke", algorithm);
            if (service == null) continue;
            return service.getProvider();
        }
        throw new NoSuchAlgorithmException("No Provider found for: " + algorithm);
    }

    protected static HpkeSpi findSpi(String algorithm, String providerName) throws NoSuchAlgorithmException, IllegalArgumentException, NoSuchProviderException {
        if (providerName == null || providerName.isEmpty()) {
            throw new IllegalArgumentException("Invalid provider name");
        }
        Provider provider = Security.getProvider(providerName);
        if (provider == null) {
            throw new NoSuchProviderException("Unknown Provider: " + providerName);
        }
        return HpkeContext.findSpi(algorithm, provider);
    }

    protected static HpkeSpi findSpi(String algorithm, Provider provider) throws NoSuchAlgorithmException, IllegalArgumentException {
        HpkeSpi spi;
        if (provider == null) {
            throw new IllegalArgumentException("null Provider");
        }
        Provider.Service service = provider.getService("ConscryptHpke", algorithm);
        if (service == null) {
            throw new NoSuchAlgorithmException("Unknown algorithm");
        }
        Object instance = service.newInstance(null);
        HpkeSpi hpkeSpi = spi = instance instanceof HpkeSpi ? (HpkeSpi)instance : DuckTypedHpkeSpi.newInstance(instance);
        if (spi != null) {
            return spi;
        }
        throw new IllegalStateException(String.format("Provider %s is providing incorrect instances", provider.getName()));
    }
}

