/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt.ct;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import org.conscrypt.ct.SignedCertificateTimestamp;
import org.conscrypt.ct.VerifiedSCT;

public class VerificationResult {
    private final List<VerifiedSCT> validSCTs = new ArrayList<VerifiedSCT>();
    private final List<VerifiedSCT> invalidSCTs = new ArrayList<VerifiedSCT>();
    private final EnumMap<SignedCertificateTimestamp.Origin, Integer> count = new EnumMap(SignedCertificateTimestamp.Origin.class);

    public void add(VerifiedSCT result) {
        if (result.isValid()) {
            this.validSCTs.add(result);
        } else {
            this.invalidSCTs.add(result);
        }
        SignedCertificateTimestamp.Origin origin = result.getSct().getOrigin();
        Integer value = this.count.get((Object)origin);
        if (value == null) {
            this.count.put(origin, 1);
        } else {
            this.count.put(origin, value + 1);
        }
    }

    public List<VerifiedSCT> getValidSCTs() {
        return Collections.unmodifiableList(this.validSCTs);
    }

    public List<VerifiedSCT> getInvalidSCTs() {
        return Collections.unmodifiableList(this.invalidSCTs);
    }

    public int numCertSCTs() {
        Integer num = this.count.get((Object)SignedCertificateTimestamp.Origin.EMBEDDED);
        return num == null ? 0 : num;
    }

    public int numOCSPSCTs() {
        Integer num = this.count.get((Object)SignedCertificateTimestamp.Origin.OCSP_RESPONSE);
        return num == null ? 0 : num;
    }

    public int numTlsSCTs() {
        Integer num = this.count.get((Object)SignedCertificateTimestamp.Origin.TLS_EXTENSION);
        return num == null ? 0 : num;
    }
}

