/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.compile;

import com.reandroid.apk.APKLogger;
import com.reandroid.apk.DexProfileEncoder;
import com.reandroid.apkeditor.compile.BuildOptions;
import com.reandroid.dex.dexopt.ProfileDirectory;
import com.reandroid.dex.dexopt.ProfileFile;
import com.reandroid.utils.io.FileUtil;
import java.io.File;
import java.io.IOException;

public class DexProfileEncoderImpl
implements DexProfileEncoder {
    private final BuildOptions options;
    private APKLogger apkLogger;

    public DexProfileEncoderImpl(BuildOptions options) {
        this.options = options;
    }

    @Override
    public void encodeDexProfile(File mainDirectory) throws IOException {
        File decodeDir = new File(mainDirectory, ProfileFile.DECODE_DIR_NAME);
        if (!this.isEnabled(decodeDir)) {
            return;
        }
        this.logMessage("Encoding assets/dexopt ...");
        ProfileDirectory profileDirectory = new ProfileDirectory();
        profileDirectory.encodeJsonDir(decodeDir);
        File dex = new File(mainDirectory, ".cache");
        if (!dex.isDirectory()) {
            dex = new File(mainDirectory, "dex");
        }
        profileDirectory.syncDexDirectory(dex);
        profileDirectory.updateDexDirectory(dex);
        profileDirectory.refresh();
        File dexOpt = this.toDexOptDir(mainDirectory);
        this.logMessage("Writing: " + FileUtil.shortPath(dexOpt, 3));
        profileDirectory.writeTo(dexOpt);
        profileDirectory.close();
    }

    private File toDexOptDir(File mainDirectory) {
        File dexOpt = new File(mainDirectory, "root");
        dexOpt = new File(dexOpt, "assets");
        dexOpt = new File(dexOpt, "dexopt");
        return dexOpt;
    }

    private boolean isEnabled(File decodeDir) {
        if (!this.options.dexProfile) {
            return false;
        }
        return decodeDir.isDirectory();
    }

    public void setApkLogger(APKLogger apkLogger) {
        this.apkLogger = apkLogger;
    }

    private void logMessage(String message) {
        APKLogger apkLogger = this.apkLogger;
        if (apkLogger != null) {
            apkLogger.logMessage(message);
        }
    }
}

