/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.decompile;

import com.reandroid.apk.AndroidFrameworks;
import com.reandroid.apk.ApkModule;
import com.reandroid.apk.ApkModuleDecoder;
import com.reandroid.apk.ApkModuleJsonDecoder;
import com.reandroid.apk.ApkModuleRawDecoder;
import com.reandroid.apk.ApkModuleXmlDecoder;
import com.reandroid.apk.FrameworkApk;
import com.reandroid.apkeditor.CommandExecutor;
import com.reandroid.apkeditor.Util;
import com.reandroid.apkeditor.decompile.DecompileOptions;
import com.reandroid.apkeditor.decompile.DexProfileDecoderImpl;
import com.reandroid.apkeditor.smali.SmaliDecompiler;
import com.reandroid.archive.ArchiveFile;
import com.reandroid.archive.block.ApkSignatureBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.coder.xml.XmlCoder;
import java.io.File;
import java.io.IOException;

public class Decompiler
extends CommandExecutor<DecompileOptions> {
    public Decompiler(DecompileOptions options) {
        super(options, "[DECOMPILE] ");
    }

    @Override
    public void runCommand() throws IOException {
        DecompileOptions options = (DecompileOptions)this.getOptions();
        this.delete(options.outputFile);
        this.logMessage("Loading ...");
        ApkModule apkModule = ApkModule.loadApkFile(this, options.inputFile, options.getFrameworks());
        apkModule.setPreferredFramework(options.frameworkVersion);
        if (options.signaturesDirectory != null) {
            this.dumpSignatureBlock();
            return;
        }
        String protect = Util.isProtected(apkModule);
        if (protect != null) {
            this.logMessage(options.inputFile.getAbsolutePath());
            this.logMessage(protect);
            return;
        }
        if (options.resDirName != null) {
            this.logMessage("Renaming resources root dir: " + options.resDirName);
            apkModule.setResourcesRootDir(options.resDirName);
        }
        if (options.validateResDir) {
            this.logMessage("Validating resources dir ...");
            apkModule.validateResourcesDir();
        }
        this.logMessage("Decompiling to " + options.type + " ...");
        ApkModuleDecoder decoder = this.getApkModuleDecoder(apkModule);
        decoder.decode(options.outputFile);
        this.logMessage("Saved to: " + options.outputFile);
    }

    private ApkModuleDecoder getApkModuleDecoder(ApkModule apkModule) throws IOException {
        ApkModuleDecoder decoder;
        DecompileOptions options = (DecompileOptions)this.getOptions();
        if ("json".equals(options.type)) {
            decoder = new ApkModuleJsonDecoder(apkModule, options.splitJson);
        } else if ("raw".equals(options.type)) {
            decoder = new ApkModuleRawDecoder(apkModule);
        } else {
            ApkModuleXmlDecoder xmlDecoder = new ApkModuleXmlDecoder(apkModule);
            xmlDecoder.setKeepResPath(options.keepResPath);
            decoder = xmlDecoder;
            XmlCoder.getInstance().getSetting().setLogger(this);
        }
        decoder.sanitizeFilePaths();
        decoder.setDexDecoder(this.getSmaliDecompiler(apkModule));
        DexProfileDecoderImpl dexProfileDecoder = new DexProfileDecoderImpl(options);
        dexProfileDecoder.setApkLogger(this);
        decoder.setDexProfileDecoder(dexProfileDecoder);
        return decoder;
    }

    private SmaliDecompiler getSmaliDecompiler(ApkModule apkModule) throws IOException {
        if (((DecompileOptions)this.getOptions()).dex) {
            return null;
        }
        TableBlock tableBlock = this.getTableBlockForDexComment(apkModule);
        SmaliDecompiler smaliDecompiler = new SmaliDecompiler(tableBlock, (DecompileOptions)this.getOptions());
        smaliDecompiler.setApkLogger(this);
        return smaliDecompiler;
    }

    private TableBlock getTableBlockForDexComment(ApkModule apkModule) throws IOException {
        if (apkModule.listDexFiles().isEmpty()) {
            return null;
        }
        if (apkModule.hasTableBlock()) {
            return apkModule.getTableBlock();
        }
        TableBlock tableBlock = this.getUserFrameworkForDexComment();
        if (tableBlock == null) {
            tableBlock = this.getInternalFrameworkForDexComment();
        }
        return tableBlock;
    }

    private TableBlock getUserFrameworkForDexComment() throws IOException {
        DecompileOptions options = (DecompileOptions)this.getOptions();
        File[] files = options.getFrameworks();
        if (files.length == 1 && options.frameworkVersion == null) {
            this.logMessage("Loading framework: " + files[0]);
            return ApkModule.loadApkFile(files[0]).getTableBlock();
        }
        TableBlock tableBlock = null;
        if (files.length != 0) {
            tableBlock = TableBlock.createEmpty();
            for (File file : files) {
                this.logMessage("Loading framework: " + file);
                tableBlock.addFramework(ApkModule.loadApkFile(file).getTableBlock());
            }
        }
        if (tableBlock != null) {
            FrameworkApk frameworkApk;
            if (options.frameworkVersion != null && (frameworkApk = AndroidFrameworks.getBestMatch(options.frameworkVersion)) != null) {
                tableBlock.addFramework(frameworkApk.getTableBlock());
            }
            return tableBlock;
        }
        return null;
    }

    private TableBlock getInternalFrameworkForDexComment() {
        DecompileOptions options = (DecompileOptions)this.getOptions();
        FrameworkApk frameworkApk = null;
        if (options.frameworkVersion != null) {
            frameworkApk = AndroidFrameworks.getBestMatch(options.frameworkVersion);
        }
        if (frameworkApk == null) {
            frameworkApk = AndroidFrameworks.getCurrent();
        }
        if (frameworkApk == null) {
            frameworkApk = AndroidFrameworks.getLatest();
        }
        if (frameworkApk != null) {
            this.logMessage("Using internal framework: " + frameworkApk.getName());
            return frameworkApk.getTableBlock();
        }
        return null;
    }

    private void dumpSignatureBlock() throws IOException {
        this.logMessage("Dumping signature blocks ...");
        DecompileOptions options = (DecompileOptions)this.getOptions();
        ArchiveFile archive = new ArchiveFile(options.inputFile);
        ApkSignatureBlock apkSignatureBlock = archive.getApkSignatureBlock();
        if (apkSignatureBlock == null) {
            this.logMessage("Don't have signature block");
            return;
        }
        apkSignatureBlock.writeSplitRawToDirectory(options.signaturesDirectory);
        this.logMessage("Signatures dumped to: " + options.signaturesDirectory);
    }
}

