/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.decompile;

import com.reandroid.apk.APKLogger;
import com.reandroid.apk.ApkModule;
import com.reandroid.apk.DexProfileDecoder;
import com.reandroid.apkeditor.decompile.DecompileOptions;
import com.reandroid.dex.dexopt.ProfileDirectory;
import com.reandroid.dex.dexopt.ProfileFile;
import java.io.File;
import java.io.IOException;

public class DexProfileDecoderImpl
implements DexProfileDecoder {
    private final DecompileOptions options;
    private APKLogger apkLogger;

    public DexProfileDecoderImpl(DecompileOptions options) {
        this.options = options;
    }

    @Override
    public void decodeDexProfile(ApkModule apkModule, File mainDirectory) throws IOException {
        if (!this.isEnabled(apkModule)) {
            return;
        }
        this.logMessage("Decoding assets/dexopt ...");
        ProfileDirectory profileDirectory = new ProfileDirectory();
        profileDirectory.readApk(apkModule.getZipEntryMap());
        this.logMessage("Scanning dex files for profile ...");
        profileDirectory.linkApk(apkModule.getZipEntryMap());
        profileDirectory.decodeToJsonDir(new File(mainDirectory, ProfileFile.DECODE_DIR_NAME));
    }

    private boolean isEnabled(ApkModule apkModule) {
        if (!this.options.dexProfile) {
            return false;
        }
        return apkModule.getInputSource(ProfileFile.PATH_PROF) != null || apkModule.getInputSource(ProfileFile.PATH_PROFM) != null;
    }

    public void setApkLogger(APKLogger apkLogger) {
        this.apkLogger = apkLogger;
    }

    private void logMessage(String message) {
        APKLogger apkLogger = this.apkLogger;
        if (apkLogger != null) {
            apkLogger.logMessage(message);
        }
    }
}

