/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.info;

import com.reandroid.apk.ApkModule;
import com.reandroid.apk.ResFile;
import com.reandroid.apkeditor.CommandExecutor;
import com.reandroid.apkeditor.Util;
import com.reandroid.apkeditor.info.InfoOptions;
import com.reandroid.apkeditor.info.InfoWriter;
import com.reandroid.apkeditor.info.InfoWriterJson;
import com.reandroid.apkeditor.info.InfoWriterText;
import com.reandroid.apkeditor.info.InfoWriterXml;
import com.reandroid.app.AndroidManifest;
import com.reandroid.archive.InputSource;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.xml.AndroidManifestBlock;
import com.reandroid.arsc.chunk.xml.ResXmlAttribute;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.coder.EncodeResult;
import com.reandroid.arsc.coder.ReferenceString;
import com.reandroid.arsc.coder.ValueCoder;
import com.reandroid.arsc.model.ResourceEntry;
import com.reandroid.arsc.value.AttributeDataFormat;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResConfig;
import com.reandroid.arsc.value.ResValue;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.dex.model.DexDirectory;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.ComputeIterator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class Info
extends CommandExecutor<InfoOptions> {
    private InfoWriter mInfoWriter;

    public Info(InfoOptions options) {
        super(options, "[INFO] ");
        super.setEnableLog(options.outputFile != null);
    }

    @Override
    public void runCommand() throws IOException {
        InfoOptions options = (InfoOptions)this.getOptions();
        this.setEnableLog(options.outputFile != null);
        this.delete(options.outputFile);
        this.logMessage("Loading: " + options.inputFile);
        ApkModule apkModule = ApkModule.loadApkFile(this, options.inputFile, options.getFrameworks());
        String msg = Util.isProtected(apkModule);
        if (msg != null) {
            this.logWarn(msg);
            return;
        }
        apkModule.setAPKLogger(this);
        File out = options.outputFile;
        if (out != null) {
            this.logMessage("Writing ...");
        }
        this.print(apkModule);
        this.flush();
        this.close();
        if (out != null) {
            this.logMessage("Saved to: " + out);
        }
    }

    private void print(ApkModule apkModule) throws IOException {
        this.printSourceFile();
        this.printPackage(apkModule);
        AndroidManifestBlock manifest = apkModule.getAndroidManifest();
        this.printVersionCode(manifest);
        this.printVersionName(manifest);
        this.printMinSdkVersion(manifest);
        this.printTargetSdkVersion(manifest);
        this.printAppName(apkModule);
        this.printAppIcon(apkModule);
        this.printAppRoundIcon(apkModule);
        this.printAppClass(apkModule);
        this.printActivities(apkModule);
        this.printUsesPermissions(apkModule);
        this.printResList(apkModule);
        this.printResources(apkModule);
        this.printDex(apkModule);
        this.printSignatures(apkModule);
        this.printXmlTree(apkModule);
        this.printXmlStrings(apkModule);
        this.printStrings(apkModule);
        this.listFiles(apkModule);
        this.listXmlFiles(apkModule);
        this.printConfigurations(apkModule);
        this.printLanguages(apkModule);
        this.printLocales(apkModule);
    }

    private void printSourceFile() throws IOException {
        InfoOptions options = (InfoOptions)this.getOptions();
        if (options.outputFile == null) {
            return;
        }
        if (options.verbose || !options.resources) {
            InfoWriter infoWriter = this.getInfoWriter();
            infoWriter.writeNameValue("source-file", options.inputFile.getAbsolutePath());
        }
    }

    private void printResources(ApkModule apkModule) throws IOException {
        InfoOptions options = (InfoOptions)this.getOptions();
        if (!options.resources) {
            return;
        }
        if (!apkModule.hasTableBlock()) {
            return;
        }
        TableBlock tableBlock = apkModule.getTableBlock();
        InfoWriter infoWriter = this.getInfoWriter();
        boolean writeEntries = options.verbose;
        for (PackageBlock packageBlock : tableBlock.listPackages()) {
            infoWriter.writeResources(packageBlock, options.typeFilterList, writeEntries);
        }
    }

    private void printDex(ApkModule apkModule) throws IOException {
        InfoOptions options = (InfoOptions)this.getOptions();
        if (!options.dex) {
            return;
        }
        InfoWriter infoWriter = this.getInfoWriter();
        DexDirectory dexDirectory = DexDirectory.fromZip(apkModule.getZipEntryMap(), sectionType -> sectionType == SectionType.STRING_ID || sectionType == SectionType.STRING_DATA);
        infoWriter.writeDexInfo(dexDirectory);
        dexDirectory.close();
    }

    private void printSignatures(ApkModule apkModule) throws IOException {
        InfoOptions options = (InfoOptions)this.getOptions();
        if (!options.signatures && !options.signatures_base64) {
            return;
        }
        InfoWriter infoWriter = this.getInfoWriter();
        infoWriter.writeSignatureInfo(apkModule.getApkSignatureBlock(), options.signatures_base64);
    }

    private void printResList(ApkModule apkModule) throws IOException {
        InfoOptions options = (InfoOptions)this.getOptions();
        if (options.resList.size() == 0) {
            return;
        }
        if (!apkModule.hasTableBlock()) {
            return;
        }
        for (String res : options.resList) {
            this.printRes(apkModule, res);
        }
    }

    private void printRes(ApkModule apkModule, String res) throws IOException {
        EncodeResult encodeResult;
        if (res == null || res.length() < 3) {
            return;
        }
        if (res.startsWith("@0x")) {
            res = res.substring(1);
        }
        if ((encodeResult = ValueCoder.encode(res, AttributeDataFormat.INTEGER.valueTypes())) != null) {
            this.printEntries(apkModule, "resource", encodeResult.value);
            return;
        }
        ReferenceString referenceString = ReferenceString.parseReference(res);
        if (referenceString == null) {
            this.logWarn("WARN: Invalid resource: " + res);
            return;
        }
        TableBlock tableBlock = apkModule.getTableBlock();
        for (PackageBlock packageBlock : tableBlock.listPackages()) {
            ResourceEntry resourceEntry = packageBlock.getResource(referenceString.type, referenceString.name);
            if (resourceEntry == null) continue;
            this.printEntries(apkModule, "resource", resourceEntry.getResourceId());
            return;
        }
        this.logMessage("WARN: resource not found: " + res);
    }

    private void printPackage(ApkModule apkModule) throws IOException {
        InfoOptions options = (InfoOptions)this.getOptions();
        if (!options.packageName) {
            return;
        }
        AndroidManifestBlock manifest = apkModule.getAndroidManifest();
        if (manifest != null) {
            this.getInfoWriter().writeNameValue("package", manifest.getPackageName());
        }
        if (!options.verbose || !apkModule.hasTableBlock()) {
            return;
        }
        TableBlock tableBlock = apkModule.getTableBlock();
        InfoWriter infoWriter = this.getInfoWriter();
        infoWriter.writePackageNames(CollectionUtil.collect(tableBlock.iterator()));
    }

    private void printVersionCode(AndroidManifestBlock manifest) throws IOException {
        InfoOptions options = (InfoOptions)this.getOptions();
        if (!options.versionCode || manifest == null) {
            return;
        }
        this.getInfoWriter().writeNameValue("VersionCode", manifest.getVersionCode());
    }

    private void printVersionName(AndroidManifestBlock manifest) throws IOException {
        InfoOptions options = (InfoOptions)this.getOptions();
        if (!options.versionName || manifest == null) {
            return;
        }
        this.getInfoWriter().writeNameValue("VersionName", manifest.getVersionName());
    }

    private void printMinSdkVersion(AndroidManifestBlock manifest) throws IOException {
        InfoOptions options = (InfoOptions)this.getOptions();
        if (!options.minSdkVersion || manifest == null) {
            return;
        }
        this.getInfoWriter().writeNameValue("MinSdkVersion", manifest.getMinSdkVersion());
    }

    private void printTargetSdkVersion(AndroidManifestBlock manifest) throws IOException {
        InfoOptions options = (InfoOptions)this.getOptions();
        if (!options.targetSdkVersion || manifest == null) {
            return;
        }
        this.getInfoWriter().writeNameValue("TargetSdkVersion", manifest.getTargetSdkVersion());
    }

    private void printAppName(ApkModule apkModule) throws IOException {
        InfoOptions options = (InfoOptions)this.getOptions();
        if (!options.appName) {
            return;
        }
        AndroidManifestBlock manifest = apkModule.getAndroidManifest();
        ResXmlElement application = manifest.getApplicationElement();
        ResXmlAttribute attributeLabel = application.searchAttributeByResourceId(AndroidManifest.ID_label);
        if (attributeLabel == null) {
            return;
        }
        if (attributeLabel.getValueType() == ValueType.STRING) {
            this.getInfoWriter().writeNameValue("AppName", attributeLabel.getValueAsString());
            return;
        }
        int resourceId = attributeLabel.getData();
        this.printEntries(apkModule, "AppName", resourceId);
    }

    private void printAppIcon(ApkModule apkModule) throws IOException {
        InfoOptions options = (InfoOptions)this.getOptions();
        if (!options.appIcon) {
            return;
        }
        AndroidManifestBlock manifest = apkModule.getAndroidManifest();
        ResXmlElement application = manifest.getApplicationElement();
        ResXmlAttribute attribute = application.searchAttributeByResourceId(AndroidManifest.ID_icon);
        if (attribute == null) {
            return;
        }
        if (attribute.getValueType() == ValueType.STRING) {
            this.getInfoWriter().writeNameValue("AppIcon", attribute.getValueAsString());
            return;
        }
        int resourceId = attribute.getData();
        this.printEntries(apkModule, "AppIcon", resourceId);
    }

    private void printAppRoundIcon(ApkModule apkModule) throws IOException {
        int id_roundIcon;
        InfoOptions options = (InfoOptions)this.getOptions();
        if (!options.appRoundIcon) {
            return;
        }
        AndroidManifestBlock manifest = apkModule.getAndroidManifest();
        ResXmlElement application = manifest.getApplicationElement();
        ResXmlAttribute attribute = application.searchAttributeByResourceId(id_roundIcon = 16844076);
        if (attribute == null) {
            return;
        }
        if (attribute.getValueType() == ValueType.STRING) {
            this.getInfoWriter().writeNameValue("AppRoundIcon", attribute.getValueAsString());
            return;
        }
        int resourceId = attribute.getData();
        this.printEntries(apkModule, "AppRoundIcon", resourceId);
    }

    private void printUsesPermissions(ApkModule apkModule) throws IOException {
        InfoOptions options = (InfoOptions)this.getOptions();
        if (!options.permissions) {
            return;
        }
        AndroidManifestBlock manifest = apkModule.getAndroidManifest();
        if (manifest == null) {
            return;
        }
        List<String> usesPermissions = manifest.getUsesPermissions();
        if (usesPermissions.size() == 0) {
            return;
        }
        usesPermissions.sort(CompareUtil.getComparableComparator());
        String tag = AndroidManifest.TAG_uses_permission;
        InfoWriter infoWriter = this.getInfoWriter();
        infoWriter.writeArray(tag, usesPermissions.toArray(new String[0]));
    }

    private void printActivities(ApkModule apkModule) throws IOException {
        InfoOptions options = (InfoOptions)this.getOptions();
        if (!options.activities) {
            return;
        }
        AndroidManifestBlock manifest = apkModule.getAndroidManifest();
        if (manifest == null) {
            return;
        }
        List<ResXmlElement> activityList = CollectionUtil.toList(manifest.getActivities(true));
        if (activityList.size() == 0) {
            return;
        }
        ResXmlElement main = manifest.getMainActivity();
        if (main != null) {
            String value = this.getValueOfName(main);
            this.getInfoWriter().writeNameValue("activity-main", value);
        }
        if (!options.verbose) {
            return;
        }
        Object[] activityNames = new String[activityList.size()];
        for (int i = 0; i < activityList.size(); ++i) {
            ResXmlElement activity = activityList.get(i);
            activityNames[i] = this.getValueOfName(activity);
        }
        InfoWriter infoWriter = this.getInfoWriter();
        infoWriter.writeArray("activities", activityNames);
    }

    private void printAppClass(ApkModule apkModule) throws IOException {
        InfoOptions options = (InfoOptions)this.getOptions();
        if (!options.appClass) {
            return;
        }
        AndroidManifestBlock manifest = apkModule.getAndroidManifest();
        if (manifest == null) {
            return;
        }
        ResXmlElement applicationElement = manifest.getApplicationElement();
        if (applicationElement == null) {
            return;
        }
        String value = this.getValueOfName(applicationElement);
        if (value != null) {
            this.getInfoWriter().writeNameValue("application-class", value);
        }
    }

    private void printXmlStrings(ApkModule apkModule) throws IOException {
        InfoOptions options = (InfoOptions)this.getOptions();
        List<String> xmlStrings = options.xmlStrings;
        if (xmlStrings.isEmpty()) {
            return;
        }
        InfoWriter infoWriter = this.getInfoWriter();
        for (String path : xmlStrings) {
            ResXmlDocument document = apkModule.loadResXmlDocument(path);
            document.setApkFile(null);
            document.setPackageBlock(null);
            infoWriter.writeStringPool(path, document.getStringPool());
        }
    }

    private void printStrings(ApkModule apkModule) throws IOException {
        InfoOptions options = (InfoOptions)this.getOptions();
        if (!options.strings || !apkModule.hasTableBlock()) {
            return;
        }
        InfoWriter infoWriter = this.getInfoWriter();
        infoWriter.writeStringPool(TableBlock.FILE_NAME, apkModule.getTableBlock().getStringPool());
    }

    private void printXmlTree(ApkModule apkModule) throws IOException {
        InfoOptions options = (InfoOptions)this.getOptions();
        InfoWriter infoWriter = this.getInfoWriter();
        for (String path : options.xmlTree) {
            this.logMessage("Writing: " + path);
            ResXmlDocument document = apkModule.loadResXmlDocument(path);
            infoWriter.writeXmlDocument(path, document);
        }
    }

    private void listFiles(ApkModule apkModule) throws IOException {
        InfoOptions options = (InfoOptions)this.getOptions();
        if (!options.listFiles) {
            return;
        }
        InputSource[] inputSources = apkModule.getInputSources();
        int count = inputSources.length;
        Object[] names = new String[count];
        for (int i = 0; i < count; ++i) {
            names[i] = inputSources[i].getAlias();
        }
        this.getInfoWriter().writeArray("Files", names);
    }

    private void listXmlFiles(ApkModule apkModule) throws IOException {
        InfoOptions options = (InfoOptions)this.getOptions();
        if (!options.listXmlFiles) {
            return;
        }
        List<ResFile> resFileList = apkModule.listResFiles();
        ArrayList<String> names = new ArrayList<String>();
        for (ResFile resFile : resFileList) {
            if (!resFile.isBinaryXml()) continue;
            names.add(resFile.getFilePath());
        }
        this.getInfoWriter().writeArray("CompiledXmlFiles", names.toArray(new String[0]));
    }

    private void printConfigurations(ApkModule apkModule) throws IOException {
        InfoOptions options = (InfoOptions)this.getOptions();
        if (!options.configurations || !apkModule.hasTableBlock()) {
            return;
        }
        Iterator<ResConfig> iterator = apkModule.getTableBlock().getResConfigs();
        List<String> qualifiers = CollectionUtil.toUniqueList(ComputeIterator.of(iterator, config -> {
            String qualifier = config.getQualifiers();
            if (qualifier.length() != 0) {
                qualifier = qualifier.substring(1);
            }
            return qualifier;
        }));
        qualifiers.sort(CompareUtil.getComparableComparator());
        this.getInfoWriter().writeArray("configurations", qualifiers.toArray(new String[0]));
    }

    private void printLanguages(ApkModule apkModule) throws IOException {
        InfoOptions options = (InfoOptions)this.getOptions();
        if (!options.languages || !apkModule.hasTableBlock()) {
            return;
        }
        Iterator<ResConfig> iterator = apkModule.getTableBlock().getResConfigs();
        List<String> languages = CollectionUtil.toUniqueList(ComputeIterator.of(iterator, ResConfig::getLanguage));
        languages.sort(CompareUtil.getComparableComparator());
        this.getInfoWriter().writeArray("languages", languages.toArray(new String[0]));
    }

    private void printLocales(ApkModule apkModule) throws IOException {
        InfoOptions options = (InfoOptions)this.getOptions();
        if (!options.locales || !apkModule.hasTableBlock()) {
            return;
        }
        Iterator<ResConfig> iterator = apkModule.getTableBlock().getResConfigs();
        List<String> locales = CollectionUtil.toUniqueList(ComputeIterator.of(iterator, ResConfig::getLocale));
        locales.remove("");
        locales.sort(CompareUtil.getComparableComparator());
        this.getInfoWriter().writeArray("locales", locales.toArray(new String[0]));
    }

    private String getValueOfName(ResXmlElement element) {
        ResXmlAttribute attribute = element.searchAttributeByResourceId(AndroidManifest.ID_name);
        if (attribute == null) {
            return null;
        }
        return attribute.getValueAsString();
    }

    private void printEntries(ApkModule apkModule, String varName, int resourceId) throws IOException {
        TableBlock tableBlock = apkModule.getTableBlock();
        InfoWriter infoWriter = this.getInfoWriter();
        if (tableBlock == null) {
            infoWriter.writeNameValue(varName, HexUtil.toHex8("@0x", resourceId));
            return;
        }
        List<Entry> entryList = tableBlock.resolveReference(resourceId);
        if (entryList.size() == 0) {
            this.logWarn("WARN: Can't find resource: " + HexUtil.toHex8("@0x", resourceId));
            return;
        }
        entryList = Info.sortEntries(entryList);
        InfoOptions options = (InfoOptions)this.getOptions();
        if (!options.verbose) {
            infoWriter.writeNameValue(varName, this.getValueAsString(entryList.get(0)));
            return;
        }
        infoWriter.writeEntries(varName, entryList);
    }

    private String getValueAsString(Entry entry) {
        ResValue resValue = entry.getResValue();
        if (resValue == null) {
            return "";
        }
        ValueType valueType = resValue.getValueType();
        if (valueType == ValueType.STRING) {
            return resValue.getValueAsString();
        }
        String decoded = ValueCoder.decode(valueType, resValue.getData());
        if (decoded != null) {
            return decoded;
        }
        return HexUtil.toHex8("@0x", resValue.getData());
    }

    private InfoWriter getInfoWriter() throws IOException {
        if (this.mInfoWriter != null) {
            return this.mInfoWriter;
        }
        InfoOptions options = (InfoOptions)this.getOptions();
        Writer writer = this.createWriter();
        InfoWriter infoWriter = "json".equals(options.type) ? new InfoWriterJson(writer) : ("xml".equals(options.type) ? new InfoWriterXml(writer) : new InfoWriterText(writer));
        this.mInfoWriter = infoWriter;
        return this.mInfoWriter;
    }

    private Writer createWriter() throws IOException {
        InfoOptions options = (InfoOptions)this.getOptions();
        File file = options.outputFile;
        if (file == null) {
            return new PrintWriter(System.out);
        }
        File dir = file.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        return new OutputStreamWriter(new FileOutputStream(file));
    }

    private void flush() throws IOException {
        InfoWriter writer = this.mInfoWriter;
        if (writer != null) {
            writer.flush();
        }
    }

    private void close() throws IOException {
        InfoWriter writer = this.mInfoWriter;
        if (writer != null) {
            writer.close();
            this.mInfoWriter = null;
        }
    }

    private static List<Entry> sortEntries(Collection<Entry> entryCollection) {
        ArrayList<Entry> results = entryCollection instanceof ArrayList ? (ArrayList<Entry>)entryCollection : new ArrayList<Entry>(entryCollection);
        Comparator<Entry> cmp = new Comparator<Entry>(){

            @Override
            public int compare(Entry entry1, Entry entry2) {
                return entry1.getResConfig().compareTo(entry2.getResConfig());
            }
        };
        results.sort(cmp);
        return results;
    }
}

