/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.info;

import com.reandroid.archive.block.ApkSignatureBlock;
import com.reandroid.archive.block.CertificateBlock;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.coder.ValueCoder;
import com.reandroid.arsc.container.SpecTypePair;
import com.reandroid.arsc.model.ResourceEntry;
import com.reandroid.arsc.pool.StringPool;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.Value;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.dex.model.DexDirectory;
import com.reandroid.dex.model.DexFile;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.collection.CollectionUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class InfoWriter
implements Closeable {
    private final Writer writer;
    static final String TAG_RES_PACKAGES = "resource-packages";
    static final String TAG_PUBLIC = "public";
    static final String TAG_RESOURCES = "resources";
    static final String NAME_RESOURCE = "resource";
    static final String TAG_CONFIG = "config";
    static final String TAG_VALUE = "value";
    static final String TAG_BAG = "bag";
    static final String TAG_ITEM = "item";
    static final String NAME_QUALIFIERS = "qualifiers";

    public InfoWriter(Writer writer) {
        this.writer = writer;
    }

    public void writeSignatureInfo(ApkSignatureBlock signatureBlock, boolean base64) throws IOException {
        if (signatureBlock == null) {
            this.writeNameValue("certificates", "null");
        } else {
            this.writeCertificates(CollectionUtil.toList(signatureBlock.getCertificates()), base64);
        }
    }

    public void writeResources(PackageBlock packageBlock, List<String> typeFilters, boolean writeEntries) throws IOException {
        Iterator<ResourceEntry> itr = packageBlock.getResources();
        while (itr.hasNext()) {
            ResourceEntry resourceEntry = itr.next();
            this.writeResources(resourceEntry, writeEntries);
        }
    }

    public void writeDexInfo(DexDirectory dexDirectory) throws IOException {
        for (DexFile dexFile : dexDirectory) {
            this.writeDexInfo(dexFile, true);
        }
    }

    public abstract void writeStringPool(String var1, StringPool<?> var2) throws IOException;

    public abstract void writeXmlDocument(String var1, ResXmlDocument var2) throws IOException;

    public abstract void writeCertificates(List<CertificateBlock> var1, boolean var2) throws IOException;

    public abstract void writeDexInfo(DexFile var1, boolean var2) throws IOException;

    public abstract void writeResources(ResourceEntry var1, boolean var2) throws IOException;

    public abstract void writePackageNames(Collection<PackageBlock> var1) throws IOException;

    public abstract void writeEntries(String var1, List<Entry> var2) throws IOException;

    public abstract void writeArray(String var1, Object[] var2) throws IOException;

    public abstract void writeNameValue(String var1, Object var2) throws IOException;

    public abstract void flush() throws IOException;

    boolean contains(SpecTypePair specTypePair, List<String> filterList) {
        if (filterList.size() == 0) {
            return true;
        }
        return filterList.contains(specTypePair.getTypeName());
    }

    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    static String toString(Object obj) {
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    static String getValueAsString(Value value) {
        ValueType valueType = value.getValueType();
        if (valueType == ValueType.STRING) {
            return value.getValueAsString();
        }
        String decoded = ValueCoder.decode(valueType, value.getData());
        if (decoded != null) {
            return decoded;
        }
        if (valueType == ValueType.ATTRIBUTE) {
            return HexUtil.toHex8("?0x", value.getData());
        }
        if (valueType == ValueType.REFERENCE) {
            return HexUtil.toHex8("@0x", value.getData());
        }
        return HexUtil.toHex8("0x", value.getData());
    }

    static String toBase64(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    static void writeSpaces(Writer writer, int amount) throws IOException {
        for (int i = 0; i < amount; ++i) {
            writer.append(' ');
        }
    }
}

