/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.protect;

import com.reandroid.apkeditor.protect.DexConfuseTask;
import com.reandroid.dex.ins.InsArrayData;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.model.DexInstruction;
import com.reandroid.dex.model.DexMethod;
import java.util.Random;

public class DexArrayPayloadConfuser
extends DexConfuseTask {
    private final Random mRandom = new Random();

    public DexArrayPayloadConfuser() {
        super("array-data-confuser: ");
    }

    @Override
    public int confuseLevel() {
        return 1;
    }

    @Override
    public boolean apply(DexMethod dexMethod) {
        if (this.isBlankOrAlreadyConfused(dexMethod)) {
            return false;
        }
        DexInstruction instruction = dexMethod.addInstruction(Opcode.ARRAY_PAYLOAD);
        InsArrayData arrayData = (InsArrayData)instruction.getIns();
        arrayData.setWidth(this.getRandomWidth());
        arrayData.setSize(this.getRandomCount());
        int size = arrayData.size();
        for (int i = 0; i < size; ++i) {
            this.fillRandom(arrayData.get(i).getBytes());
        }
        return true;
    }

    private boolean isBlankOrAlreadyConfused(DexMethod dexMethod) {
        int insCount = dexMethod.getInstructionsCount();
        if (insCount == 0) {
            return true;
        }
        DexInstruction instruction = dexMethod.getInstruction(insCount - 1);
        if (!instruction.is(Opcode.ARRAY_PAYLOAD)) {
            return false;
        }
        InsArrayData arrayData = (InsArrayData)instruction.getIns();
        int width = arrayData.getWidth();
        return width == 0 || width > 8 || width % 2 == 1;
    }

    private void fillRandom(byte[] bytes) {
        int num = this.getRandom();
        int length = bytes.length;
        for (int i = 0; i < length; ++i) {
            if (num == 0) {
                num = this.getRandom();
            }
            bytes[i] = (byte)(num & 0xFF);
            num >>>= 8;
        }
    }

    private int getRandomWidth() {
        int i = this.mRandom.nextInt(16) + 3;
        if (i % 2 == 0) {
            ++i;
        }
        return i;
    }

    private int getRandomCount() {
        return this.mRandom.nextInt(6) + 1;
    }

    private int getRandom() {
        return this.mRandom.nextInt(Integer.MAX_VALUE);
    }
}

