/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.protect;

import com.reandroid.apk.APKLogger;
import com.reandroid.dex.model.DexClass;
import com.reandroid.dex.model.DexMethod;
import java.util.Iterator;

public abstract class DexConfuseTask
implements APKLogger {
    private APKLogger logger;
    private String logTag;
    private long mTotalCount;

    public DexConfuseTask(String logTag) {
        this.logTag = logTag;
    }

    public DexConfuseTask() {
        this.logTag = this.getClass().getSimpleName() + ": ";
    }

    public abstract int confuseLevel();

    public boolean isEnabled(int level) {
        return level >= this.confuseLevel();
    }

    public boolean apply(DexClass dexClass) {
        boolean result = false;
        dexClass.edit();
        Iterator<DexMethod> iterator = dexClass.getDeclaredMethods();
        while (iterator.hasNext()) {
            if (!this.apply(iterator.next())) continue;
            this.addCount();
            result = true;
        }
        return result;
    }

    public abstract boolean apply(DexMethod var1);

    public long getTotalCount() {
        return this.mTotalCount;
    }

    public void setTotalCount(long count) {
        this.mTotalCount = count;
    }

    public void addCount() {
        this.setTotalCount(this.getTotalCount() + 1L);
    }

    public void logSummary() {
        this.logMessage("total = " + this.getTotalCount());
    }

    public void setLogTag(String logTag) {
        this.logTag = logTag;
    }

    public DexConfuseTask setLogger(APKLogger logger) {
        this.logger = logger;
        return this;
    }

    @Override
    public void logMessage(String message) {
        APKLogger logger = this.logger;
        if (logger != null) {
            logger.logMessage(this.logTag + message);
        }
    }

    @Override
    public void logError(String message, Throwable throwable) {
        APKLogger logger = this.logger;
        if (logger != null) {
            logger.logError(this.logTag + message, throwable);
        }
    }

    @Override
    public void logVerbose(String message) {
        APKLogger logger = this.logger;
        if (logger != null) {
            logger.logVerbose(message);
        }
    }
}

