/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.protect;

import com.reandroid.apk.ApkModule;
import com.reandroid.apk.DexFileInputSource;
import com.reandroid.apkeditor.protect.Confuser;
import com.reandroid.apkeditor.protect.DexArrayPayloadConfuser;
import com.reandroid.apkeditor.protect.DexConfuseTask;
import com.reandroid.apkeditor.protect.DexStringFogger;
import com.reandroid.apkeditor.protect.Protector;
import com.reandroid.archive.ByteInputSource;
import com.reandroid.archive.InputSource;
import com.reandroid.dex.model.DexClass;
import com.reandroid.dex.model.DexFile;
import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.FilterIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class DexConfuser
extends Confuser {
    private final ArrayCollection<DexConfuseTask> mTaskList;

    public DexConfuser(Protector protector, DexConfuseTask ... tasks) {
        super(protector, "DexConfuser: ");
        this.mTaskList = new ArrayCollection(tasks);
    }

    public DexConfuser(Protector protector) {
        this(protector, new DexArrayPayloadConfuser().setLogger(protector), new DexStringFogger().setLogger(protector));
    }

    @Override
    public void confuse() {
        if (!this.isEnabled()) {
            this.logMessage("Skip");
            return;
        }
        ApkModule apkModule = this.getApkModule();
        List<DexFileInputSource> dexFiles = this.getApkModule().listDexFiles();
        if (dexFiles.isEmpty()) {
            this.logMessage("Dex files not found");
            return;
        }
        this.logMessage("Confusing " + dexFiles.size() + " dex files ...");
        for (DexFileInputSource inputSource : dexFiles) {
            InputSource modified = this.confuse(inputSource);
            if (modified == null) continue;
            apkModule.add(modified);
        }
        List<DexConfuseTask> taskList = this.getTasks();
        for (DexConfuseTask task : taskList) {
            task.logSummary();
        }
    }

    private InputSource confuse(InputSource inputSource) {
        this.logMessage(inputSource.getAlias());
        DexFile dexFile = this.load(inputSource);
        ByteInputSource result = null;
        if (this.confuse(dexFile)) {
            result = new ByteInputSource(this.save(dexFile), inputSource.getAlias());
            result.copyAttributes(inputSource);
        }
        dexFile.close();
        return result;
    }

    private byte[] save(DexFile dexFile) {
        dexFile.refresh();
        dexFile.shrink();
        dexFile.refreshFull();
        return dexFile.getBytes();
    }

    private boolean confuse(DexFile dexFile) {
        List<DexConfuseTask> taskList = this.getTasks();
        boolean result = false;
        Iterator<DexClass> iterator = dexFile.getDexClasses();
        while (iterator.hasNext()) {
            DexClass dexClass = iterator.next();
            for (DexConfuseTask task : taskList) {
                if (!task.apply(dexClass)) continue;
                result = true;
            }
        }
        return result;
    }

    private DexFile load(InputSource inputSource) {
        try {
            DexFile dexFile = DexFile.read(inputSource.openStream());
            dexFile.setSimpleName(inputSource.getSimpleName());
            return dexFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private int getLevel() {
        return this.getProtector().getOptions().dexLevel;
    }

    public Iterator<DexConfuseTask> getAllTasks() {
        return this.mTaskList.iterator();
    }

    public boolean isEnabled() {
        if (this.getLevel() <= 0) {
            return false;
        }
        return !this.getTasks().isEmpty();
    }

    public List<DexConfuseTask> getTasks() {
        int level = this.getLevel();
        return CollectionUtil.toList(FilterIterator.of(this.getAllTasks(), task -> task.isEnabled(level)));
    }
}

