/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.protect;

import com.reandroid.apk.ApkModule;
import com.reandroid.apk.ResFile;
import com.reandroid.apk.UncompressedFiles;
import com.reandroid.apkeditor.protect.Confuser;
import com.reandroid.apkeditor.protect.Protector;
import com.reandroid.apkeditor.utils.CyclicIterator;
import com.reandroid.archive.Archive;

public class DirectoryConfuser
extends Confuser {
    private final CyclicIterator<String> namesIterator;

    public DirectoryConfuser(Protector protector) {
        super(protector, "DirectoryConfuser: ");
        this.namesIterator = new CyclicIterator<String>(protector.getOptions().loadDirectoryNameDictionary());
    }

    @Override
    public void confuse() {
        this.logMessage("Confusing ...");
        ApkModule apkModule = this.getApkModule();
        UncompressedFiles uf = apkModule.getUncompressedFiles();
        for (ResFile resFile : this.getApkModule().listResFiles()) {
            int method = resFile.getInputSource().getMethod();
            String pathNew = this.generateNewPath(resFile);
            if (pathNew == null) continue;
            String path = resFile.getFilePath();
            if (method == Archive.STORED) {
                uf.replacePath(path, pathNew);
            }
            resFile.setFilePath(pathNew);
            this.onPathChanged(path, pathNew);
        }
    }

    private String generateNewPath(ResFile resFile) {
        if (this.isKeepType(resFile.pickOne().getTypeName())) {
            return null;
        }
        return this.generateNewPath(resFile.getFilePath());
    }

    private String generateNewPath(String path) {
        CyclicIterator<String> iterator = this.namesIterator;
        iterator.resetCycleCount();
        while (iterator.getCycleCount() == 0) {
            String newPath = DirectoryConfuser.replaceDirectory(path, iterator.next());
            if (this.containsFilePath(newPath)) continue;
            return newPath;
        }
        return null;
    }

    private static String replaceDirectory(String path, String dirName) {
        int i = path.lastIndexOf(47);
        if (i < 0) {
            i = 0;
        } else if (++i == path.length()) {
            --i;
        }
        String simpleName = path.substring(i);
        if (dirName.length() != 0) {
            dirName = dirName + "/";
        }
        return dirName + simpleName;
    }
}

