/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.protect;

import com.reandroid.apk.ApkModule;
import com.reandroid.apkeditor.CommandExecutor;
import com.reandroid.apkeditor.Util;
import com.reandroid.apkeditor.protect.DexConfuser;
import com.reandroid.apkeditor.protect.DirectoryConfuser;
import com.reandroid.apkeditor.protect.FileNameConfuser;
import com.reandroid.apkeditor.protect.ManifestConfuser;
import com.reandroid.apkeditor.protect.ProtectedFileWriter;
import com.reandroid.apkeditor.protect.ProtectorOptions;
import com.reandroid.apkeditor.protect.TableConfuser;
import java.io.File;
import java.io.IOException;

public class Protector
extends CommandExecutor<ProtectorOptions> {
    private ApkModule mApkModule;

    public Protector(ProtectorOptions options) {
        super(options, "[PROTECT] ");
    }

    public ApkModule getApkModule() {
        return this.mApkModule;
    }

    public void setApkModule(ApkModule apkModule) {
        this.mApkModule = apkModule;
    }

    @Override
    public ProtectorOptions getOptions() {
        return (ProtectorOptions)super.getOptions();
    }

    @Override
    public void runCommand() throws IOException {
        ProtectorOptions options = this.getOptions();
        this.delete(options.outputFile);
        ApkModule module = ApkModule.loadApkFile(this, options.inputFile, new File[0]);
        module.setLoadDefaultFramework(false);
        String protect = Util.isProtected(module);
        if (protect != null) {
            this.logMessage(options.inputFile.getAbsolutePath());
            this.logMessage(protect);
            return;
        }
        this.setApkModule(module);
        new ManifestConfuser(this).confuse();
        new DirectoryConfuser(this).confuse();
        new FileNameConfuser(this).confuse();
        new TableConfuser(this).confuse();
        new DexConfuser(this).confuse();
        module.getTableBlock().refresh();
        this.logMessage("Writing apk ...");
        if (options.confuse_zip) {
            this.logMessage("Confusing zip structure ...");
            new ProtectedFileWriter(module, options.outputFile).write();
        } else {
            module.writeApk(options.outputFile);
        }
        module.close();
        this.logMessage("Saved to: " + options.outputFile);
    }
}

