/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.protect;

import com.reandroid.apkeditor.Options;
import com.reandroid.apkeditor.protect.Protector;
import com.reandroid.jcommand.annotations.CommandOptions;
import com.reandroid.jcommand.annotations.OptionArg;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.io.FileUtil;
import com.reandroid.utils.io.IOUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;

@CommandOptions(name="p", alternates={"protect"}, description="protect_description", examples={"protect_example_1"})
public class ProtectorOptions
extends Options {
    @OptionArg(name="-skip-manifest", flag=true, description="protect_skip_manifest")
    public boolean skipManifest;
    @OptionArg(name="-confuse-zip", flag=true, description="protect_confuse_zip")
    public boolean confuse_zip;
    @OptionArg(name="-keep-type", description="protect_keep_type")
    public final Set<String> keepTypes = new HashSet<String>();
    @OptionArg(name="-dic-dir-names", flag=true, description="protect_dic_dir_name")
    public File dic_dir_name;
    @OptionArg(name="-dic-file-names", flag=true, description="protect_dic_file_name")
    public File dic_file_name;
    @OptionArg(name="-dex-level", description="dex_protect_level")
    public int dexLevel;
    private static final String KEEP_ALL_TYPES = "all-types";

    @Override
    public void validateValues() {
        super.validateValues();
        this.addDefaultKeepTypes();
    }

    private void addDefaultKeepTypes() {
        Set<String> keepTypes = this.keepTypes;
        if (!keepTypes.isEmpty()) {
            return;
        }
        keepTypes.add("font");
    }

    public Protector newCommandExecutor() {
        return new Protector(this);
    }

    @Override
    public void validateInput(boolean isFile, boolean isDirectory) {
        super.validateInput(true, false);
    }

    @Override
    public void validateOutput(boolean isFile) {
        super.validateOutput(true);
    }

    @Override
    public File generateOutputFromInput(File input) {
        return this.generateOutputFromInput(input, "_protected.apk");
    }

    public String[] loadDirectoryNameDictionary() {
        return this.loadDictionary(this.dic_dir_name, "/protect_dic_dir_name.txt");
    }

    public String[] loadFileNameDictionary() {
        return this.loadDictionary(this.dic_file_name, "/protect_dic_file_name.txt");
    }

    private String[] loadDictionary(File file, String resource) {
        String full;
        InputStream inputStream;
        if (file != null) {
            try {
                inputStream = FileUtil.inputStream(file);
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        } else {
            inputStream = ProtectorOptions.class.getResourceAsStream(resource);
        }
        try {
            full = IOUtil.readUtf8(inputStream);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        ArrayCollection<String> results = new ArrayCollection<String>(StringsUtil.split(full, '\n', true));
        results.removeIf(StringsUtil::isEmpty);
        return results.toArray((T1[])new String[results.size()]);
    }

    public boolean isKeepType(String type) {
        Set<String> keepTypes = this.keepTypes;
        return keepTypes.contains(type) || keepTypes.contains(KEEP_ALL_TYPES);
    }

    public boolean isKeepAllTypes() {
        return this.keepTypes.contains(KEEP_ALL_TYPES);
    }
}

