/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.refactor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class HtmlColor {
    private static final String RES_NAME_PREFIX = "col_";
    private static Map<Integer, HtmlColor> knownColors;
    private final String name;
    private final int alpha;
    private final int red;
    private final int green;
    private final int blue;
    private String mSplitName;
    private static final Pattern PATTERN_LINE;

    HtmlColor(String hex) {
        this(null, hex);
    }

    HtmlColor(String name, String hex) {
        this(name, HtmlColor.parseHex(hex));
    }

    HtmlColor(String name, int val) {
        if (name != null && name.trim().length() == 0) {
            name = null;
        }
        this.name = name;
        this.alpha = val >> 24 & 0xFF;
        this.red = val >> 16 & 0xFF;
        this.green = val >> 8 & 0xFF;
        this.blue = val & 0xFF;
    }

    String getName() {
        return this.name;
    }

    int getARGBValue() {
        return (this.alpha << 24) + (this.red << 16) + (this.green << 8) + this.blue;
    }

    int getRGBValue() {
        return (this.red << 16) + (this.green << 8) + this.blue;
    }

    String getRGBHex() {
        return HtmlColor.toRgbHex(this.getRGBValue());
    }

    String getARGBHex() {
        return HtmlColor.toARgbHex(this.getARGBValue());
    }

    String toResourceName() {
        return this.getSplitName();
    }

    private String getSplitName() {
        if (this.mSplitName == null) {
            this.mSplitName = HtmlColor.splitByUpperCase(RES_NAME_PREFIX, this.getName());
        }
        return this.mSplitName;
    }

    double getDistance(HtmlColor htmlColor) {
        double d1 = this.red - htmlColor.red;
        d1 *= d1;
        double d2 = this.green - htmlColor.green;
        d2 *= d2;
        double d3 = this.blue - htmlColor.blue;
        d3 *= d3;
        return Math.sqrt(d1 + d2 + d3);
    }

    boolean isEqualRGB(HtmlColor htmlColor, double tolerance) {
        double dis = this.getDistance(htmlColor);
        return dis <= tolerance;
    }

    int getAlpha() {
        return this.alpha;
    }

    private int getRed() {
        return this.red;
    }

    private int getGreen() {
        return this.green;
    }

    private int getBlue() {
        return this.blue;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getRGBHex());
        String n = this.getName();
        if (n != null) {
            builder.append(": ");
            builder.append(this.getName());
            builder.append(", ");
            builder.append("@color/");
            builder.append(this.getSplitName());
        }
        return builder.toString();
    }

    private static String splitByUpperCase(String prefix, String colorName) {
        if (colorName == null) {
            return null;
        }
        colorName = colorName.trim();
        char[] allChars = colorName.toCharArray();
        int max = allChars.length;
        boolean appendSeparator = false;
        StringBuilder builder = new StringBuilder();
        if (prefix != null) {
            builder.append(prefix);
        }
        for (int i = 0; i < max; ++i) {
            char ch = allChars[i];
            if (ch == ' ') {
                if (appendSeparator) continue;
                builder.append("_");
                appendSeparator = true;
                continue;
            }
            if (i > 0 && Character.isUpperCase(ch) && !appendSeparator) {
                builder.append("_");
                ch = Character.toLowerCase(ch);
                builder.append(ch);
                appendSeparator = true;
                continue;
            }
            ch = Character.toLowerCase(ch);
            builder.append(ch);
            appendSeparator = false;
        }
        return builder.toString();
    }

    private static String toRgbHex(int i) {
        return String.format("#%06x", i);
    }

    private static String toARgbHex(int i) {
        return String.format("#%08x", i);
    }

    private static int parseHex(String str) {
        boolean isNegative = false;
        if (str.startsWith("#")) {
            str = str.substring(1);
        }
        if (str.startsWith("-")) {
            str = str.substring(1);
            isNegative = true;
        }
        if (str.startsWith("0x")) {
            str = str.substring(2);
        }
        str = str.toUpperCase();
        long l = Long.parseLong(str, 16);
        if (isNegative) {
            l = -l;
        }
        return (int)l;
    }

    static HtmlColor getBestMatch(HtmlColor htmlColor, double tolerance) {
        Map<Integer, HtmlColor> knownMap = HtmlColor.getKnownColors();
        HtmlColor result = knownMap.get(htmlColor.getRGBValue());
        if (result != null) {
            return result;
        }
        double foundDis = 0.0;
        for (HtmlColor color : knownMap.values()) {
            double dis = color.getDistance(htmlColor);
            if (dis > tolerance) continue;
            if (result == null) {
                foundDis = dis;
                result = color;
                continue;
            }
            if (!(dis < foundDis)) continue;
            foundDis = dis;
            result = color;
            if (dis != 0.0) continue;
            break;
        }
        return result;
    }

    private static Map<Integer, HtmlColor> getKnownColors() {
        if (knownColors == null) {
            knownColors = HtmlColor.loadColorNames();
        }
        return knownColors;
    }

    private static Map<Integer, HtmlColor> loadColorNames() {
        HashMap<Integer, HtmlColor> results = new HashMap<Integer, HtmlColor>();
        InputStream in = HtmlColor.getColorNamesResource();
        if (in == null) {
            return results;
        }
        InputStreamReader inReader = new InputStreamReader(in);
        BufferedReader reader = new BufferedReader(inReader);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                HtmlColor htmlColor = HtmlColor.parseLine(line);
                if (htmlColor == null) continue;
                Integer val = htmlColor.getRGBValue();
                results.putIfAbsent(val, htmlColor);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return results;
    }

    private static InputStream getColorNamesResource() {
        try {
            return HtmlColor.class.getResourceAsStream("/color_names.txt");
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static HtmlColor parseLine(String line) {
        Matcher matcher = PATTERN_LINE.matcher(line);
        if (!matcher.find()) {
            return null;
        }
        String hex = matcher.group(1);
        String name = matcher.group(2);
        return new HtmlColor(name, hex);
    }

    static {
        PATTERN_LINE = Pattern.compile("^\\s*(#[A-fa-f0-9]{6,8})\\s*,\\s*([^\\s]+.*[^\\s]+)\\s*$");
    }
}

