/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive;

import com.reandroid.archive.Archive;
import com.reandroid.archive.ArchiveEntry;
import com.reandroid.archive.InputSource;
import com.reandroid.archive.io.ArchiveFileEntrySource;
import com.reandroid.archive.io.ZipFileInput;
import com.reandroid.utils.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class ArchiveFile
extends Archive<ZipFileInput> {
    public ArchiveFile(ZipFileInput zipInput) throws IOException {
        super(zipInput);
    }

    public ArchiveFile(File file) throws IOException {
        this(new ZipFileInput(file));
    }

    @Override
    InputSource createInputSource(ArchiveEntry entry) {
        return new ArchiveFileEntrySource((ZipFileInput)this.getZipInput(), entry);
    }

    @Override
    void extractStored(File file, ArchiveEntry archiveEntry) throws IOException {
        long transferred;
        FileChannel outputChannel = FileUtil.openWriteChannel(file);
        FileChannel fileChannel = ((ZipFileInput)this.getZipInput()).getFileChannel();
        fileChannel.position(archiveEntry.getFileOffset());
        long totalTransferred = 0L;
        for (long remaining = archiveEntry.getDataSize(); remaining > 0L; remaining -= transferred) {
            transferred = outputChannel.transferFrom(fileChannel, totalTransferred, remaining);
            totalTransferred += transferred;
        }
        outputChannel.close();
    }
}

