/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive.block;

import com.reandroid.archive.ZipSignature;
import com.reandroid.archive.block.LocalFileHeader;
import com.reandroid.archive.block.ZipHeader;
import com.reandroid.utils.HexUtil;

public class DataDescriptor
extends ZipHeader {
    private static final int OFFSET_crc = 4;
    private static final int OFFSET_compressed_size = 8;
    private static final int OFFSET_size = 12;
    public static final int MIN_LENGTH = 16;

    public DataDescriptor() {
        super(16, ZipSignature.DATA_DESCRIPTOR);
    }

    public DataDescriptor copy() {
        DataDescriptor dd = new DataDescriptor();
        dd.setSignature(ZipSignature.DATA_DESCRIPTOR);
        dd.setCrc(this.getCrc());
        dd.setCompressedSize(this.getCompressedSize());
        dd.setSize(this.getSize());
        return dd;
    }

    public long getCrc() {
        return this.getIntegerUnsigned(4);
    }

    public void setCrc(long value) {
        this.putInteger(4, value);
    }

    public long getCompressedSize() {
        return this.getIntegerUnsigned(8);
    }

    public void setCompressedSize(long value) {
        this.putInteger(8, value);
    }

    public long getSize() {
        return this.getIntegerUnsigned(12);
    }

    public void setSize(long value) {
        this.putInteger(12, value);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append((Object)this.getSignature());
        builder.append(", crc=").append(HexUtil.toHex8(this.getCrc()));
        builder.append(", compressed=").append(this.getCompressedSize());
        builder.append(", size=").append(this.getSize());
        return builder.toString();
    }

    public static DataDescriptor fromLocalFile(LocalFileHeader lfh) {
        DataDescriptor dataDescriptor = new DataDescriptor();
        dataDescriptor.setSignature(ZipSignature.DATA_DESCRIPTOR);
        dataDescriptor.setSize(lfh.getSize());
        dataDescriptor.setCompressedSize(lfh.getCompressedSize());
        dataDescriptor.setCrc(lfh.getCrc());
        return dataDescriptor;
    }
}

