/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive.block;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockCreator;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.container.FixedBlockContainer;
import com.reandroid.arsc.container.SingleBlockContainer;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.BlockItem;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.LongItem;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public abstract class LengthPrefixedList<T extends Block>
extends FixedBlockContainer
implements BlockCreator<T>,
Iterable<T> {
    private final Block numberBlock;
    private final BlockList<T> elements;
    private final SingleBlockContainer<Block> bottomContainer;

    public LengthPrefixedList(boolean is_long) {
        super(3);
        BlockItem numberBlock = is_long ? new LongItem() : new IntegerItem();
        this.numberBlock = numberBlock;
        this.elements = new BlockList();
        this.bottomContainer = new SingleBlockContainer();
        this.addChild(0, this.numberBlock);
        this.addChild(1, this.elements);
        this.addChild(2, this.bottomContainer);
    }

    public long getDataSize() {
        Block numberBlock = this.numberBlock;
        if (numberBlock instanceof LongItem) {
            return ((LongItem)numberBlock).getLong();
        }
        return ((IntegerItem)numberBlock).get();
    }

    public void setDataSize(long dataSize) {
        Block numberBlock = this.numberBlock;
        if (numberBlock instanceof LongItem) {
            ((LongItem)numberBlock).set(dataSize);
        } else {
            ((IntegerItem)numberBlock).set((int)dataSize);
        }
    }

    public int size() {
        return this.elements.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.elements.iterator();
    }

    public List<T> getElements() {
        return this.elements.getChildes();
    }

    public T add(T element) {
        this.elements.add(element);
        return element;
    }

    public boolean remove(T element) {
        return this.elements.remove(element);
    }

    public void sort(Comparator<T> comparator) {
        this.elements.sort(comparator);
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        if (!reader.isAvailable()) {
            return;
        }
        this.numberBlock.readBytes(reader);
        int totalSize = (int)this.getDataSize();
        if (totalSize <= 0) {
            return;
        }
        BlockReader chunkReader = reader.create(totalSize);
        this.readElements(chunkReader);
        this.bottomContainer.readBytes(chunkReader);
        reader.offset(totalSize);
    }

    private void readElements(BlockReader reader) throws IOException {
        int preserve = this.bottomContainer.countBytes() + 4;
        while (reader.available() > preserve) {
            int position = reader.getPosition();
            Object element = this.newInstance();
            element = this.add(element);
            ((Block)element).readBytes(reader);
            if (position != reader.getPosition()) continue;
            break;
        }
    }

    @Override
    protected void onRefreshed() {
        int size = this.countBytes() - this.numberBlock.countBytes();
        this.setDataSize(size);
    }

    public Block getBottomBlock() {
        return this.bottomContainer.getItem();
    }

    public void setBottomBlock(Block block) {
        this.bottomContainer.setItem(block);
    }

    public String toString() {
        return "size=" + this.numberBlock + ", count=" + this.size();
    }
}

