/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive.io;

import com.reandroid.archive.Archive;
import com.reandroid.archive.ArchiveEntry;
import com.reandroid.archive.io.ArchiveEntrySource;
import com.reandroid.archive.io.ZipFileInput;
import com.reandroid.utils.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class ArchiveFileEntrySource
extends ArchiveEntrySource<ZipFileInput> {
    public ArchiveFileEntrySource(ZipFileInput zipInput, ArchiveEntry archiveEntry) {
        super(zipInput, archiveEntry);
        this.setSort(archiveEntry.getIndex());
    }

    @Override
    public byte[] getBytes(int length) throws IOException {
        FileChannel fileChannel = this.getFileChannel();
        if (this.getMethod() != Archive.STORED || fileChannel == null) {
            return super.getBytes(length);
        }
        byte[] bytes = new byte[length];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        fileChannel.read(byteBuffer);
        return bytes;
    }

    FileChannel getFileChannel() throws IOException {
        ZipFileInput zipInput = (ZipFileInput)this.getZipSource();
        FileChannel fileChannel = zipInput.getFileChannel();
        fileChannel.position(this.getArchiveEntry().getFileOffset());
        return fileChannel;
    }

    @Override
    public void write(File file) throws IOException {
        long transferred;
        FileChannel fileChannel = this.getFileChannel();
        if (this.getMethod() != Archive.STORED || fileChannel == null) {
            super.write(file);
            return;
        }
        FileChannel outputChannel = FileUtil.openWriteChannel(file);
        long totalTransferred = 0L;
        for (long remaining = this.getLength(); remaining > 0L; remaining -= transferred) {
            transferred = outputChannel.transferFrom(fileChannel, totalTransferred, remaining);
            totalTransferred += transferred;
        }
        outputChannel.close();
    }
}

