/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive.io;

import com.reandroid.archive.io.FileChannelOutputStream;
import com.reandroid.archive.io.ZipOutput;
import com.reandroid.utils.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class ZipFileOutput
extends ZipOutput {
    private final File file;
    private FileChannel fileChannel;
    private FileChannelOutputStream outputStream;

    public ZipFileOutput(File file) throws IOException {
        ZipFileOutput.initFile(file);
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void write(FileChannel input, long length) throws IOException {
        long transferred;
        FileChannel fileChannel = this.getFileChannel();
        long pos = fileChannel.position();
        long totalTransferred = 0L;
        for (long remaining = length; remaining > 0L; remaining -= transferred) {
            transferred = fileChannel.transferFrom(input, pos + totalTransferred, remaining);
            totalTransferred += transferred;
        }
        fileChannel.position(pos + totalTransferred);
    }

    @Override
    public long position() throws IOException {
        return this.getFileChannel().position();
    }

    @Override
    public void position(long pos) throws IOException {
        this.getFileChannel().position(pos);
    }

    @Override
    public void close() throws IOException {
        FileChannel fileChannel = this.fileChannel;
        if (fileChannel != null) {
            fileChannel.close();
        }
    }

    @Override
    public boolean isOpen() {
        FileChannel fileChannel = this.fileChannel;
        if (fileChannel != null) {
            return fileChannel.isOpen();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileChannel getFileChannel() throws IOException {
        FileChannel fileChannel = this.fileChannel;
        if (fileChannel != null) {
            return fileChannel;
        }
        ZipFileOutput zipFileOutput = this;
        synchronized (zipFileOutput) {
            this.fileChannel = fileChannel = FileUtil.openWriteChannel(this.file);
            return fileChannel;
        }
    }

    @Override
    public void write(InputStream inputStream) throws IOException {
        int read;
        FileChannel fileChannel = this.getFileChannel();
        long pos = fileChannel.position();
        int bufferLength = 10240000;
        byte[] buffer = new byte[bufferLength];
        long result = 0L;
        while ((read = inputStream.read(buffer, 0, bufferLength)) > 0) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(buffer, 0, read);
            fileChannel.write(byteBuffer);
            result += (long)read;
        }
        inputStream.close();
        fileChannel.position(pos + result);
    }

    @Override
    public FileChannelOutputStream getOutputStream() throws IOException {
        FileChannelOutputStream outputStream = this.outputStream;
        if (outputStream == null) {
            this.outputStream = outputStream = new FileChannelOutputStream(this.getFileChannel());
        }
        return outputStream;
    }

    private static void initFile(File file) throws IOException {
        if (file.isDirectory()) {
            throw new IOException("Not file: " + file);
        }
        File dir = file.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
    }
}

