/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive.model;

import com.reandroid.archive.ArchiveEntry;
import com.reandroid.archive.ArchiveException;
import com.reandroid.archive.block.ApkSignatureBlock;
import com.reandroid.archive.block.CentralEntryHeader;
import com.reandroid.archive.block.DataDescriptor;
import com.reandroid.archive.block.EndRecord;
import com.reandroid.archive.block.LocalFileHeader;
import com.reandroid.archive.block.SignatureFooter;
import com.reandroid.archive.io.ZipInput;
import com.reandroid.archive.model.CentralFileDirectory;
import com.reandroid.arsc.io.BlockReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class LocalFileDirectory {
    private final CentralFileDirectory centralFileDirectory;
    private final List<LocalFileHeader> headerList;
    private ApkSignatureBlock apkSignatureBlock;

    public LocalFileDirectory(CentralFileDirectory centralFileDirectory) {
        this.centralFileDirectory = centralFileDirectory;
        this.headerList = new ArrayList<LocalFileHeader>(centralFileDirectory.count() + 2);
    }

    public void visit(ZipInput zipInput) throws IOException {
        this.visitLocalFile(zipInput);
        this.visitApkSigBlock(zipInput);
    }

    private void visitLocalFile(ZipInput zipInput) throws IOException {
        List<LocalFileHeader> headerList = this.getHeaderList();
        int index = 0;
        CentralFileDirectory centralFileDirectory = this.getCentralFileDirectory();
        long length = zipInput.getLength();
        InputStream inputStream = zipInput.getInputStream(0L, length);
        for (CentralEntryHeader ceh : centralFileDirectory.getHeaderList()) {
            int read;
            long offset = ceh.getLocalRelativeOffset();
            inputStream.reset();
            offset = inputStream.skip(offset);
            LocalFileHeader lfh = LocalFileHeader.read(inputStream);
            if (lfh == null) {
                throw new ArchiveException("Error reading LFH at " + offset + ", for CEH = " + ceh.getFileName());
            }
            ceh.setFileOffset(offset += (long)lfh.countBytes());
            lfh.setCentralEntryHeader(ceh);
            inputStream.skip(lfh.getDataSize());
            lfh.updateDataDescriptor();
            DataDescriptor dataDescriptor = lfh.getDataDescriptor();
            if (dataDescriptor != null && (read = dataDescriptor.readBytes(inputStream)) != dataDescriptor.countBytes()) {
                lfh.setHasDataDescriptor(false);
            }
            lfh.setIndex(index);
            headerList.add(lfh);
            ++index;
        }
    }

    private void visitApkSigBlock(ZipInput zipInput) throws IOException {
        CentralFileDirectory cfd = this.getCentralFileDirectory();
        SignatureFooter footer = cfd.getSignatureFooter();
        if (footer == null || !footer.isValid()) {
            return;
        }
        EndRecord endRecord = cfd.getEndRecord();
        long length = footer.getSignatureSize() + 8L;
        long offset = endRecord.getOffsetOfCentralDirectory() - length;
        ApkSignatureBlock apkSignatureBlock = new ApkSignatureBlock(footer);
        apkSignatureBlock.readBytes(new BlockReader(zipInput.getInputStream(offset, length)));
        this.apkSignatureBlock = apkSignatureBlock;
    }

    public ApkSignatureBlock getApkSigBlock() {
        return this.apkSignatureBlock;
    }

    public CentralFileDirectory getCentralFileDirectory() {
        return this.centralFileDirectory;
    }

    public List<LocalFileHeader> getHeaderList() {
        return this.headerList;
    }

    public ArchiveEntry[] buildArchiveEntryList() {
        List<LocalFileHeader> headerList = this.getHeaderList();
        int size = headerList.size();
        ArchiveEntry[] entryList = new ArchiveEntry[size];
        for (int i = 0; i < size; ++i) {
            LocalFileHeader lfh = headerList.get(i);
            CentralEntryHeader ceh = lfh.getCentralEntryHeader();
            if (ceh == null) continue;
            entryList[i] = new ArchiveEntry(lfh);
        }
        return entryList;
    }
}

