/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive.writer;

import com.reandroid.archive.InputSource;
import com.reandroid.archive.RenamedInputSource;
import com.reandroid.archive.io.ArchiveFileEntrySource;
import com.reandroid.archive.io.ZipFileOutput;
import com.reandroid.archive.writer.ApkWriter;
import com.reandroid.archive.writer.ArchiveOutputSource;
import com.reandroid.archive.writer.BufferFileInput;
import com.reandroid.archive.writer.BufferFileOutput;
import com.reandroid.archive.writer.FileOutputSource;
import com.reandroid.archive.writer.RenamedArchiveSource;
import com.reandroid.archive.writer.ZipAligner;
import com.reandroid.arsc.chunk.TableBlock;
import java.io.File;
import java.io.IOException;

public class ApkFileWriter
extends ApkWriter<ZipFileOutput, FileOutputSource> {
    private BufferFileInput buffer;

    public ApkFileWriter(File file, InputSource[] sources) throws IOException {
        super(new ZipFileOutput(file), sources);
    }

    @Override
    void closeBuffer() throws IOException {
        this.buffer.close();
    }

    @Override
    void writeApk(FileOutputSource outputSource, ZipAligner zipAligner) throws IOException {
        outputSource.writeApk((ZipFileOutput)this.getZipOutput(), zipAligner);
    }

    void prepareOutputs(FileOutputSource[] outList) throws IOException {
        this.logMessage("Buffering compress changed files ...");
        BufferFileInput buffer = this.writeBuffer(outList);
        buffer.unlock();
        this.buffer = buffer;
    }

    FileOutputSource[] createOutArray(int length) {
        return new FileOutputSource[length];
    }

    @Override
    FileOutputSource toOutputSource(InputSource inputSource) {
        RenamedInputSource renamedInputSource;
        if (inputSource instanceof ArchiveFileEntrySource) {
            return new ArchiveOutputSource(inputSource);
        }
        if (inputSource instanceof RenamedInputSource && (renamedInputSource = (RenamedInputSource)inputSource).getParentInputSource(ArchiveFileEntrySource.class) != null) {
            return new RenamedArchiveSource(renamedInputSource);
        }
        return new FileOutputSource(inputSource);
    }

    private BufferFileInput writeBuffer(FileOutputSource[] outputList) throws IOException {
        File bufferFile = this.getBufferFile();
        BufferFileOutput output = new BufferFileOutput(bufferFile);
        BufferFileInput input = new BufferFileInput(bufferFile);
        FileOutputSource tableSource = null;
        for (FileOutputSource fileOutputSource : outputList) {
            InputSource inputSource = fileOutputSource.getInputSource();
            if (tableSource == null && TableBlock.FILE_NAME.equals(inputSource.getAlias())) {
                tableSource = fileOutputSource;
                continue;
            }
            this.onCompressFileProgress(inputSource.getAlias(), inputSource.getMethod(), output.position());
            fileOutputSource.makeBuffer(input, output);
        }
        if (tableSource != null) {
            tableSource.makeBuffer(input, output);
        }
        output.close();
        return input;
    }

    private File getBufferFile() {
        File file = ((ZipFileOutput)this.getZipOutput()).getFile();
        File dir = file.getParentFile();
        String name = file.getAbsolutePath();
        name = "tmp" + name.hashCode();
        File bufFile = dir != null ? new File(dir, name) : new File(name);
        bufFile.deleteOnExit();
        return bufFile;
    }
}

