/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive.writer;

import com.reandroid.archive.InputSource;
import com.reandroid.archive.block.LocalFileHeader;
import com.reandroid.archive.io.ArchiveFileEntrySource;
import com.reandroid.archive.io.ZipFileInput;
import com.reandroid.archive.writer.EntryBuffer;
import com.reandroid.archive.writer.FileOutputSource;

public class ArchiveOutputSource
extends FileOutputSource {
    public ArchiveOutputSource(InputSource inputSource) {
        super(inputSource);
    }

    ArchiveFileEntrySource getArchiveSource() {
        return (ArchiveFileEntrySource)super.getInputSource();
    }

    @Override
    EntryBuffer makeFromEntry() {
        ArchiveFileEntrySource entrySource = this.getArchiveSource();
        ZipFileInput zipFileInput = (ZipFileInput)entrySource.getZipSource();
        LocalFileHeader lfh = entrySource.getArchiveEntry().getLocalFileHeader();
        if (lfh.getMethod() != this.getInputSource().getMethod()) {
            return null;
        }
        return new EntryBuffer(zipFileInput, lfh.getFileOffset(), lfh.getDataSize());
    }

    @Override
    LocalFileHeader createLocalFileHeader() {
        ArchiveFileEntrySource source = this.getArchiveSource();
        LocalFileHeader lfh = source.getArchiveEntry().getLocalFileHeader();
        return lfh.copy();
    }
}

