/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.array;

import com.reandroid.arsc.array.IntegerOffsetArray;

public class SparseOffsetsArray
extends IntegerOffsetArray {
    public int getHighestId() {
        int result = -1;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int id = this.getIdx(i);
            if (id <= result) continue;
            result = id;
        }
        if (result == -1) {
            result = 0;
        }
        return result;
    }

    public int indexOf(int idx) {
        int size = super.size();
        for (int i = 0; i < size; ++i) {
            if (idx != this.getIdx(i)) continue;
            return i;
        }
        return -1;
    }

    public int getIdx(int i) {
        int value = super.get(i);
        if (value != -1) {
            value &= 0xFFFF;
        }
        return value;
    }

    public void setIdx(int index, int idx) {
        int value;
        if (idx == -1) {
            value = idx;
        } else {
            int offset = this.get(index) & 0xFFFF0000;
            value = offset | (idx &= 0xFFFF);
        }
        super.put(index, value);
    }

    @Override
    public int getOffset(int i) {
        int value = super.get(i);
        if (value == -1) {
            return value;
        }
        value = value >>> 16 & 0xFFFF;
        return value * 4;
    }

    @Override
    public void setOffset(int index, int offset) {
        int value;
        if (offset == -1) {
            value = 0;
        } else {
            int idx = this.get(index);
            offset &= 0xFFFF;
            offset /= 4;
            value = (offset <<= 16) | (idx &= 0xFFFF);
        }
        super.put(index, value);
    }
}

