/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.base;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockCounter;
import com.reandroid.arsc.item.ByteArray;
import java.util.Objects;

public class BlockLocator
extends BlockCounter {
    private final int bytePosition;
    private Block current;
    private Block previous;
    private static final int PARENT_TRACE_LENGTH = 10;

    public BlockLocator(int bytePosition) {
        super(null);
        this.bytePosition = bytePosition;
    }

    @Override
    void onCountAdded(int count) {
        if (count > this.bytePosition) {
            this.FOUND = true;
        }
    }

    @Override
    public void setCurrent(Block current) {
        if (current == null || this.FOUND) {
            return;
        }
        this.previous = this.current;
        this.current = current;
        if (this.getCountValue() > this.bytePosition) {
            this.FOUND = true;
            return;
        }
    }

    public int getBytePosition() {
        return this.bytePosition;
    }

    public Result getResult() {
        if (!this.FOUND || this.current == null) {
            return null;
        }
        return new Result(this.getBytePosition(), this.current, BlockLocator.buildParentTraces(this.current, this.previous));
    }

    @Override
    public String toString() {
        Result result = this.getResult();
        if (result == null) {
            return this.getCountValue() + "/" + this.bytePosition;
        }
        return result.toString();
    }

    private static Block[] buildParentTraces(Block block, Block previous) {
        int count;
        Block[] tmp = new Block[10];
        Block parent = block.getParent();
        if (parent == null) {
            parent = previous;
        }
        for (count = 0; parent != null && count < tmp.length; parent = parent.getParent(), ++count) {
            tmp[count] = parent;
        }
        Block[] results = new Block[count];
        for (int i = 0; i < count; ++i) {
            results[i] = tmp[i];
        }
        return results;
    }

    static String toResultName(Block block) {
        if (block == null) {
            return "null";
        }
        String name = block.getClass().getSimpleName();
        String text = block.toString();
        if (text == null) {
            text = "null";
        }
        if (!text.startsWith(name)) {
            text = name + " " + text;
        }
        return text;
    }

    public static class Result {
        public final int position;
        public final Block block;
        public final Block[] parentTraces;

        Result(int position, Block block, Block[] parentTraces) {
            this.position = position;
            this.block = block;
            this.parentTraces = parentTraces;
        }

        public String getMessage() {
            return "Position=" + this.position + ", " + BlockLocator.toResultName(this.block);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (this.block == null || obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Result result = (Result)obj;
            if (result.block == null) {
                return false;
            }
            return ByteArray.equals(this.block.getBytes(), result.block.getBytes());
        }

        public int hashCode() {
            return Objects.hash(this.block);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getMessage());
            for (Block parent : this.parentTraces) {
                builder.append("\n  ");
                builder.append(BlockLocator.toResultName(parent));
            }
            return builder.toString();
        }
    }
}

