/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.container.ExpandableBlockContainer;
import com.reandroid.arsc.container.SingleBlockContainer;
import com.reandroid.arsc.header.HeaderBlock;
import com.reandroid.arsc.header.InfoHeader;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.AlignItem;
import java.io.IOException;

public abstract class Chunk<T extends HeaderBlock>
extends ExpandableBlockContainer {
    private final T mHeaderBlock;
    private final SingleBlockContainer<Block> firstPlaceHolder;
    private AlignItem alignItem;

    protected Chunk(T headerBlock, SingleBlockContainer<Block> firstPlaceHolder, int initialChildesCount) {
        super(initialChildesCount + (firstPlaceHolder == null ? 2 : 3));
        this.mHeaderBlock = headerBlock;
        this.firstPlaceHolder = firstPlaceHolder;
        this.addChild((Block)headerBlock);
        if (firstPlaceHolder != null) {
            this.addChild(firstPlaceHolder);
        }
    }

    protected Chunk(T headerBlock, int initialChildesCount) {
        this(headerBlock, new SingleBlockContainer<Block>(), initialChildesCount);
    }

    public AlignItem getAlignItem() {
        AlignItem alignItem = this.alignItem;
        if (alignItem == null) {
            alignItem = new AlignItem();
            this.addChild(alignItem);
            this.alignItem = alignItem;
        }
        return alignItem;
    }

    public SingleBlockContainer<Block> getFirstPlaceHolder() {
        return this.firstPlaceHolder;
    }

    void setHeaderLoaded(HeaderBlock.HeaderLoaded headerLoaded) {
        ((HeaderBlock)this.getHeaderBlock()).setHeaderLoaded(headerLoaded);
    }

    public final T getHeaderBlock() {
        return this.mHeaderBlock;
    }

    @Override
    protected final void onRefreshed() {
        this.updateAlign();
        ((HeaderBlock)this.getHeaderBlock()).refreshHeader();
        this.onChunkRefreshed();
    }

    private void updateAlign() {
        AlignItem alignItem = this.getAlignItem();
        alignItem.setSize(0);
        alignItem.align(this);
    }

    protected abstract void onChunkRefreshed();

    public void onChunkLoaded() {
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        InfoHeader headerBlock = reader.readHeaderBlock();
        this.checkInvalidChunk(headerBlock);
        BlockReader chunkReader = reader.create(headerBlock.getChunkSize());
        this.onReadChildes(chunkReader);
        reader.offset(headerBlock.getChunkSize());
        chunkReader.close();
        this.onChunkLoaded();
    }

    protected void onReadChildes(BlockReader reader) throws IOException {
        AlignItem alignItem = this.getAlignItem();
        alignItem.setSize(0);
        super.onReadBytes(reader);
        alignItem.alignSafe(reader);
    }

    void checkInvalidChunk(HeaderBlock headerBlock) throws IOException {
        ChunkType chunkType = headerBlock.getChunkType();
        if (chunkType == null || chunkType == ChunkType.NULL) {
            throw new IOException("Invalid chunk: " + headerBlock);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.getHeaderBlock();
    }
}

