/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk;

import com.reandroid.arsc.ARSCLib;
import com.reandroid.arsc.array.LibraryInfoArray;
import com.reandroid.arsc.array.SpecTypePairArray;
import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.chunk.Chunk;
import com.reandroid.arsc.chunk.LibraryBlock;
import com.reandroid.arsc.chunk.ParentChunk;
import com.reandroid.arsc.chunk.StagedAlias;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.TypeBlock;
import com.reandroid.arsc.chunk.UnknownChunk;
import com.reandroid.arsc.coder.CommonType;
import com.reandroid.arsc.coder.EncodeResult;
import com.reandroid.arsc.coder.ValueCoder;
import com.reandroid.arsc.coder.xml.XmlEncodeException;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.container.PackageBody;
import com.reandroid.arsc.container.SpecTypePair;
import com.reandroid.arsc.header.PackageHeader;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.TypeString;
import com.reandroid.arsc.list.OverlayableList;
import com.reandroid.arsc.list.StagedAliasList;
import com.reandroid.arsc.model.ResourceEntry;
import com.reandroid.arsc.model.ResourceLibrary;
import com.reandroid.arsc.model.ResourceName;
import com.reandroid.arsc.model.ResourceType;
import com.reandroid.arsc.pool.SpecStringPool;
import com.reandroid.arsc.pool.TableStringPool;
import com.reandroid.arsc.pool.TypeStringPool;
import com.reandroid.arsc.refactor.ResourceMergeOption;
import com.reandroid.arsc.value.AttributeValue;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.LibraryInfo;
import com.reandroid.arsc.value.ResConfig;
import com.reandroid.arsc.value.StagedAliasEntry;
import com.reandroid.arsc.value.ValueHeader;
import com.reandroid.arsc.value.ValueItem;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.common.Namespace;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.IterableIterator;
import com.reandroid.utils.collection.MergingIterator;
import com.reandroid.utils.io.IOUtil;
import com.reandroid.xml.XMLElement;
import com.reandroid.xml.XMLFactory;
import com.reandroid.xml.XMLUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class PackageBlock
extends Chunk<PackageHeader>
implements ParentChunk,
JSONConvert<JSONObject>,
Comparable<PackageBlock>,
ResourceLibrary {
    private final TypeStringPool mTypeStringPool;
    private final SpecStringPool mSpecStringPool;
    private final PackageBody mBody;
    private String mPrefix;
    private boolean mHasValidPrefix;
    private Object mTag;
    public static final String NAME_package_id = ObjectsUtil.of("package_id");
    public static final String NAME_package_name = ObjectsUtil.of("package_name");
    private static final String NAME_specs = ObjectsUtil.of("specs");
    public static final String NAME_libraries = ObjectsUtil.of("libraries");
    public static final String NAME_staged_aliases = ObjectsUtil.of("staged_aliases");
    public static final String NAME_overlaybles = ObjectsUtil.of("overlaybles");
    public static final String JSON_FILE_NAME = ObjectsUtil.of("package.json");
    public static final String DIRECTORY_NAME_PREFIX = ObjectsUtil.of("package_");
    public static final String RES_DIRECTORY_NAME = ObjectsUtil.of("res");
    public static final String VALUES_DIRECTORY_NAME = ObjectsUtil.of("values");
    public static final String PUBLIC_XML = ObjectsUtil.of("public.xml");
    public static final String TAG_public = ObjectsUtil.of("public");
    public static final String TAG_resources = ObjectsUtil.of("resources");
    public static final String ATTR_package = ObjectsUtil.of("package");
    public static final String ATTR_id = ObjectsUtil.of("id");
    public static final String ATTR_type = ObjectsUtil.of("type");
    public static final String ATTR_name = ObjectsUtil.of("name");
    public static final String EMPTY_PACKAGE_NAME = ObjectsUtil.of("empty-package");

    public PackageBlock() {
        super(new PackageHeader(), 3);
        PackageHeader header = (PackageHeader)this.getHeaderBlock();
        this.mTypeStringPool = new TypeStringPool(false, header.getTypeIdOffsetItem());
        this.mSpecStringPool = new SpecStringPool(true);
        this.mBody = new PackageBody();
        this.addChild(this.mTypeStringPool);
        this.addChild(this.mSpecStringPool);
        this.addChild(this.mBody);
    }

    public void changePackageId(int packageIdOld, int packageIdNew) {
        Iterator<ValueItem> iterator = this.allValues();
        while (iterator.hasNext()) {
            ValueItem valueItem = iterator.next();
            PackageBlock.changePackageId(valueItem, packageIdOld, packageIdNew);
        }
        if (packageIdOld == this.getId()) {
            this.setId(packageIdNew);
        }
    }

    public Iterator<ValueItem> allValues() {
        return new MergingIterator<ValueItem>(new ComputeIterator<SpecTypePair, Iterator>(this.getSpecTypePairs(), SpecTypePair::allValues));
    }

    public Object getTag() {
        return this.mTag;
    }

    public void setTag(Object tag) {
        this.mTag = tag;
    }

    public Iterator<ResourceType> getTypes() {
        return ComputeIterator.of(this.getSpecTypePairs(), ResourceType::new);
    }

    public ResourceEntry getResource(int resourceId) {
        int entryId;
        int typeId;
        ResourceEntry resourceEntry;
        int packageId = resourceId >> 24 & 0xFF;
        if (packageId == 0) {
            return null;
        }
        if (packageId == this.getId() && (resourceEntry = this.getResource(typeId = resourceId >> 16 & 0xFF, entryId = resourceId & 0xFFFF)) != null) {
            return resourceEntry;
        }
        StagedAliasEntry aliasEntry = this.searchByStagedResId(resourceId);
        if (aliasEntry == null) {
            return null;
        }
        int alias = aliasEntry.getFinalizedResId();
        if (alias == 0 || alias == resourceId) {
            return null;
        }
        packageId = alias >> 24 & 0xFF;
        if (packageId != this.getId()) {
            return null;
        }
        int typeId2 = alias >> 16 & 0xFF;
        int entryId2 = alias & 0xFFFF;
        return this.getResource(typeId2, entryId2);
    }

    public ResourceEntry getResource(int typeId, int entryId) {
        SpecTypePair specTypePair = this.getSpecTypePair(typeId);
        if (specTypePair == null) {
            return null;
        }
        Entry entry = specTypePair.getAnyEntry((short)entryId);
        if (entry == null) {
            return null;
        }
        return new ResourceEntry(this, entry.getResourceId());
    }

    public ResourceEntry getResource(ResourceName resourceName) {
        if (resourceName == null || !resourceName.matchesPackageName(this.getName())) {
            return null;
        }
        return this.getResource(resourceName.getType(), resourceName.getName());
    }

    public ResourceEntry getResource(String type, String name) {
        SpecTypePair specTypePair = this.getSpecTypePair(type);
        if (specTypePair != null) {
            return specTypePair.getResource(name);
        }
        return null;
    }

    public ResourceEntry getAttrResource(String name) {
        Iterator<SpecTypePair> itr = this.getAttrSpecs();
        while (itr.hasNext()) {
            ResourceEntry resourceEntry = itr.next().getResource(name);
            if (resourceEntry == null) continue;
            return resourceEntry;
        }
        return null;
    }

    public ResourceEntry getIdResource(String name) {
        Iterator<SpecTypePair> itr = this.getIdSpecs();
        while (itr.hasNext()) {
            ResourceEntry resourceEntry = itr.next().getResource(name);
            if (resourceEntry == null) continue;
            return resourceEntry;
        }
        return null;
    }

    public Iterator<ResourceEntry> getResources() {
        return new IterableIterator<SpecTypePair, ResourceEntry>(this.getSpecTypePairs()){

            @Override
            public Iterator<ResourceEntry> iterator(SpecTypePair element) {
                return element.getResources();
            }
        };
    }

    public Iterator<ResourceEntry> getResources(final String type) {
        return new IterableIterator<SpecTypePair, ResourceEntry>(this.getSpecTypePairs()){

            @Override
            public Iterator<ResourceEntry> iterator(SpecTypePair element) {
                if (type.equals(element.getTypeName())) {
                    return element.getResources();
                }
                return EmptyIterator.of();
            }
        };
    }

    public String buildDecodeDirectoryName() {
        int count = 0;
        TableBlock tableBlock = this.getTableBlock();
        if (tableBlock != null) {
            count = tableBlock.size();
        }
        return DIRECTORY_NAME_PREFIX + StringsUtil.formatNumber(this.getIndex() + 1, count);
    }

    public boolean hasValidTypeNames() {
        HashSet<String> unique = new HashSet<String>();
        Iterator<SpecTypePair> iterator = this.getSpecTypePairs();
        while (iterator.hasNext()) {
            SpecTypePair specTypePair = iterator.next();
            String typeName = specTypePair.getTypeName();
            if (!CommonType.isCommonTypeName(typeName) || unique.contains(typeName)) {
                return false;
            }
            unique.add(typeName);
        }
        return true;
    }

    public boolean removeUnusedSpecs() {
        return this.getSpecStringPool().removeUnusedStrings();
    }

    public String refreshFull() {
        return this.refreshFull(true);
    }

    public String refreshFull(boolean elementsRefresh) {
        int sizeOld = ((PackageHeader)this.getHeaderBlock()).getChunkSize();
        StringBuilder message = new StringBuilder();
        boolean appendOnce = false;
        if (this.removeUnusedSpecs()) {
            message.append("Removed unused spec strings");
            appendOnce = true;
        }
        this.getSpecStringPool().sort();
        this.sortTypes();
        if (!elementsRefresh) {
            if (appendOnce) {
                return message.toString();
            }
            return null;
        }
        this.refresh();
        int sizeNew = ((PackageHeader)this.getHeaderBlock()).getChunkSize();
        if (sizeOld != sizeNew) {
            if (appendOnce) {
                message.append("\n");
            }
            message.append("Package size changed = ");
            message.append(sizeOld);
            message.append(", ");
            message.append(sizeNew);
            appendOnce = true;
        }
        if (appendOnce) {
            return message.toString();
        }
        return null;
    }

    public void linkTableStringsInternal(TableStringPool tableStringPool) {
        Iterator<SpecTypePair> iterator = this.getSpecTypePairs();
        while (iterator.hasNext()) {
            iterator.next().linkTableStringsInternal(tableStringPool);
        }
    }

    public void linkSpecStringsInternal(SpecStringPool specStringPool) {
        Iterator<SpecTypePair> iterator = this.getSpecTypePairs();
        while (iterator.hasNext()) {
            iterator.next().linkSpecStringsInternal(specStringPool);
        }
    }

    public void destroy() {
        this.getPackageBody().destroy();
        this.getTypeStringPool().clear();
        this.getSpecStringPool().clear();
        this.setId(0);
        this.setName("");
    }

    public int resolveResourceId(String type, String name) {
        return this.getSpecStringPool().resolveResourceId(type, name);
    }

    public int resolveResourceId(int typeId, String name) {
        return this.getSpecStringPool().resolveResourceId(typeId, name);
    }

    public Entry getEntry(String type, String name) {
        Iterator<Entry> iterator = this.getEntries(type, name);
        Entry result = null;
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            if (!entry.isNull()) {
                return entry;
            }
            if (result != null) continue;
            result = entry;
        }
        return result;
    }

    public Iterator<Entry> getEntries(String type, String name) {
        return this.getSpecStringPool().getEntries(type, name);
    }

    public Iterator<Entry> getEntries(int typeId, String name) {
        return this.getSpecStringPool().getEntries(typeId, name);
    }

    public Iterator<Entry> getEntries(int resourceId) {
        return this.getEntries(resourceId, true);
    }

    public Iterator<Entry> getEntries(int resourceId, boolean skipNull) {
        int packageId = resourceId >> 24 & 0xFF;
        if (packageId != this.getId()) {
            return EmptyIterator.of();
        }
        return this.getEntries(resourceId >> 16 & 0xFF, resourceId & 0xFFFF, skipNull);
    }

    public Iterator<Entry> getEntries(int typeId, int entryId) {
        return this.getEntries(typeId, entryId, true);
    }

    public Iterator<Entry> getEntries(int typeId, int entryId, boolean skipNull) {
        SpecTypePair specTypePair = this.getSpecTypePair(typeId);
        if (specTypePair != null) {
            return specTypePair.getEntries(entryId, skipNull);
        }
        return EmptyIterator.of();
    }

    public Entry getEntry(String qualifiers, String type, String name) {
        return this.getSpecTypePairArray().getEntry(qualifiers, type, name);
    }

    public Entry getEntry(ResConfig resConfig, String type, String name) {
        return this.getSpecTypePairArray().getEntry(resConfig, type, name);
    }

    public Entry getEntry(ResConfig resConfig, int typeId, int entryId) {
        return this.getSpecTypePairArray().getEntry(resConfig, typeId, entryId);
    }

    public Entry getOrCreate(String qualifiers, String type, String name) {
        return this.getOrCreate(ResConfig.parse(qualifiers), type, name);
    }

    public Entry getOrCreate(ResConfig resConfig, String typeName, String name) {
        SpecTypePair specTypePair = this.getOrCreateSpecTypePair(typeName);
        TypeBlock typeBlock = specTypePair.getOrCreateTypeBlock(resConfig);
        return typeBlock.getOrCreateEntry(name);
    }

    public TypeBlock getOrCreateTypeBlock(String qualifiers, String typeName) {
        SpecTypePair specTypePair = this.getOrCreateSpecTypePair(typeName);
        return specTypePair.getOrCreateTypeBlock(qualifiers);
    }

    public TypeBlock getOrCreateTypeBlock(ResConfig resConfig, String typeName) {
        SpecTypePair specTypePair = this.getOrCreateSpecTypePair(typeName);
        return specTypePair.getOrCreateTypeBlock(resConfig);
    }

    public SpecTypePair getOrCreateSpecTypePair(int typeId, String typeName) {
        this.getOrCreateTypeString(typeId, typeName);
        return this.getSpecTypePairArray().getOrCreate((byte)typeId);
    }

    public SpecTypePair getOrCreateSpecTypePair(String typeName) {
        return this.getSpecTypePairArray().getOrCreate(typeName);
    }

    public int getTypeIdOffset() {
        return ((PackageHeader)this.getHeaderBlock()).getTypeIdOffset();
    }

    public BlockList<UnknownChunk> getUnknownChunkList() {
        return this.mBody.getUnknownChunkList();
    }

    public StagedAliasEntry searchByStagedResId(int stagedResId) {
        for (StagedAlias stagedAlias : this.listStagedAlias()) {
            StagedAliasEntry aliasEntry = stagedAlias.searchByStagedResId(stagedResId);
            if (aliasEntry == null) continue;
            return aliasEntry;
        }
        return null;
    }

    public List<StagedAlias> listStagedAlias() {
        return this.getStagedAliasList().getChildes();
    }

    public StagedAliasList getStagedAliasList() {
        return this.mBody.getStagedAliasList();
    }

    public OverlayableList getOverlayableList() {
        return this.mBody.getOverlayableList();
    }

    public void sortTypes() {
        this.getSpecTypePairArray().sort();
    }

    @Override
    protected void onPreRefresh() {
        this.removeEmpty();
        super.onPreRefresh();
    }

    public void removeEmpty() {
        this.getSpecTypePairArray().removeEmptyPairs();
    }

    public boolean isEmpty() {
        return this.getId() == 0 && this.mBody.isEmpty();
    }

    @Override
    public int getId() {
        return ((PackageHeader)this.getHeaderBlock()).getPackageId().get();
    }

    public void setId(int id) {
        ((PackageHeader)this.getHeaderBlock()).getPackageId().set(id);
        this.mPrefix = null;
        this.mHasValidPrefix = false;
    }

    @Override
    public String getName() {
        return ((PackageHeader)this.getHeaderBlock()).getPackageName().get();
    }

    public void setName(String name) {
        ((PackageHeader)this.getHeaderBlock()).getPackageName().set(name);
        this.mPrefix = null;
        this.mHasValidPrefix = false;
    }

    @Override
    public String getPrefix() {
        boolean hasValidPrefix;
        String prefix;
        if (this.mPrefix != null) {
            return this.mPrefix;
        }
        if (this.getId() == 1) {
            prefix = ResourceLibrary.PREFIX_ANDROID;
            hasValidPrefix = ResourceLibrary.PREFIX_ANDROID.equals(this.getName());
        } else {
            prefix = ResourceLibrary.toPrefix(this.getName());
            boolean bl = hasValidPrefix = Namespace.isValidPrefix(prefix) && !ResourceLibrary.PREFIX_ANDROID.equals(prefix);
            if (!hasValidPrefix) {
                prefix = ResourceLibrary.PREFIX_APP;
            }
        }
        this.mPrefix = prefix;
        this.mHasValidPrefix = hasValidPrefix;
        return prefix;
    }

    @Override
    public String getUri() {
        if (this.isAndroid()) {
            return ResourceLibrary.URI_ANDROID;
        }
        return ResourceLibrary.URI_RES_AUTO;
    }

    @Override
    public boolean packageNameMatches(String packageName) {
        if (packageName == null) {
            return false;
        }
        if (packageName.equals(this.getName())) {
            return true;
        }
        if (packageName.equals(this.getPrefix()) && this.mHasValidPrefix) {
            return true;
        }
        return this.getLibraryBlock().containsLibraryInfo(packageName);
    }

    private boolean isAndroid() {
        return this.getId() == 1 && ResourceLibrary.PREFIX_ANDROID.equals(this.getName());
    }

    public TableBlock getTableBlock() {
        for (Block parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof TableBlock)) continue;
            return (TableBlock)parent;
        }
        return null;
    }

    public boolean isMultiPackage() {
        TableBlock tableBlock = this.getTableBlock();
        if (tableBlock != null) {
            return tableBlock.isMultiPackage();
        }
        return false;
    }

    public String typeNameOf(int typeId) {
        TypeString typeString = this.getTypeStringPool().getById(typeId);
        if (typeString != null) {
            return typeString.get();
        }
        return null;
    }

    public int typeIdOf(String typeName) {
        return this.getTypeStringPool().idOf(typeName);
    }

    public TypeString getOrCreateTypeString(int typeId, String typeName) {
        return this.getTypeStringPool().getOrCreate(typeId, typeName);
    }

    public TypeStringPool getTypeStringPool() {
        return this.mTypeStringPool;
    }

    public SpecStringPool getSpecStringPool() {
        return this.mSpecStringPool;
    }

    @Override
    public TableBlock getMainChunk() {
        return this.getTableBlock();
    }

    @Override
    public PackageBlock getPackageBlock() {
        return this;
    }

    public PackageBody getPackageBody() {
        return this.mBody;
    }

    public SpecTypePairArray getSpecTypePairArray() {
        return this.mBody.getSpecTypePairArray();
    }

    public void trimConfigSizes(int resConfigSize) {
        this.getSpecTypePairArray().trimConfigSizes(resConfigSize);
    }

    public Iterator<LibraryInfo> getLibraryInfo() {
        return this.getLibraryBlock().iterator();
    }

    public void addLibrary(LibraryBlock libraryBlock) {
        if (libraryBlock == null) {
            return;
        }
        for (LibraryInfo info : libraryBlock.getLibraryInfoArray().listItems()) {
            this.addLibraryInfo(info);
        }
    }

    public void addLibraryInfo(LibraryInfo info) {
        this.getLibraryBlock().addLibraryInfo(info);
    }

    public LibraryBlock getLibraryBlock() {
        return this.mBody.getLibraryBlock();
    }

    public Entry getOrCreateEntry(byte typeId, short entryId, String qualifiers) {
        return this.getSpecTypePairArray().getOrCreateEntry(typeId, entryId, qualifiers);
    }

    public Entry getOrCreateEntry(byte typeId, short entryId, ResConfig resConfig) {
        return this.getSpecTypePairArray().getOrCreateEntry(typeId, entryId, resConfig);
    }

    public Entry getAnyEntry(int resourceId) {
        int packageId = resourceId >> 24 & 0xFF;
        if (packageId != this.getId()) {
            return null;
        }
        byte typeId = (byte)(resourceId >> 16 & 0xFF);
        short entryId = (short)(resourceId & 0xFFFF);
        return this.getSpecTypePairArray().getAnyEntry(typeId, entryId);
    }

    public Entry getEntry(byte typeId, short entryId, String qualifiers) {
        return this.getSpecTypePairArray().getEntry(typeId, entryId, qualifiers);
    }

    public TypeBlock getOrCreateTypeBlock(byte typeId, String qualifiers) {
        return this.getSpecTypePairArray().getOrCreateTypeBlock(typeId, qualifiers);
    }

    public TypeBlock getTypeBlock(byte typeId, String qualifiers) {
        return this.getSpecTypePairArray().getTypeBlock(typeId, qualifiers);
    }

    private Iterator<SpecTypePair> getAttrSpecs() {
        return this.getSpecTypePairArray().iterator(new Predicate<SpecTypePair>(){

            @Override
            public boolean test(SpecTypePair specTypePair) {
                return specTypePair != null && specTypePair.isTypeAttr();
            }
        });
    }

    private Iterator<SpecTypePair> getIdSpecs() {
        return this.getSpecTypePairArray().iterator(specTypePair -> specTypePair != null && specTypePair.isTypeId());
    }

    public SpecTypePair getSpecTypePair(String typeName) {
        return this.getSpecTypePair(this.typeIdOf(typeName));
    }

    public SpecTypePair getSpecTypePair(int typeId) {
        return this.getSpecTypePairArray().getSpecTypePair((byte)typeId);
    }

    public Iterable<SpecTypePair> listSpecTypePairs() {
        return this.getSpecTypePairArray().listItems();
    }

    public Iterator<ResConfig> getResConfigs() {
        return new MergingIterator<ResConfig>(new ComputeIterator<SpecTypePair, Iterator>(this.getSpecTypePairs(), SpecTypePair::getResConfigs));
    }

    public Iterator<SpecTypePair> getSpecTypePairs() {
        return this.getSpecTypePairArray().iterator();
    }

    private void refreshTypeStringPoolOffset() {
        int pos = this.countUpTo(this.mTypeStringPool);
        ((PackageHeader)this.getHeaderBlock()).getTypeStringPoolOffset().set(pos);
    }

    private void refreshTypeStringPoolCount() {
        ((PackageHeader)this.getHeaderBlock()).getTypeStringPoolCount().set(this.mTypeStringPool.size());
    }

    private void refreshSpecStringPoolOffset() {
        int pos = this.countUpTo(this.mSpecStringPool);
        ((PackageHeader)this.getHeaderBlock()).getSpecStringPoolOffset().set(pos);
    }

    private void refreshSpecStringCount() {
        ((PackageHeader)this.getHeaderBlock()).getSpecStringPoolCount().set(this.mSpecStringPool.size());
    }

    @Override
    public void onChunkLoaded() {
    }

    @Override
    protected void onChunkRefreshed() {
        this.refreshTypeStringPoolOffset();
        this.refreshTypeStringPoolCount();
        this.refreshSpecStringPoolOffset();
        this.refreshSpecStringCount();
    }

    public void serializePublicXml(File file) throws IOException {
        XmlSerializer serializer = XMLFactory.newSerializer(file);
        this.serializePublicXml(serializer);
        IOUtil.close(serializer);
    }

    public void serializePublicXml(XmlSerializer serializer) throws IOException {
        this.serializePublicXml(serializer, true);
    }

    public void serializePublicXml(XmlSerializer serializer, boolean fullDocument) throws IOException {
        if (fullDocument) {
            serializer.startDocument("utf-8", null);
            serializer.text("\n");
            serializer.startTag(null, TAG_resources);
            this.writePackageInfo(serializer);
        }
        this.serializePublicXmlTypes(serializer);
        if (fullDocument) {
            serializer.text("\n");
            serializer.endTag(null, TAG_resources);
            serializer.endDocument();
            IOUtil.close(serializer);
        }
    }

    private void serializePublicXmlTypes(XmlSerializer serializer) throws IOException {
        Iterator<SpecTypePair> iterator = this.getSpecTypePairs();
        while (iterator.hasNext()) {
            iterator.next().serializePublicXml(serializer);
        }
    }

    private void writePackageInfo(XmlSerializer serializer) throws IOException {
        TableBlock tableBlock;
        int id;
        String name = this.getName();
        if (name != null) {
            serializer.attribute(null, ATTR_package, name);
        }
        if ((id = this.getId()) != 0) {
            serializer.attribute(null, ATTR_id, HexUtil.toHex2((byte)id));
        }
        if ((tableBlock = this.getTableBlock()) != null && tableBlock.isEmpty() && tableBlock.isNull()) {
            serializer.attribute(null, TableBlock.ATTR_null_table, "true");
        }
    }

    public void parsePublicXml(XmlPullParser parser) throws IOException, XmlPullParserException {
        this.getPublicXmlParser().parse(parser);
    }

    public PublicXmlParser getPublicXmlParser() {
        return new PublicXmlParser(this);
    }

    @Override
    public JSONObject toJson() {
        return this.toJson(true);
    }

    public JSONObject toJson(boolean addTypes) {
        JSONArray jsonArray;
        StagedAlias stagedAlias;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("arsc_lib_version", ARSCLib.getVersion());
        jsonObject.put(NAME_package_id, this.getId());
        jsonObject.put(NAME_package_name, this.getName());
        jsonObject.put(NAME_specs, this.getSpecTypePairArray().toJson(!addTypes));
        LibraryInfoArray libraryInfoArray = this.getLibraryBlock().getLibraryInfoArray();
        if (libraryInfoArray.size() > 0) {
            jsonObject.put(NAME_libraries, libraryInfoArray.toJson());
        }
        if ((stagedAlias = StagedAlias.mergeAll(this.getStagedAliasList().getChildes())) != null) {
            jsonObject.put(NAME_staged_aliases, stagedAlias.getStagedAliasEntryArray().toJson());
        }
        if (addTypes && (jsonArray = this.getOverlayableList().toJson()) != null) {
            jsonObject.put(NAME_overlaybles, jsonArray);
        }
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        String name;
        int id = json.optInt(NAME_package_id, 0);
        if (id != 0) {
            this.setId(id);
        }
        if ((name = json.optString(NAME_package_name, null)) != null) {
            this.setName(name);
        }
        this.getSpecTypePairArray().fromJson(json.optJSONArray(NAME_specs));
        LibraryInfoArray libraryInfoArray = this.getLibraryBlock().getLibraryInfoArray();
        libraryInfoArray.fromJson(json.optJSONArray(NAME_libraries));
        if (json.has(NAME_staged_aliases)) {
            StagedAlias stagedAlias = new StagedAlias();
            stagedAlias.getStagedAliasEntryArray().fromJson(json.getJSONArray(NAME_staged_aliases));
            this.getStagedAliasList().add(stagedAlias);
        }
        if (json.has(NAME_overlaybles)) {
            this.getOverlayableList().fromJson(json.getJSONArray(NAME_overlaybles));
        }
    }

    public void merge(PackageBlock packageBlock) {
        if (packageBlock == null || packageBlock == this) {
            return;
        }
        if (this.getId() != packageBlock.getId()) {
            throw new IllegalArgumentException("Can not merge different id packages: " + this.getId() + "!=" + packageBlock.getId());
        }
        this.setName(packageBlock.getName());
        this.getLibraryBlock().merge(packageBlock.getLibraryBlock());
        this.getSpecStringPool().merge(packageBlock.getSpecStringPool());
        this.getSpecTypePairArray().merge(packageBlock.getSpecTypePairArray());
        this.getOverlayableList().merge(packageBlock.getOverlayableList());
        this.getStagedAliasList().merge(packageBlock.getStagedAliasList());
    }

    public ResourceEntry mergeWithName(ResourceMergeOption mergeOption, ResourceEntry resourceEntry) {
        ResourceEntry exist = this.getResource(resourceEntry.getType(), resourceEntry.getName());
        if (exist != null && !exist.isEmpty()) {
            return exist;
        }
        int id = 0;
        Iterator<Entry> iterator = resourceEntry.iterator(mergeOption.getKeepEntryConfigs());
        while (iterator.hasNext()) {
            Entry coming = iterator.next();
            if (coming.isNull()) continue;
            Entry entry = this.mergeWithName(mergeOption, coming);
            if (id != 0) continue;
            id = entry.getResourceId();
        }
        ResourceEntry result = this.getResource(id);
        if (result == null) {
            result = this.getTableBlock().getResource(id);
        }
        return result;
    }

    private Entry mergeWithName(ResourceMergeOption mergeOption, Entry entry) {
        Entry result = this.getOrCreate(entry.getResConfig(), entry.getTypeName(), entry.getName());
        result.mergeWithName(mergeOption, entry);
        return result;
    }

    @Override
    public int compareTo(PackageBlock pkg) {
        return Integer.compare(this.getId(), pkg.getId());
    }

    public boolean isSimilarTo(PackageBlock packageBlock) {
        if (packageBlock == this) {
            return true;
        }
        if (packageBlock == null || this.getId() != packageBlock.getId() || !this.getName().equals(packageBlock.getName())) {
            return false;
        }
        return this.getTypeStringPool().size() == packageBlock.getTypeStringPool().size() && this.getSpecStringPool().size() == packageBlock.getSpecStringPool().size();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append(", id=");
        builder.append(HexUtil.toHex2((byte)this.getId()));
        builder.append(", name=");
        builder.append(this.getName());
        int libCount = this.getLibraryBlock().size();
        if (libCount > 0) {
            builder.append(", libraries=");
            builder.append(libCount);
        }
        return builder.toString();
    }

    public static boolean isPackageId(int packageId) {
        if (packageId == 0) {
            return false;
        }
        return packageId > 0 && packageId <= 255;
    }

    public static boolean isResourceId(int resourceId) {
        if (resourceId == 0) {
            return false;
        }
        return (resourceId & 0xFF0000) != 0 && (resourceId & 0xFF000000) != 0;
    }

    public static void changePackageId(ValueItem valueItem, int packageIdOld, int packageIdNew) {
        if (valueItem instanceof AttributeValue) {
            PackageBlock.changePackageIdName(packageIdOld, packageIdNew, (AttributeValue)valueItem);
        }
        PackageBlock.changePackageIdValue(packageIdOld, packageIdNew, valueItem);
    }

    private static void changePackageIdName(int packageIdOld, int packageIdNew, AttributeValue value) {
        int resourceId = value.getNameId();
        if (!PackageBlock.isResourceId(resourceId)) {
            return;
        }
        int id = resourceId >> 24 & 0xFF;
        if (id != packageIdOld) {
            return;
        }
        resourceId &= 0xFFFFFF;
        id = packageIdNew << 24;
        resourceId = id | resourceId;
        value.setNameId(resourceId);
    }

    private static void changePackageIdValue(int packageIdOld, int packageIdNew, ValueItem valueItem) {
        ValueType valueType = valueItem.getValueType();
        if (valueType == null || !valueType.isReference()) {
            return;
        }
        int resourceId = valueItem.getData();
        if (!PackageBlock.isResourceId(resourceId)) {
            return;
        }
        int id = resourceId >> 24 & 0xFF;
        if (id != packageIdOld) {
            return;
        }
        resourceId &= 0xFFFFFF;
        id = packageIdNew << 24;
        resourceId = id | resourceId;
        valueItem.setData(resourceId);
    }

    public static int replacePackageId(int resourceId, int packageIdOld, int packageIdNew) {
        if (!PackageBlock.isResourceId(resourceId)) {
            return resourceId;
        }
        int id = resourceId >> 24 & 0xFF;
        if (id != packageIdOld) {
            return resourceId;
        }
        resourceId &= 0xFFFFFF;
        id = packageIdNew << 24;
        resourceId = id | resourceId;
        return resourceId;
    }

    public static PackageBlock createEmptyPackage(final TableBlock tableBlock) {
        PackageBlock packageBlock = new PackageBlock(){

            @Override
            public boolean isEmpty() {
                return true;
            }

            @Override
            public boolean isNull() {
                return true;
            }

            @Override
            public TableBlock getTableBlock() {
                return tableBlock;
            }

            @Override
            public int getId() {
                return 0;
            }

            @Override
            public void setId(int id) {
                if (id != 0) {
                    throw new IllegalArgumentException("Can't set id to empty package");
                }
            }

            @Override
            public String getName() {
                return EMPTY_PACKAGE_NAME;
            }

            @Override
            public void setName(String name) {
                if (name != null && name.length() != 0) {
                    throw new IllegalArgumentException("Can't set name to empty package");
                }
            }

            @Override
            public int countBytes() {
                return 0;
            }

            @Override
            public byte[] getBytes() {
                return new byte[0];
            }

            @Override
            public void onReadBytes(BlockReader reader) throws IOException {
                throw new IOException("Can't read on empty package");
            }

            @Override
            public int onWriteBytes(OutputStream stream) throws IOException {
                throw new IOException("Can't write on empty package");
            }

            @Override
            public String toString() {
                return this.getName();
            }
        };
        packageBlock.setParent(tableBlock);
        return packageBlock;
    }

    public static class PublicXmlParser {
        private final PackageBlock packageBlock;
        private boolean mInitializeIds = true;

        private PublicXmlParser(PackageBlock packageBlock) {
            this.packageBlock = packageBlock;
        }

        public PublicXmlParser setInitializeIds(boolean initializeId) {
            this.mInitializeIds = initializeId;
            return this;
        }

        public PublicXmlParser parse(XmlPullParser parser) throws IOException, XmlPullParserException {
            this.parseResourcesAttributes(parser);
            this.parseElements(parser);
            IOUtil.close(parser);
            return this;
        }

        private boolean isInitializeIds() {
            return this.mInitializeIds;
        }

        private void parseElements(XmlPullParser parser) throws IOException, XmlPullParserException {
            while (XMLUtil.ensureStartTag(parser) == 2) {
                XMLElement element = XMLElement.parseElement(parser);
                this.parsePublicTag(element);
            }
        }

        private void parsePublicTag(XMLElement element) throws XmlEncodeException {
            if (!TAG_public.equals(element.getName())) {
                return;
            }
            String id = element.getAttributeValue(ATTR_id);
            String type = element.getAttributeValue(ATTR_type);
            String name = element.getAttributeValue(ATTR_name);
            if (id == null) {
                throw new XmlEncodeException("Missing attribute: '" + ATTR_id + "', " + element.getDebugText());
            }
            if (type == null) {
                throw new XmlEncodeException("Missing attribute: '" + ATTR_type + "', " + element.getDebugText());
            }
            if (name == null) {
                throw new XmlEncodeException("Missing attribute: '" + ATTR_name + "', " + element.getDebugText());
            }
            EncodeResult encodeResult = ValueCoder.encodeHexOrInteger(id.trim());
            if (encodeResult == null) {
                throw new XmlEncodeException("Invalid id value: " + element.getDebugText());
            }
            int resourceId = encodeResult.value;
            int packageId = resourceId >> 24 & 0xFF;
            int i = this.packageBlock.getId();
            if (i == 0) {
                this.packageBlock.setId(packageId);
            } else if (i != packageId) {
                return;
            }
            int typeId = resourceId >> 16 & 0xFF;
            if (typeId == 0) {
                throw new XmlEncodeException("Type id is zero: '" + id + "', " + element.getDebugText());
            }
            TypeString typeString = this.packageBlock.getOrCreateTypeString(typeId, type);
            typeId = typeString.getId();
            TypeBlock typeBlock = this.packageBlock.getOrCreateTypeBlock((byte)typeId, "");
            Entry entry = typeBlock.getOrCreateEntry(resourceId & 0xFFFF);
            entry.setName(name, true);
            if (this.isInitializeIds() && typeBlock.isTypeId()) {
                entry.setValueAsBoolean(false);
                ValueHeader header = entry.getHeader();
                header.setPublic(true);
                header.setWeak(true);
            }
        }

        private void parseResourcesAttributes(XmlPullParser parser) throws IOException, XmlPullParserException {
            int event = parser.getEventType();
            boolean documentStarted = false;
            if (event == 0) {
                documentStarted = true;
                parser.next();
            }
            if ((event = XMLUtil.ensureStartTag(parser)) != 2) {
                throw new XmlEncodeException("Expecting xml state START_TAG but found: " + XMLUtil.toEventName(parser.getEventType()));
            }
            if (TAG_resources.equals(parser.getName())) {
                XMLElement element = new XMLElement(TAG_resources);
                element.parseAttributes(parser);
                this.parseResourcesAttributes(element);
                parser.next();
            } else if (documentStarted) {
                throw new XmlEncodeException("Expecting <resources> tag but found: " + parser.getName());
            }
        }

        private void parseResourcesAttributes(XMLElement element) throws IOException {
            String nullTable;
            String id;
            String packageName = element.getAttributeValue(ATTR_package);
            if (!StringsUtil.isWhiteSpace(packageName) && !EMPTY_PACKAGE_NAME.equals(packageName)) {
                this.packageBlock.setName(packageName);
            }
            if (!StringsUtil.isWhiteSpace(id = element.getAttributeValue(ATTR_id)) && this.packageBlock.getId() == 0) {
                EncodeResult encodeResult = ValueCoder.encodeHexOrInteger(id);
                if (encodeResult == null || !PackageBlock.isPackageId(encodeResult.value)) {
                    throw new XmlEncodeException("Invalid id value: '" + element.getDebugText() + "'");
                }
                this.packageBlock.setId(encodeResult.value);
            }
            if ("true".equals(nullTable = element.getAttributeValue(TableBlock.ATTR_null_table))) {
                this.packageBlock.getTableBlock().setNull(true);
            }
        }
    }
}

