/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk;

import com.reandroid.apk.xmlencoder.EncodeException;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.coder.CoderUnknownReferenceId;
import com.reandroid.arsc.coder.EncodeResult;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.model.ResourceEntry;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.StringsUtil;
import com.reandroid.xml.XMLUtil;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class PolicyItem
extends IntegerItem {
    public static final String ATTR_name = ObjectsUtil.of("name");
    public static final String ATTR_type = ObjectsUtil.of("type");
    public static final String TAG_item = ObjectsUtil.of("item");

    public ResourceEntry getResourceEntry() {
        PackageBlock packageBlock = this.getParentInstance(PackageBlock.class);
        if (packageBlock != null) {
            return packageBlock.getResource(this.get());
        }
        return null;
    }

    public void parse(XmlPullParser parser) throws IOException, XmlPullParserException {
        EncodeResult encodeResult;
        String name = parser.getAttributeValue(null, ATTR_name);
        if (StringsUtil.isEmpty(name)) {
            throw new EncodeException(parser, "Missing attribute '" + ATTR_name + "'");
        }
        String type = parser.getAttributeValue(null, ATTR_type);
        if (StringsUtil.isEmpty(type) && (encodeResult = CoderUnknownReferenceId.INS.encode(name)) != null) {
            this.set(encodeResult.value);
            this.skipToEnd(parser);
            return;
        }
        PackageBlock packageBlock = this.getParentInstance(PackageBlock.class);
        ResourceEntry resourceEntry = packageBlock.getResource(type, name);
        if (resourceEntry == null) {
            resourceEntry = packageBlock.getTableBlock().getResource((String)null, type, name);
        }
        if (resourceEntry == null) {
            throw new EncodeException(parser, "Unknown policy item: type = " + type + ", name = " + name + "");
        }
        this.set(resourceEntry.getResourceId());
        this.skipToEnd(parser);
    }

    private void skipToEnd(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.next();
        XMLUtil.ensureTag(parser);
        if (parser.getEventType() == 3) {
            parser.next();
            XMLUtil.ensureTag(parser);
        }
    }

    public void serialize(XmlSerializer serializer) throws IOException {
        serializer.startTag(null, TAG_item);
        ResourceEntry resourceEntry = this.getResourceEntry();
        if (resourceEntry != null) {
            serializer.attribute(null, ATTR_type, resourceEntry.getType());
            serializer.attribute(null, ATTR_name, resourceEntry.getName());
        } else {
            serializer.attribute(null, ATTR_type, "");
            serializer.attribute(null, ATTR_name, CoderUnknownReferenceId.INS.decode(this.get()));
        }
        serializer.endTag(null, TAG_item);
    }

    public int hashCode() {
        return this.get();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PolicyItem)) {
            return false;
        }
        PolicyItem reference = (PolicyItem)obj;
        return this.get() == reference.get();
    }

    @Override
    public String toString() {
        ResourceEntry resourceEntry = this.getResourceEntry();
        if (resourceEntry != null) {
            return resourceEntry.buildReference(this.getParentInstance(PackageBlock.class));
        }
        return this.toHex();
    }
}

