/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.chunk.xml.ResXmlAttribute;
import com.reandroid.arsc.chunk.xml.ResXmlAttributePosition;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.chunk.xml.ResXmlNamespace;
import com.reandroid.arsc.chunk.xml.ResXmlStartElement;
import com.reandroid.arsc.container.CountedBlockList;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.arsc.refactor.ResourceMergeOption;
import com.reandroid.common.Namespace;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.StringsUtil;
import com.reandroid.xml.XMLElement;
import com.reandroid.xml.XMLUtil;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlSerializer;

public class ResXmlAttributeArray
extends CountedBlockList<ResXmlAttribute>
implements JSONConvert<JSONArray> {
    public ResXmlAttributeArray(IntegerReference unitSize, IntegerReference countReference) {
        super(new AttributesCreator(unitSize), countReference);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean sort(Comparator<? super ResXmlAttribute> comparator) {
        if (super.sort(comparator)) {
            this.getStartElement().refreshAttributePositions();
            return true;
        }
        return false;
    }

    private void computePositionalAttributes() {
        ResXmlStartElement startElement = this.getStartElement();
        startElement.getIdAttributePosition().computePosition();
        startElement.getClassAttributePosition().computePosition();
        startElement.getStyleAttributePosition().computePosition();
    }

    private ResXmlAttributePosition getPosition(int positionType) {
        if (positionType != -1) {
            ResXmlStartElement startElement = this.getStartElement();
            if (positionType == ResXmlAttributePosition.TYPE_ID) {
                return startElement.getIdAttributePosition();
            }
            if (positionType == ResXmlAttributePosition.TYPE_CLASS) {
                return startElement.getClassAttributePosition();
            }
            if (positionType == ResXmlAttributePosition.TYPE_STYLE) {
                return startElement.getStyleAttributePosition();
            }
        }
        return (ResXmlAttributePosition)ObjectsUtil.getNull();
    }

    private ResXmlAttributePosition getPosition(ResXmlAttribute attribute) {
        ResXmlStartElement startElement = this.getStartElement();
        ResXmlAttributePosition position = startElement.getIdAttributePosition();
        if (position.getAttribute() == attribute) {
            return position;
        }
        position = startElement.getClassAttributePosition();
        if (position.getAttribute() == attribute) {
            return position;
        }
        position = startElement.getStyleAttributePosition();
        if (position.getAttribute() == attribute) {
            return position;
        }
        return null;
    }

    private void linkPositionalAttribute(ResXmlAttribute attribute) {
        ResXmlAttributePosition position = this.getPosition(ResXmlAttributePosition.getPositionType(attribute));
        if (position != null) {
            position.setAttribute(attribute);
        }
    }

    public void sort() {
        this.sort(CompareUtil.getComparableComparator());
    }

    private ResXmlStartElement getStartElement() {
        return this.getParentInstance(ResXmlStartElement.class);
    }

    private ResXmlElement element() {
        return this.getParentInstance(ResXmlElement.class);
    }

    @Override
    public ResXmlAttribute createNext() {
        ResXmlAttribute attribute = (ResXmlAttribute)super.createNext();
        this.updateCountReference();
        return attribute;
    }

    @Override
    public void setSize(int size) {
        if (size != this.size()) {
            this.getCountReference().set(size);
            super.setSize(size);
        }
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        int size = this.getCountReference().get();
        this.setSize(size);
        if (size != 0) {
            int unitSize = this.getStartElement().getAttributeUnitSize().get();
            for (int i = 0; i < size; ++i) {
                ResXmlAttribute attribute = (ResXmlAttribute)this.get(i);
                attribute.setAttributesUnitSize(unitSize);
                int position = reader.getPosition();
                attribute.readBytes(reader);
                reader.seek(position + unitSize);
            }
        }
    }

    public void clear() {
        this.clearChildes();
        this.updateCountReference();
    }

    public ResXmlAttribute getOrCreateAndroidAttribute(String name, int resourceId) {
        return this.getOrCreateAttribute(Namespace.URI_ANDROID, Namespace.PREFIX_ANDROID, name, resourceId);
    }

    public ResXmlAttribute getOrCreateAttribute(String uri, String prefix, String name, int resourceId) {
        ResXmlAttribute attribute = this.searchAttribute(name, resourceId);
        if (attribute == null) {
            attribute = this.createNext();
            attribute.setName(name, resourceId);
            attribute.setNamespace(uri, prefix);
            this.linkPositionalAttribute(attribute);
        }
        return attribute;
    }

    public ResXmlAttribute getOrCreateAttribute(String name, int resourceId) {
        ResXmlAttribute attribute = this.searchAttribute(name, resourceId);
        if (attribute == null) {
            attribute = this.createNext();
            attribute.setName(name, resourceId);
            this.linkPositionalAttribute(attribute);
        }
        return attribute;
    }

    private ResXmlAttribute searchAttribute(String name, int resourceId) {
        if (resourceId == 0) {
            return this.searchAttributeByName(name);
        }
        return this.searchAttributeByResourceId(resourceId);
    }

    public ResXmlAttribute searchAttributeByName(String name) {
        if (name == null) {
            return null;
        }
        ResXmlAttribute withIdAttribute = null;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ResXmlAttribute attribute = (ResXmlAttribute)this.get(i);
            if (!attribute.equalsName(name)) continue;
            if (attribute.getNameId() != 0) {
                withIdAttribute = attribute;
                continue;
            }
            return attribute;
        }
        return withIdAttribute;
    }

    public ResXmlAttribute searchAttributeByResourceId(int resourceId) {
        if (resourceId == 0) {
            return null;
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ResXmlAttribute attribute = (ResXmlAttribute)this.get(i);
            if (resourceId != attribute.getNameId()) continue;
            return attribute;
        }
        return null;
    }

    public ResXmlAttribute searchAttribute(String namespace, String name) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ResXmlAttribute attribute = (ResXmlAttribute)this.get(i);
            if (!attribute.isEqual(namespace, name)) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public void onPreRemove(ResXmlAttribute attribute) {
        super.onPreRemove(attribute);
        ResXmlAttributePosition position = this.getPosition(attribute);
        if (position != null) {
            position.setAttribute(null);
        }
        attribute.onRemoved();
    }

    public void merge(ResXmlAttributeArray attributeArray) {
        Iterator iterator = attributeArray.iterator();
        while (iterator.hasNext()) {
            ResXmlAttribute coming = (ResXmlAttribute)iterator.next();
            ResXmlAttribute attribute = this.createNext();
            attribute.merge(coming);
            this.mergePositionalAttribute(attribute, attributeArray, coming);
        }
    }

    public void mergeWithName(ResourceMergeOption option, ResXmlAttributeArray attributeArray) {
        Iterator iterator = attributeArray.iterator();
        while (iterator.hasNext()) {
            ResXmlAttribute coming = (ResXmlAttribute)iterator.next();
            ResXmlAttribute attribute = this.createNext();
            attribute.mergeWithName(option, coming);
            this.mergePositionalAttribute(attribute, attributeArray, coming);
        }
    }

    private void mergePositionalAttribute(ResXmlAttribute attribute, ResXmlAttributeArray sourceArray, ResXmlAttribute source) {
        ResXmlAttributePosition sourcePosition = sourceArray.getPosition(source);
        if (sourcePosition != null) {
            this.getPosition(sourcePosition.type()).setAttribute(attribute);
        }
    }

    @Override
    public JSONArray toJson() {
        return ResXmlAttributeArray.toJsonArray(this);
    }

    @Override
    public void fromJson(JSONArray json) {
        if (json != null) {
            int start = this.size();
            int length = json.length();
            this.setSize(start + length);
            for (int i = 0; i < length; ++i) {
                ((ResXmlAttribute)this.get(start + i)).fromJson(json.getJSONObject(i));
            }
            this.computePositionalAttributes();
            this.sort();
        }
    }

    public void serialize(XmlSerializer serializer, boolean decode) throws IOException {
        if (decode) {
            this.getStartElement().fixClassStyleAttributeNames();
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ((ResXmlAttribute)this.get(i)).serialize(serializer, decode);
        }
    }

    public void parse(XmlPullParser parser) throws IOException {
        int count = parser.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            String uri;
            String name = parser.getAttributeName(i);
            String prefix = XMLUtil.splitPrefix(name);
            name = XMLUtil.splitName(name);
            String value = parser.getAttributeValue(i);
            if (Namespace.isValidNamespace(value, prefix)) continue;
            if (prefix == null) {
                prefix = StringsUtil.emptyToNull(parser.getAttributePrefix(i));
            }
            if (prefix != null) {
                ResXmlNamespace ns;
                uri = parser.getAttributeNamespace(i);
                if (StringsUtil.isEmpty(uri) && (ns = this.element().getNamespaceForPrefix(prefix)) != null) {
                    uri = ns.getUri();
                }
            } else {
                uri = null;
            }
            try {
                this.createNext().encode(false, uri, prefix, name, value);
                continue;
            }
            catch (IOException e) {
                throw new IOException(XMLUtil.getSimplePositionDescription(parser) + "\n" + e.getMessage(), e);
            }
        }
        if (count != 0) {
            this.computePositionalAttributes();
            this.sort();
        }
    }

    public void toXml(XMLElement element, boolean decode) {
        if (decode) {
            this.getStartElement().fixClassStyleAttributeNames();
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            element.addAttribute(((ResXmlAttribute)this.get(i)).toXml(decode));
        }
    }

    static class AttributesCreator
    implements Creator<ResXmlAttribute> {
        private final IntegerReference unitSize;

        public AttributesCreator(IntegerReference unitSize) {
            this.unitSize = unitSize;
        }

        @Override
        public ResXmlAttribute newInstance() {
            ResXmlAttribute attribute = new ResXmlAttribute();
            attribute.setAttributesUnitSize(this.unitSize.get());
            return attribute;
        }
    }
}

