/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.chunk.xml.ResXmlAttribute;
import com.reandroid.arsc.chunk.xml.ResXmlAttributeArray;
import com.reandroid.arsc.chunk.xml.ResXmlStartElement;
import com.reandroid.arsc.item.ShortItem;
import com.reandroid.utils.ObjectsUtil;

public class ResXmlAttributePosition
extends ShortItem {
    private final int type;
    private ResXmlAttribute mAttribute;
    public static final int TYPE_ID = ObjectsUtil.of(0);
    public static final int TYPE_CLASS = ObjectsUtil.of(1);
    public static final int TYPE_STYLE = ObjectsUtil.of(2);

    public ResXmlAttributePosition(int type) {
        this.type = type;
    }

    public int getPosition() {
        return this.get() - 1;
    }

    public void setPosition(int position) {
        this.writePosition(position);
        this.pullAttribute(true);
    }

    public ResXmlAttribute getAttribute() {
        return this.mAttribute;
    }

    public void setAttribute(ResXmlAttribute attribute) {
        this.mAttribute = attribute;
        int position = attribute != null ? attribute.getIndex() : -1;
        this.writePosition(position);
    }

    public void computePosition() {
        ResXmlAttribute attribute = null;
        ResXmlAttributeArray attributeArray = this.getAttributeArray();
        if (attributeArray != null) {
            attribute = this.computePosition(attributeArray);
        }
        this.setAttribute(attribute);
    }

    private ResXmlAttribute computePosition(ResXmlAttributeArray attributeArray) {
        int type = this.type();
        if (type == TYPE_ID) {
            return attributeArray.searchAttributeByResourceId(ResXmlAttribute.ATTRIBUTE_RESOURCE_ID_id);
        }
        if (type == TYPE_CLASS) {
            return attributeArray.searchAttributeByName(ResXmlAttribute.ATTRIBUTE_NAME_CLASS);
        }
        if (type == TYPE_STYLE) {
            return attributeArray.searchAttributeByName(ResXmlAttribute.ATTRIBUTE_NAME_STYLE);
        }
        throw new RuntimeException("Unknown position type: " + type);
    }

    public void clear() {
        this.mAttribute = null;
        this.writePosition(-1);
    }

    public void refresh() {
        ResXmlAttribute attribute = this.mAttribute;
        if (ResXmlAttributePosition.isInvalidAttribute(attribute)) {
            this.clear();
        } else {
            this.writePosition(attribute.getIndex());
        }
    }

    void linkAttribute() {
        this.pullAttribute(false);
    }

    private void writePosition(int position) {
        if (position < -1 || position > 65534) {
            throw new IndexOutOfBoundsException("Attribute position " + position + " out of range, must be between -1 to 65534");
        }
        this.set(position + 1);
    }

    private void pullAttribute(boolean validate) {
        int position = this.getPosition();
        ResXmlAttribute attribute = null;
        if (position >= 0) {
            ResXmlAttributeArray attributeArray = this.getAttributeArray();
            if (attributeArray != null) {
                attribute = (ResXmlAttribute)attributeArray.get(position);
            }
            if (validate && attribute == null) {
                if (attributeArray == null) {
                    throw new IllegalArgumentException("Unable to find attributes array, could be removed or uninitialized element");
                }
                throw new IndexOutOfBoundsException("Position " + position + " out of range, for " + attributeArray.size());
            }
        }
        this.mAttribute = attribute;
    }

    private ResXmlAttributeArray getAttributeArray() {
        ResXmlStartElement startElement = this.getParentInstance(ResXmlStartElement.class);
        if (startElement != null) {
            return startElement.getResXmlAttributeArray();
        }
        return (ResXmlAttributeArray)ObjectsUtil.getNull();
    }

    void fixName() {
        int type = this.type();
        if (type == TYPE_CLASS) {
            this.fixName(ResXmlAttribute.ATTRIBUTE_NAME_CLASS);
        } else if (type == TYPE_STYLE) {
            this.fixName(ResXmlAttribute.ATTRIBUTE_NAME_STYLE);
        }
    }

    private void fixName(String name) {
        ResXmlAttribute attribute = this.mAttribute;
        if (attribute != null && !name.equals(attribute.getName())) {
            attribute.setName(name);
        }
    }

    public int type() {
        return this.type;
    }

    @Override
    public String toString() {
        return this.getPosition() + " (" + this.mAttribute + ")";
    }

    private static boolean isInvalidAttribute(ResXmlAttribute attribute) {
        return attribute == null || attribute.isNull() || attribute.isUndefined() || attribute.getParent() == null;
    }

    public static int getPositionType(ResXmlAttribute attribute) {
        int id = attribute.getNameId();
        if (id != 0) {
            if (id == ResXmlAttribute.ATTRIBUTE_RESOURCE_ID_id) {
                return TYPE_ID;
            }
        } else {
            if (ResXmlAttribute.ATTRIBUTE_NAME_CLASS.equals(attribute.getName())) {
                return TYPE_CLASS;
            }
            if (ResXmlAttribute.ATTRIBUTE_NAME_STYLE.equals(attribute.getName())) {
                return TYPE_STYLE;
            }
        }
        return -1;
    }
}

