/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.ApkFile;
import com.reandroid.arsc.chunk.Chunk;
import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.chunk.xml.ResXmlIDMap;
import com.reandroid.arsc.chunk.xml.ResXmlNode;
import com.reandroid.arsc.chunk.xml.ResXmlNodeList;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.header.HeaderBlock;
import com.reandroid.arsc.header.InfoHeader;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.pool.ResXmlStringPool;
import com.reandroid.common.BytesOutputStream;
import java.io.IOException;

public class ResXmlDocumentChunk
extends Chunk<HeaderBlock> {
    private final ResXmlStringPool mResXmlStringPool = new ResXmlStringPool(true);
    private final ResXmlIDMap mResXmlIDMap = new ResXmlIDMap();
    private final ResXmlNodeList mNodeList = new ResXmlNodeList();
    private PackageBlock mPackageBlock;
    private static boolean UNKNOWN_CHUNK_LOGGED;

    public ResXmlDocumentChunk() {
        super(new HeaderBlock(ChunkType.XML), 3);
        this.addChild(this.mResXmlStringPool);
        this.addChild(this.mResXmlIDMap);
        this.addChild(this.mNodeList);
    }

    public BlockList<ResXmlNode> getNodeListBlockInternal() {
        return this.mNodeList;
    }

    public void refreshFull() {
        ResXmlStringPool stringPool = this.getStringPool();
        stringPool.compressDuplicates();
        stringPool.removeUnusedStrings();
        this.refresh();
    }

    @Override
    public byte[] getBytes() {
        BytesOutputStream outputStream = new BytesOutputStream(((HeaderBlock)this.getHeaderBlock()).getChunkSize());
        try {
            this.writeBytes(outputStream);
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return outputStream.toByteArray();
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        boolean readOk;
        InfoHeader headerBlock = reader.readHeaderBlock();
        if (headerBlock == null) {
            throw new IOException("Not bin xml: " + reader);
        }
        int chunkSize = headerBlock.getChunkSize();
        if (chunkSize < 0) {
            throw new IOException("Negative chunk size: " + chunkSize);
        }
        if (chunkSize > reader.available()) {
            throw new IOException("Higher chunk size: " + chunkSize + ", available = " + reader.available());
        }
        if (chunkSize < headerBlock.getHeaderSize()) {
            throw new IOException("Higher header size: " + headerBlock);
        }
        BlockReader chunkReader = reader.create(chunkSize);
        headerBlock = this.getHeaderBlock();
        headerBlock.readBytes(chunkReader);
        headerBlock.setType(ChunkType.XML);
        this.document().clear();
        while (chunkReader.isAvailable() && (readOk = this.readNext(chunkReader))) {
        }
        reader.offset(headerBlock.getChunkSize());
        chunkReader.close();
        this.onChunkLoaded();
    }

    @Override
    public void onChunkLoaded() {
        super.onChunkLoaded();
        this.document().linkStringReferences();
    }

    private boolean readNext(BlockReader reader) throws IOException {
        if (!reader.isAvailable()) {
            return false;
        }
        int position = reader.getPosition();
        InfoHeader headerBlock = reader.readHeaderBlock();
        if (headerBlock == null) {
            return false;
        }
        ChunkType chunkType = headerBlock.getChunkType();
        if (chunkType == ChunkType.STRING && this.mResXmlStringPool.size() == 0) {
            this.mResXmlStringPool.readBytes(reader);
        } else if (chunkType == ChunkType.XML_RESOURCE_MAP && this.mResXmlIDMap.size() == 0) {
            this.mResXmlIDMap.readBytes(reader);
        } else {
            if (chunkType == ChunkType.XML_CDATA) {
                this.document().newText().readBytes(reader);
                return reader.isAvailable();
            }
            if (chunkType == ChunkType.XML) {
                this.document().newDocument().readBytes(reader);
                return reader.isAvailable();
            }
            if (chunkType == ChunkType.XML_START_ELEMENT || chunkType == ChunkType.XML_START_NAMESPACE) {
                this.document().newElement().readBytes(reader);
                return reader.isAvailable();
            }
            ResXmlDocumentChunk.logUnknownChunkOnce(headerBlock);
            this.document().newUnknown(chunkType).readBytes(reader);
        }
        return reader.isAvailable() && position != reader.getPosition();
    }

    public ResXmlStringPool getStringPool() {
        return this.mResXmlStringPool;
    }

    public ApkFile getApkFile() {
        return this.document().getApkFile();
    }

    public PackageBlock getPackageBlock() {
        ApkFile apkFile = this.getApkFile();
        PackageBlock packageBlock = this.mPackageBlock;
        if (apkFile == null || packageBlock != null) {
            return packageBlock;
        }
        TableBlock tableBlock = apkFile.getLoadedTableBlock();
        if (tableBlock != null) {
            this.mPackageBlock = packageBlock = this.selectPackageBlock(tableBlock);
        }
        return packageBlock;
    }

    public void setPackageBlock(PackageBlock packageBlock) {
        this.mPackageBlock = packageBlock;
    }

    PackageBlock selectPackageBlock(TableBlock tableBlock) {
        PackageBlock packageBlock = tableBlock.pickOne();
        if (packageBlock == null) {
            packageBlock = tableBlock.pickOrEmptyPackage();
        }
        return packageBlock;
    }

    public TableBlock getTableBlock() {
        TableBlock tableBlock;
        PackageBlock packageBlock = this.getPackageBlock();
        if (packageBlock != null && (tableBlock = packageBlock.getTableBlock()) != null) {
            return tableBlock;
        }
        ApkFile apkFile = this.getApkFile();
        if (apkFile != null) {
            return apkFile.getLoadedTableBlock();
        }
        return null;
    }

    public ResXmlIDMap getResXmlIDMap() {
        return this.mResXmlIDMap;
    }

    public ResXmlElement getDocumentElement() {
        return this.document().getDocumentElement();
    }

    public ResXmlElement newElement() {
        this.clearEmptyElements();
        return this.document().newElement();
    }

    public void clearEmptyElements() {
        this.document().removeElementsIf(ResXmlElement::isUndefined);
    }

    @Override
    protected void onPreRefresh() {
        this.clearEmptyElements();
        this.getNodeListBlockInternal().refresh();
        super.onPreRefresh();
    }

    @Override
    protected void onChunkRefreshed() {
    }

    ResXmlDocument document() {
        return this.getParentInstance(ResXmlDocument.class);
    }

    ResXmlNodeList getNodeList() {
        return this.mNodeList;
    }

    private static void logUnknownChunkOnce(HeaderBlock headerBlock) {
        if (!UNKNOWN_CHUNK_LOGGED) {
            UNKNOWN_CHUNK_LOGGED = true;
            System.err.println("Read unknown chunk: " + headerBlock);
        }
    }
}

