/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.xml.ResXmlAttribute;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.chunk.xml.ResXmlNode;
import com.reandroid.arsc.chunk.xml.ResXmlNodeTree;
import com.reandroid.arsc.chunk.xml.ResXmlTextNode;
import com.reandroid.arsc.chunk.xml.UnexpectedResXmlNode;
import com.reandroid.arsc.chunk.xml.UnknownResXmlNode;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.FilterIterator;
import com.reandroid.utils.collection.IterableIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

abstract class ResXmlDocumentOrElement
extends ResXmlNodeTree {
    ResXmlDocumentOrElement(Block chunk) {
        super(chunk);
    }

    public Iterator<ResXmlElement> getElements() {
        return this.iterator(ResXmlElement.class);
    }

    public Iterator<ResXmlTextNode> getTexts() {
        return this.iterator(ResXmlTextNode.class);
    }

    public int getElementsCount() {
        return this.countNodeWithType(ResXmlElement.class);
    }

    public int getElementsCount(String name) {
        return CollectionUtil.count(this.getElements(name));
    }

    public int getTextsCount() {
        return this.countNodeWithType(ResXmlTextNode.class);
    }

    public boolean hasElement() {
        return this.containsNodeWithType(ResXmlElement.class);
    }

    public boolean hasText() {
        return this.containsNodeWithType(ResXmlTextNode.class);
    }

    public ResXmlElement getElement(String name) {
        return CollectionUtil.getFirst(this.getElements(name));
    }

    public ResXmlElement getOrCreateElement(String name) {
        ResXmlElement element = this.getElement(name);
        if (element == null) {
            element = this.newElement(name);
        }
        return element;
    }

    public Iterator<ResXmlElement> getElements(String name) {
        return this.iterator(ResXmlElement.class, element -> element.equalsName(name));
    }

    public Iterator<ResXmlElement> getElementsWithChild(String ... childNames) {
        if (childNames == null || childNames.length == 0) {
            return EmptyIterator.of();
        }
        return this.getElementsWithChild(childNames, 0);
    }

    Iterator<ResXmlElement> getElementsWithChild(final String[] childNames, int start) {
        int last = childNames.length - 1;
        if (start > last) {
            return EmptyIterator.of();
        }
        Iterator<ResXmlElement> iterator = this.getElements(childNames[start]);
        if (start == last || !iterator.hasNext()) {
            return iterator;
        }
        final int next = start + 1;
        return new IterableIterator<ResXmlElement, ResXmlElement>(iterator){

            @Override
            public Iterator<ResXmlElement> iterator(ResXmlElement element) {
                return element.getElementsWithChild(childNames, next);
            }
        };
    }

    public boolean removeElementsIf(Predicate<? super ResXmlElement> predicate) {
        return this.removeIf((Predicate<? super ResXmlNode>)((Predicate<ResXmlNode>)xmlNode -> xmlNode instanceof ResXmlElement && predicate.test((ResXmlElement)xmlNode)));
    }

    public void setAttributesUnitSize(int size, boolean recursive) {
        Iterator<ResXmlElement> iterator = this.getElements();
        while (iterator.hasNext()) {
            ResXmlElement element = iterator.next();
            element.setAttributesUnitSize(size, recursive);
        }
    }

    public int lastIndexOf(String name) {
        Iterator<ResXmlElement> iterator = this.getElements(name);
        ResXmlElement element = CollectionUtil.getLast(iterator);
        if (element != null) {
            return element.getIndex();
        }
        return -1;
    }

    @Deprecated
    public List<ResXmlElement> listElements(String name) {
        return CollectionUtil.toList(this.getElements(name));
    }

    public Iterator<ResXmlElement> getElements(Predicate<? super ResXmlElement> predicate) {
        return this.iterator(ResXmlElement.class, predicate);
    }

    public Iterator<ResXmlElement> recursiveElements() {
        return this.recursive(ResXmlElement.class);
    }

    public Iterator<ResXmlElement> recursiveElements(Predicate<? super ResXmlElement> predicate) {
        return this.recursive(ResXmlElement.class, predicate);
    }

    public Iterator<ResXmlAttribute> recursiveAttributes(Predicate<? super ResXmlAttribute> predicate) {
        return FilterIterator.of(this.recursiveAttributes(), predicate);
    }

    public Iterator<ResXmlAttribute> recursiveAttributes() {
        Iterator<Object> iterator = new IterableIterator<ResXmlElement, ResXmlAttribute>(this.recursiveElements()){

            @Override
            public Iterator<ResXmlAttribute> iterator(ResXmlElement element) {
                return element.getAttributes();
            }
        };
        if (this instanceof ResXmlElement) {
            iterator = CombiningIterator.two(((ResXmlElement)this).getAttributes(), iterator);
        }
        return iterator;
    }

    @Override
    public ResXmlElement newElement() {
        return this.newElement(null);
    }

    public ResXmlElement newElement(String name) {
        ResXmlElement element = new ResXmlElement();
        this.add(element);
        if (name != null) {
            element.setName(name);
        }
        return element;
    }

    public ResXmlElement newElementAt(int position) {
        return this.newElementAt(position, null);
    }

    public ResXmlElement newElementAt(int position, String name) {
        ResXmlElement element = new ResXmlElement();
        this.add(position, element);
        if (name != null) {
            element.setName(name);
        }
        return element;
    }

    @Override
    public ResXmlTextNode newText() {
        ResXmlTextNode textNode = new ResXmlTextNode();
        this.add(textNode);
        return textNode;
    }

    @Override
    public ResXmlDocument newDocument() {
        ResXmlDocument document = new ResXmlDocument();
        this.add(document);
        return document;
    }

    @Override
    public UnknownResXmlNode newUnknown() {
        return this.newUnknown(ChunkType.NULL);
    }

    @Override
    public UnknownResXmlNode newUnknown(ChunkType chunkType) {
        UnknownResXmlNode xmlNode = UnexpectedResXmlNode.isSet(chunkType) ? new UnexpectedResXmlNode(chunkType) : new UnknownResXmlNode();
        this.add(xmlNode);
        return xmlNode;
    }

    public ResXmlTextNode getOrCreateLastText() {
        ResXmlNode node;
        ResXmlTextNode textNode = null;
        int size = this.size();
        if (size != 0 && (node = this.get(size - 1)) instanceof ResXmlTextNode && (textNode = (ResXmlTextNode)node).isComment()) {
            textNode = null;
        }
        if (textNode == null) {
            textNode = this.newText();
        }
        return textNode;
    }

    public void removeUnusedNamespaces() {
        Iterator<ResXmlElement> iterator = this.getElements();
        while (iterator.hasNext()) {
            iterator.next().removeUnusedNamespaces();
        }
    }

    public void removeUndefinedAttributes() {
        Iterator<ResXmlElement> iterator = this.getElements();
        while (iterator.hasNext()) {
            iterator.next().removeUndefinedAttributes();
        }
    }

    public void fixNamespaces() {
        Iterator<ResXmlElement> iterator = this.getElements();
        while (iterator.hasNext()) {
            iterator.next().fixNamespaces();
        }
    }

    public void fixAttributeNames() {
        Iterator<ResXmlAttribute> iterator = this.recursiveAttributes();
        while (iterator.hasNext()) {
            iterator.next().autoSetName();
        }
    }

    @Override
    void linkStringReferences() {
        Iterator<ResXmlNode> iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next().linkStringReferences();
        }
    }

    public boolean removeNullElements() {
        boolean result = false;
        if (this.removeElementsIf(ResXmlElement::isUndefined)) {
            result = true;
        }
        Iterator<ResXmlElement> iterator = this.getElements();
        while (iterator.hasNext()) {
            if (!iterator.next().removeNullElements()) continue;
            result = true;
        }
        return result;
    }

    public boolean autoSetAttributeNames() {
        boolean result = false;
        Iterator<ResXmlAttribute> iterator = this.recursiveAttributes();
        while (iterator.hasNext()) {
            ResXmlAttribute attribute = iterator.next();
            if (!attribute.autoSetName()) continue;
            result = true;
        }
        return result;
    }

    @Override
    public void parse(XmlPullParser parser) throws IOException, XmlPullParserException {
        this.parseInnerNodes(parser);
    }

    void parseInnerNodes(XmlPullParser parser) throws IOException, XmlPullParserException {
        int event;
        while (!this.isEndEvent(event = parser.getEventType())) {
            ResXmlNode node = this.createForEvent(event);
            node.parse(parser);
        }
    }

    private ResXmlNode createForEvent(int event) {
        if (event == 2) {
            return this.newElement();
        }
        if (ResXmlDocumentOrElement.isTextEvent(event)) {
            return this.getOrCreateLastText();
        }
        if (event == 9) {
            return this.newText();
        }
        if (event == 0) {
            return this.newDocument();
        }
        throw new RuntimeException("Unexpected event " + event);
    }

    private boolean isEndEvent(int event) {
        return event == 3 && this.isElement() || event == 1 && this.isDocument();
    }
}

