/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.xml.ResXmlNamespaceChunk;
import com.reandroid.arsc.chunk.xml.ResXmlStartNamespace;
import com.reandroid.arsc.header.InfoHeader;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.utils.CompareUtil;
import java.io.IOException;

public class ResXmlEndNamespace
extends ResXmlNamespaceChunk
implements Comparable<ResXmlEndNamespace> {
    private ResXmlStartNamespace mStartNamespace;

    public ResXmlEndNamespace() {
        super(ChunkType.XML_END_NAMESPACE);
    }

    public ResXmlStartNamespace getStart() {
        return this.mStartNamespace;
    }

    void setStart(ResXmlStartNamespace startNamespace) {
        if (startNamespace.getEnd() != this) {
            throw new IllegalArgumentException("Invalid start namespace: " + startNamespace);
        }
        this.mStartNamespace = startNamespace;
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        InfoHeader headerBlock = reader.readHeaderBlock();
        if (headerBlock.getChunkSize() < 8) {
            super.onReadChildes(reader);
        } else {
            super.onReadBytes(reader);
        }
    }

    int getStartIndex() {
        return this.getStart().getIndex();
    }

    @Override
    public int compareTo(ResXmlEndNamespace endNamespace) {
        if (endNamespace == this) {
            return 0;
        }
        return CompareUtil.compareUnsigned(endNamespace.getStartIndex(), this.getStartIndex());
    }
}

