/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.chunk.Chunk;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.header.XmlIDMapHeader;
import com.reandroid.arsc.item.ResXmlID;
import com.reandroid.arsc.item.ResXmlString;
import com.reandroid.arsc.list.ResXmlIDList;
import com.reandroid.arsc.pool.ResXmlStringPool;
import java.util.Iterator;

public class ResXmlIDMap
extends Chunk<XmlIDMapHeader>
implements Iterable<ResXmlID> {
    private final ResXmlIDList mResXmlIDArray = new ResXmlIDList(((XmlIDMapHeader)this.getHeaderBlock()).getIdsCount());

    public ResXmlIDMap() {
        super(new XmlIDMapHeader(), 1);
        this.addChild(this.mResXmlIDArray);
    }

    void removeSafely(ResXmlID resXmlID) {
        if (resXmlID == null || resXmlID.getParent() == null || resXmlID.getIndex() < 0 || resXmlID.hasReference()) {
            return;
        }
        ResXmlString xmlString = resXmlID.getResXmlString();
        if (xmlString == null || xmlString.getParent() == null || xmlString.getIndex() < 0 || xmlString.hasReference()) {
            return;
        }
        ResXmlStringPool stringPool = this.getXmlStringPool();
        if (stringPool == null) {
            return;
        }
        resXmlID.set(0);
        this.getResXmlIDArray().remove(resXmlID);
        stringPool.removeString(xmlString);
    }

    public int size() {
        return this.getResXmlIDArray().size();
    }

    public ResXmlID get(int index) {
        return (ResXmlID)this.getResXmlIDArray().get(index);
    }

    public void destroy() {
        this.getResXmlIDArray().clear();
    }

    public ResXmlIDList getResXmlIDArray() {
        return this.mResXmlIDArray;
    }

    @Override
    public Iterator<ResXmlID> iterator() {
        return this.getResXmlIDArray().iterator();
    }

    public ResXmlID getOrCreate(int resourceId) {
        return this.getResXmlIDArray().getOrCreate(resourceId);
    }

    @Override
    protected void onChunkRefreshed() {
    }

    private ResXmlStringPool getXmlStringPool() {
        ResXmlDocument resXmlDocument = this.getParentInstance(ResXmlDocument.class);
        if (resXmlDocument != null) {
            return resXmlDocument.getStringPool();
        }
        return null;
    }

    @Override
    public void onChunkLoaded() {
        super.onChunkLoaded();
        ResXmlStringPool resXmlStringPool = this.getXmlStringPool();
        if (resXmlStringPool != null && !resXmlStringPool.isEmpty()) {
            resXmlStringPool.linkResXmlIDMapInternal();
        }
    }
}

