/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.xml.ResXmlNode;
import com.reandroid.arsc.chunk.xml.ResXmlNodeList;
import com.reandroid.arsc.refactor.ResourceMergeOption;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONException;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.InstanceIterator;
import com.reandroid.utils.collection.IterableIterator;
import com.reandroid.utils.collection.SingleIterator;
import com.reandroid.xml.base.NodeTree;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.xmlpull.v1.XmlSerializer;

public abstract class ResXmlNodeTree
extends ResXmlNode
implements NodeTree<ResXmlNode> {
    private List<ResXmlNode> CHILD_NODES;
    private ResXmlNode PARENT_NODE;

    ResXmlNodeTree(Block chunk) {
        super(chunk);
    }

    @Override
    public ResXmlNode get(int i) {
        return (ResXmlNode)this.getNodeList().get(i);
    }

    @Override
    public int size() {
        return this.getNodeList().size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<ResXmlNode> iterator() {
        return this.getNodeList().iterator();
    }

    public <T extends ResXmlNode> Iterator<T> recursive(Class<T> instance) {
        return InstanceIterator.of(this.recursive(), instance);
    }

    public <T extends ResXmlNode> Iterator<T> recursive(Class<T> instance, Predicate<? super T> predicate) {
        return InstanceIterator.of(this.recursive(), instance, predicate);
    }

    public Iterator<ResXmlNode> recursive() {
        return new IterableIterator<ResXmlNode, ResXmlNode>(this.iterator()){

            @Override
            public Iterator<ResXmlNode> iterator(ResXmlNode resXmlNode) {
                if (resXmlNode instanceof ResXmlNodeTree) {
                    return CombiningIterator.singleOne(resXmlNode, ((ResXmlNodeTree)resXmlNode).recursive());
                }
                return SingleIterator.of(resXmlNode);
            }
        };
    }

    public Iterator<ResXmlNode> reversedIterator() {
        return this.getNodeList().reversedIterator();
    }

    public Iterator<ResXmlNode> reversedRecursive() {
        return new IterableIterator<ResXmlNode, ResXmlNode>(this.reversedIterator()){

            @Override
            public Iterator<ResXmlNode> iterator(ResXmlNode resXmlNode) {
                if (resXmlNode instanceof ResXmlNodeTree) {
                    return CombiningIterator.two(((ResXmlNodeTree)resXmlNode).reversedRecursive(), SingleIterator.of(resXmlNode));
                }
                return SingleIterator.of(resXmlNode);
            }
        };
    }

    @Override
    public boolean add(ResXmlNode resXmlNode) {
        return this.getNodeList().add(resXmlNode);
    }

    @Override
    public void add(int index, ResXmlNode resXmlNode) {
        this.getNodeList().add(index, resXmlNode);
    }

    public int indexOf(ResXmlNode resXmlNode) {
        return this.getNodeList().indexOf(resXmlNode);
    }

    public void moveTo(ResXmlNode resXmlNode, int index) {
        this.getNodeList().moveTo(resXmlNode, index);
    }

    @Override
    public boolean remove(ResXmlNode resXmlNode) {
        return this.getNodeList().remove(resXmlNode);
    }

    @Override
    public ResXmlNode remove(int i) {
        return (ResXmlNode)this.getNodeList().remove(i);
    }

    @Override
    public boolean removeIf(Predicate<? super ResXmlNode> predicate) {
        return this.getNodeList().removeIf(predicate);
    }

    public int countIf(Predicate<? super ResXmlNode> predicate) {
        return this.getNodeList().countIf(predicate);
    }

    @Override
    public boolean sort(Comparator<? super ResXmlNode> comparator) {
        return this.getNodeList().sort(comparator);
    }

    @Override
    public void clear() {
        this.getNodeList().clearChildes();
    }

    @Override
    public boolean removeSelf() {
        ResXmlNodeTree parentNode = this.getParentNode();
        if (parentNode != null) {
            return parentNode.remove(this);
        }
        return false;
    }

    @Override
    public ResXmlNodeTree getParentNode() {
        return (ResXmlNodeTree)super.getParentNode();
    }

    @Override
    void onPreRemove() {
        this.clear();
    }

    abstract ResXmlNodeList getNodeList();

    public abstract ResXmlNode newElement();

    public abstract ResXmlNode newText();

    public abstract ResXmlNode newDocument();

    ResXmlNode newUnknown() {
        return null;
    }

    ResXmlNode newUnknown(ChunkType chunkType) {
        return null;
    }

    @Override
    ResXmlNode newSimilarTo(ResXmlNode otherNode) {
        if (otherNode.isElement()) {
            return this.newElement();
        }
        if (otherNode.isText() || otherNode.isComment()) {
            return this.newText();
        }
        if (otherNode.isDocument()) {
            return this.newDocument();
        }
        if (otherNode.isUnknown()) {
            return this.newUnknown();
        }
        throw new RuntimeException("Unknown node class: " + otherNode.getClass());
    }

    ResXmlNode newForNodeJson(JSONObject node) {
        String typeName = node.getString(JSON_node_type);
        if (JSON_node_type_unknown.equals(typeName)) {
            return this.newUnknown(ChunkType.get((short)node.optInt(JSON_type, 0)));
        }
        return this.newForNodeTypeName(typeName);
    }

    ResXmlNode newForNodeTypeName(String name) {
        if (JSON_node_type_element.equals(name)) {
            return this.newElement();
        }
        if (JSON_node_type_document.equals(name)) {
            return this.newDocument();
        }
        if (JSON_node_type_text.equals(name) || JSON_node_type_comment.equals(name)) {
            return this.newText();
        }
        throw new JSONException("Unknown node type name: " + name);
    }

    @Override
    public void merge(ResXmlNode xmlNode) {
        if (xmlNode == this) {
            return;
        }
        ResXmlNodeTree comingTree = (ResXmlNodeTree)xmlNode;
        Iterator<ResXmlNode> iterator = comingTree.iterator();
        while (iterator.hasNext()) {
            ResXmlNode coming = iterator.next();
            ResXmlNode child = this.newSimilarTo(coming);
            child.merge(coming);
        }
    }

    @Override
    public void mergeWithName(ResourceMergeOption mergeOption, ResXmlNode xmlNode) {
        ResXmlNodeTree comingTree = (ResXmlNodeTree)xmlNode;
        Iterator<ResXmlNode> iterator = comingTree.iterator();
        while (iterator.hasNext()) {
            ResXmlNode coming = iterator.next();
            ResXmlNode destination = this.newSimilarTo(coming);
            destination.mergeWithName(mergeOption, coming);
        }
    }

    void serializeNodes(XmlSerializer serializer, boolean decode) throws IOException {
        Iterator<ResXmlNode> iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next().serialize(serializer, decode);
        }
    }

    JSONArray nodesToJson() {
        JSONArray jsonArray = null;
        Iterator<ResXmlNode> iterator = this.iterator();
        while (iterator.hasNext()) {
            JSONObject jsonObject = iterator.next().toJson();
            if (jsonObject == null) continue;
            if (jsonArray == null) {
                jsonArray = new JSONArray();
            }
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    void nodesFromJson(JSONObject json) {
        JSONArray jsonArray = json.optJSONArray(JSON_nodes);
        if (jsonArray == null) {
            return;
        }
        int size = jsonArray.length();
        for (int i = 0; i < size; ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            if (!jsonObject.has(JSON_node_type)) {
                throw new JSONException("Missing: " + JSON_node_type);
            }
            this.newForNodeJson(jsonObject).fromJson(jsonObject);
        }
    }

    void touchChildNodesForDebug() {
        this.PARENT_NODE = this.getParentNode();
        if (this.CHILD_NODES == null) {
            this.CHILD_NODES = new AbstractList<ResXmlNode>(){

                @Override
                public ResXmlNode get(int i) {
                    return ResXmlNodeTree.this.get(i);
                }

                @Override
                public int size() {
                    return ResXmlNodeTree.this.size();
                }
            };
        }
    }

    @Override
    public String toString() {
        this.touchChildNodesForDebug();
        return super.toString();
    }
}

