/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.xml.ResXmlAttribute;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.chunk.xml.ResXmlNamespace;
import com.reandroid.arsc.model.ResourceLibrary;
import com.reandroid.xml.XMLUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.xmlpull.v1.XmlSerializer;

public class ResXmlPullSerializer
implements XmlSerializer {
    private PackageBlock mCurrentPackage;
    private ResXmlDocument mDocument;
    private ResXmlElement mCurrentElement;
    private boolean mEndDocument;
    private StringBuilder mCurrentText;
    private boolean mValidateValues;

    public ResXmlDocument getResultDocument() {
        ResXmlDocument document = this.mDocument;
        if (document != null) {
            document.refreshFull();
        }
        return document;
    }

    public void setValidateValues(boolean validateValues) {
        this.mValidateValues = validateValues;
    }

    public boolean isValidateValues() {
        return this.mValidateValues;
    }

    public PackageBlock getCurrentPackage() {
        return this.mCurrentPackage;
    }

    public void setCurrentPackage(PackageBlock packageBlock) {
        this.mCurrentPackage = packageBlock;
        if (this.mDocument != null) {
            this.mDocument.setPackageBlock(packageBlock);
        }
    }

    public void setDocument(ResXmlDocument document) {
        this.mDocument = document;
        if (document == null) {
            return;
        }
        PackageBlock packageBlock = document.getPackageBlock();
        if (packageBlock == null) {
            document.setPackageBlock(this.getCurrentPackage());
        } else if (this.getCurrentPackage() == null) {
            this.setCurrentPackage(packageBlock);
        }
    }

    private ResXmlDocument getCurrentDocument() {
        ResXmlDocument document = this.mDocument;
        if (this.mEndDocument) {
            document = null;
            this.mCurrentElement = null;
            this.mEndDocument = false;
        }
        if (document == null) {
            document = new ResXmlDocument();
            this.mCurrentElement = null;
            this.mDocument = document;
        }
        if (document.getPackageBlock() == null) {
            document.setPackageBlock(this.getCurrentPackage());
        }
        return document;
    }

    private ResXmlElement getCurrentElement() {
        ResXmlElement element = this.mCurrentElement;
        if (element == null) {
            ResXmlDocument document = this.getCurrentDocument();
            element = document.getDocumentElement();
            if (element == null) {
                element = document.newElement();
            }
            this.mCurrentElement = element;
        }
        return element;
    }

    @Override
    public void setFeature(String name, boolean state) throws IllegalArgumentException, IllegalStateException {
    }

    @Override
    public boolean getFeature(String name) {
        return false;
    }

    @Override
    public void setProperty(String name, Object value) throws IllegalArgumentException, IllegalStateException {
    }

    @Override
    public Object getProperty(String name) {
        return null;
    }

    @Override
    public void setOutput(OutputStream os, String encoding) throws IOException, IllegalArgumentException, IllegalStateException {
        throw new IllegalArgumentException("Can not set OutputStream");
    }

    @Override
    public void setOutput(Writer writer) throws IOException, IllegalArgumentException, IllegalStateException {
        throw new IllegalArgumentException("Can not set OutputStream");
    }

    @Override
    public void startDocument(String encoding, Boolean standalone) throws IOException, IllegalArgumentException, IllegalStateException {
        if (this.mCurrentElement != null) {
            this.mEndDocument = true;
        }
    }

    @Override
    public void endDocument() throws IOException, IllegalArgumentException, IllegalStateException {
        this.mEndDocument = true;
    }

    @Override
    public void setPrefix(String prefix, String namespace) throws IOException, IllegalArgumentException, IllegalStateException {
        ResXmlElement element = this.getCurrentElement();
        if (element == null) {
            return;
        }
        element.getOrCreateNamespace(namespace, prefix);
    }

    @Override
    public String getPrefix(String namespace, boolean generatePrefix) throws IllegalArgumentException {
        if (namespace == null) {
            return null;
        }
        ResXmlElement element = this.mCurrentElement;
        if (element == null) {
            return null;
        }
        ResXmlNamespace resXmlNamespace = element.getNamespaceForUri(namespace);
        if (resXmlNamespace == null && generatePrefix) {
            String prefix = namespace.equals(ResourceLibrary.URI_ANDROID) ? ResourceLibrary.PREFIX_ANDROID : ResourceLibrary.PREFIX_APP;
            resXmlNamespace = element.getOrCreateNamespace(namespace, prefix);
        }
        if (resXmlNamespace == null) {
            return null;
        }
        return resXmlNamespace.getPrefix();
    }

    @Override
    public int getDepth() {
        ResXmlElement element = this.mCurrentElement;
        if (element != null) {
            return element.getDepth();
        }
        return 0;
    }

    @Override
    public String getNamespace() {
        ResXmlElement element = this.mCurrentElement;
        if (element != null) {
            return element.getUri();
        }
        return null;
    }

    @Override
    public String getName() {
        ResXmlElement element = this.mCurrentElement;
        if (element != null) {
            return element.getName();
        }
        return null;
    }

    @Override
    public ResXmlPullSerializer startTag(String namespace, String name) throws IOException, IllegalArgumentException, IllegalStateException {
        this.flushText();
        ResXmlElement element = this.getCurrentElement();
        String prefix = null;
        int i = name.indexOf(58);
        if (i > 0) {
            prefix = name.substring(0, i);
            name = name.substring(i + 1);
        } else {
            ResXmlNamespace xmlNamespace = element.getNamespaceForUri(namespace);
            if (xmlNamespace != null) {
                prefix = xmlNamespace.getPrefix();
            }
        }
        if (element.getName() == null) {
            element.setName(name);
        } else {
            this.mCurrentElement = element = element.newElement();
            element.setName(name);
        }
        element.setNamespace(namespace, prefix);
        this.mCurrentElement = element;
        return this;
    }

    @Override
    public ResXmlPullSerializer attribute(String namespace, String name, String value) throws IOException, IllegalArgumentException, IllegalStateException {
        ResXmlNamespace resXmlNamespace;
        ResXmlElement element = this.mCurrentElement;
        String prefix = null;
        int i = name.indexOf(58);
        if (i > 0) {
            prefix = name.substring(0, i);
            name = name.substring(i + 1);
        }
        if (prefix == null && (resXmlNamespace = element.getNamespaceForUri(namespace)) != null) {
            prefix = resXmlNamespace.getPrefix();
        }
        ResXmlAttribute resXmlAttribute = element.newAttribute();
        resXmlAttribute.encode(this.isValidateValues(), namespace, prefix, name, value);
        return this;
    }

    @Override
    public ResXmlPullSerializer endTag(String namespace, String name) throws IOException, IllegalArgumentException, IllegalStateException {
        this.flushText();
        this.mCurrentElement = this.mCurrentElement.getParentElement();
        return this;
    }

    @Override
    public ResXmlPullSerializer text(String text) throws IOException, IllegalArgumentException, IllegalStateException {
        this.appendText(text);
        return this;
    }

    @Override
    public ResXmlPullSerializer text(char[] buf, int start, int len) throws IOException, IllegalArgumentException, IllegalStateException {
        return this.text(new String(buf, start, len));
    }

    @Override
    public void cdsect(String text) throws IOException, IllegalArgumentException, IllegalStateException {
    }

    @Override
    public void entityRef(String text) throws IOException, IllegalArgumentException, IllegalStateException {
        this.appendText(XMLUtil.decodeEntityRef(text));
    }

    @Override
    public void processingInstruction(String text) throws IOException, IllegalArgumentException, IllegalStateException {
    }

    @Override
    public void comment(String text) throws IOException, IllegalArgumentException, IllegalStateException {
        ResXmlElement current = this.getCurrentElement();
        current.setComment(text);
    }

    @Override
    public void docdecl(String text) throws IOException, IllegalArgumentException, IllegalStateException {
    }

    @Override
    public void ignorableWhitespace(String text) throws IOException, IllegalArgumentException, IllegalStateException {
    }

    @Override
    public void flush() throws IOException {
    }

    private void flushText() {
        if (this.mCurrentText == null) {
            return;
        }
        String text = this.mCurrentText.toString();
        this.mCurrentText = null;
        if (ResXmlPullSerializer.isIndent(text)) {
            return;
        }
        ResXmlElement element = this.getCurrentElement();
        element.newText().setText(text);
    }

    private void appendText(String text) {
        if (text == null) {
            return;
        }
        StringBuilder builder = this.mCurrentText;
        if (builder == null) {
            this.mCurrentText = builder = new StringBuilder();
        }
        builder.append(text);
    }

    private static boolean isIndent(String text) {
        if (text.length() == 0) {
            return true;
        }
        char[] chars = text.toCharArray();
        if (chars[0] != '\n') {
            return false;
        }
        for (int i = 1; i < chars.length; ++i) {
            if (chars[i] == ' ') continue;
            return false;
        }
        return true;
    }
}

