/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.chunk.xml.ResXmlChunkList;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.chunk.xml.ResXmlEndNamespace;
import com.reandroid.arsc.chunk.xml.ResXmlNamespace;
import com.reandroid.arsc.chunk.xml.ResXmlStartNamespace;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.common.Namespace;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONException;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.IterableIterator;
import com.reandroid.utils.collection.Swappable;
import com.reandroid.xml.XMLUtil;
import java.util.Comparator;
import java.util.Iterator;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ResXmlStartNamespaceList
extends ResXmlChunkList<ResXmlStartNamespace>
implements JSONConvert<JSONArray> {
    private final BlockList<ResXmlEndNamespace> endNamespaceList;

    public ResXmlStartNamespaceList(BlockList<ResXmlEndNamespace> endNamespaceList) {
        this.endNamespaceList = endNamespaceList;
    }

    public ResXmlNamespace getForUri(String uri) {
        ResXmlNamespace result = null;
        Iterator<ResXmlStartNamespace> iterator = this.getVisibleNamespaces();
        while (iterator.hasNext()) {
            ResXmlNamespace namespace = iterator.next();
            if (!ObjectsUtil.equals(uri, namespace.getUri())) continue;
            if (result == null) {
                result = namespace;
                continue;
            }
            if (!Namespace.isValidPrefix(namespace.getPrefix())) continue;
            result = namespace;
        }
        return result;
    }

    public ResXmlNamespace getOrCreateForPrefix(String prefix) {
        if (StringsUtil.isBlank(prefix)) {
            return null;
        }
        ResXmlNamespace namespace = this.getForPrefix(prefix);
        if (namespace != null) {
            return namespace;
        }
        String uri = Namespace.PREFIX_ANDROID.equals(prefix) ? Namespace.URI_ANDROID : Namespace.URI_RES_AUTO;
        return this.getOrCreate(uri, prefix);
    }

    public ResXmlNamespace getForPrefix(String prefix) {
        ResXmlNamespace result = null;
        Iterator<ResXmlStartNamespace> iterator = this.getVisibleNamespaces();
        while (iterator.hasNext()) {
            ResXmlNamespace namespace = iterator.next();
            if (!ObjectsUtil.equals(prefix, namespace.getPrefix())) continue;
            if (result == null) {
                result = namespace;
                continue;
            }
            if (!Namespace.isValidUri(namespace.getUri())) continue;
            result = namespace;
        }
        return result;
    }

    public ResXmlStartNamespace getForUriReference(int reference) {
        if (reference != -1) {
            Iterator<ResXmlElement> iterator = this.element().getParentElementsWithSelf();
            while (iterator.hasNext()) {
                ResXmlStartNamespaceList list = iterator.next().getNamespaceList();
                ResXmlStartNamespace namespace = list.getLocalForUriReference(reference);
                if (namespace == null) continue;
                return namespace;
            }
        }
        return null;
    }

    private ResXmlStartNamespace getLocalForUriReference(int reference) {
        if (reference == -1) {
            return null;
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ResXmlStartNamespace namespace = (ResXmlStartNamespace)this.get(i);
            if (reference != namespace.getUriReference()) continue;
            return namespace;
        }
        return null;
    }

    public ResXmlStartNamespace getOrCreate(String uri, String prefix) {
        ResXmlStartNamespace namespace = this.get(uri, prefix);
        if (namespace == null) {
            namespace = this.element().getRootElement().getNamespaceList().createLocal(uri, prefix);
        }
        return namespace;
    }

    public ResXmlStartNamespace get(String uri, String prefix) {
        ResXmlStartNamespace result = null;
        Iterator<ResXmlElement> iterator = this.element().getDescendingParentsWithSelf();
        while (iterator.hasNext()) {
            ResXmlStartNamespaceList list = iterator.next().getNamespaceList();
            ResXmlStartNamespace namespace = list.getLocal(uri, prefix);
            if (namespace == null || !namespace.isBetterThan(result)) continue;
            result = namespace;
        }
        return result;
    }

    public Iterator<ResXmlStartNamespace> getVisibleNamespaces() {
        return new IterableIterator<ResXmlElement, ResXmlStartNamespace>(this.element().getDescendingParentsWithSelf()){

            @Override
            public Iterator<ResXmlStartNamespace> iterator(ResXmlElement element) {
                return element.getNamespaceList().iterator();
            }
        };
    }

    private ResXmlStartNamespace createLocal(String uri, String prefix) {
        if (uri == null) {
            return null;
        }
        if (prefix == null) {
            prefix = this.generateUniquePrefix();
        }
        return this.createNext(uri, prefix);
    }

    private ResXmlStartNamespace getLocal(String uri, String prefix) {
        if (uri == null) {
            return null;
        }
        ResXmlStartNamespace result = null;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ResXmlStartNamespace namespace = (ResXmlStartNamespace)this.get(i);
            if (!uri.equals(namespace.getUri()) || !ObjectsUtil.equals(prefix, namespace.getPrefix()) || result != null && namespace.getReferencedCount() <= result.getReferencedCount()) continue;
            result = namespace;
        }
        return result;
    }

    private String generateUniquePrefix() {
        int i;
        String name = "ns";
        int maxTrials = 10000;
        for (i = 1; i < maxTrials; ++i) {
            String prefix = name + i;
            if (this.containsPrefixEveryWhere(prefix)) continue;
            return prefix;
        }
        throw new IllegalArgumentException("Failed to generate unique prefix, trials = " + i);
    }

    private boolean containsPrefixEveryWhere(String prefix) {
        Iterator iterator = this.document().recursiveElements();
        while (iterator.hasNext()) {
            ResXmlStartNamespaceList list = ((ResXmlElement)iterator.next()).getNamespaceList();
            if (!list.containsPrefix(prefix)) continue;
            return true;
        }
        return false;
    }

    private boolean containsPrefix(String prefix) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ResXmlStartNamespace namespace = (ResXmlStartNamespace)this.get(i);
            if (!prefix.equals(namespace.getPrefix())) continue;
            return true;
        }
        return false;
    }

    public Iterator<ResXmlNamespace> getNamespaces() {
        return (Iterator)ObjectsUtil.cast(this.iterator());
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    private void ensureUniqueUri() {
        ResXmlDocument document = this.document();
        if (document != null) {
            Iterator iterator = document.recursiveElements();
            while (iterator.hasNext()) {
                ((ResXmlElement)iterator.next()).getNamespaceList().ensureUniqueUriLocal();
            }
        }
    }

    private void ensureUniqueUriLocal() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ((ResXmlStartNamespace)this.get(i)).ensureUniqueUri();
        }
    }

    public ResXmlStartNamespace createNext(String uri, String prefix) {
        if (uri != null) {
            this.ensureUniqueUri();
        }
        ResXmlStartNamespace startNamespace = this.createNext();
        if (uri != null || prefix != null) {
            startNamespace.set(uri, prefix);
        }
        return startNamespace;
    }

    @Override
    public ResXmlStartNamespace createNext() {
        ResXmlEndNamespace endNamespace = new ResXmlEndNamespace();
        ResXmlStartNamespace startNamespace = new ResXmlStartNamespace(endNamespace);
        endNamespace.setStart(startNamespace);
        this.add(startNamespace);
        this.endNamespaceList.add(endNamespace);
        return startNamespace;
    }

    @Override
    public boolean sort(Comparator<? super ResXmlStartNamespace> comparator) {
        if (super.sort(comparator)) {
            this.endNamespaceList.sort(CompareUtil.getComparableComparator());
            return true;
        }
        return false;
    }

    @Override
    public boolean sort(Comparator<? super ResXmlStartNamespace> comparator, Swappable swappable) {
        if (super.sort(comparator, swappable)) {
            this.endNamespaceList.sort(CompareUtil.getComparableComparator());
            return true;
        }
        return false;
    }

    @Override
    public void onPreRemove(ResXmlStartNamespace startNamespace) {
        super.onPreRemove(startNamespace);
        this.endNamespaceList.remove(startNamespace.getEnd());
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
        this.clearUndefined();
    }

    public void clearUndefined() {
        this.removeIf(ResXmlStartNamespace::isUndefined);
    }

    public void clearUnused() {
        this.removeIf(ResXmlStartNamespace::isUnused);
    }

    @Override
    public JSONArray toJson() {
        return ResXmlStartNamespaceList.toJsonArray(this);
    }

    @Override
    public void fromJson(JSONArray jsonArray) {
        if (jsonArray != null) {
            int size = jsonArray.length();
            for (int i = 0; i < size; ++i) {
                Object obj = jsonArray.get(i);
                if (obj == null) continue;
                if (!(obj instanceof JSONObject)) {
                    throw new JSONException("Expecting JSONObject but found: " + obj.getClass());
                }
                this.createNext().fromJson((JSONObject)obj);
            }
        }
    }

    private ResXmlDocument document() {
        return this.element().getParentDocument();
    }

    private ResXmlElement element() {
        return this.getParentInstance(ResXmlElement.class);
    }

    private void ensureNamespace(String uri, String prefix, int lineNumber) {
        ResXmlStartNamespace namespace = this.get(uri, prefix);
        if (namespace == null) {
            namespace = this.createNext(uri, prefix);
            namespace.setLineNumber(lineNumber);
        }
    }

    public void merge(ResXmlStartNamespaceList namespaceList) {
        if (namespaceList != this) {
            int size = namespaceList.size();
            for (int i = 0; i < size; ++i) {
                this.createNext().merge((ResXmlStartNamespace)namespaceList.get(i));
            }
        }
    }

    public void parse(XmlPullParser parser) throws XmlPullParserException {
        int i;
        int count = parser.getNamespaceCount(parser.getDepth());
        for (i = 0; i < count; ++i) {
            this.ensureNamespace(parser.getNamespaceUri(i), parser.getNamespacePrefix(i), parser.getLineNumber());
        }
        count = parser.getAttributeCount();
        for (i = 0; i < count; ++i) {
            String name = parser.getAttributeName(i);
            String prefix = XMLUtil.splitPrefix(name);
            if (prefix == null) continue;
            name = XMLUtil.splitName(name);
            String value = parser.getAttributeValue(i);
            if (!Namespace.isValidNamespace(value, prefix)) continue;
            this.ensureNamespace(value, name, 0);
        }
    }
}

