/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.coder;

import com.reandroid.arsc.coder.Coder;
import com.reandroid.arsc.coder.ComplexUnit;
import com.reandroid.arsc.coder.ComplexUtil;
import com.reandroid.arsc.coder.EncodeResult;

public abstract class CoderComplexData
extends Coder {
    @Override
    public EncodeResult encode(String text) {
        ComplexUnit unit = this.parseUnit(text);
        if (unit == null) {
            return null;
        }
        String number = text.substring(0, text.length() - unit.getSymbol().length());
        Float floatValue = CoderComplexData.parseFloat(number);
        if (floatValue == null) {
            return null;
        }
        int value = ComplexUtil.encodeComplex(floatValue.floatValue(), unit);
        return new EncodeResult(unit.getValueType(), value);
    }

    @Override
    boolean canStartWith(char first) {
        return CoderComplexData.isNumberStart(first);
    }

    abstract ComplexUnit parseUnit(String var1);
}

