/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.coder;

import com.reandroid.arsc.coder.Coder;
import com.reandroid.arsc.coder.EncodeResult;
import com.reandroid.arsc.value.ValueType;

public class CoderFloat
extends Coder {
    public static final CoderFloat INS = new CoderFloat();

    @Override
    public EncodeResult encode(String text) {
        int i = text.indexOf(46);
        if (i <= 0) {
            return null;
        }
        Float value = CoderFloat.parseFloat(text);
        if (value == null) {
            return null;
        }
        return new EncodeResult(ValueType.FLOAT, Float.floatToIntBits(value.floatValue()));
    }

    @Override
    public String decode(int data) {
        return Float.toString(Float.intBitsToFloat(data));
    }

    @Override
    public ValueType getValueType() {
        return ValueType.FLOAT;
    }

    @Override
    boolean canStartWith(char first) {
        return CoderFloat.isNumberStart(first);
    }
}

