/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.coder.xml;

import com.reandroid.arsc.coder.xml.XmlStringDecoder;
import com.reandroid.arsc.item.StringItem;
import com.reandroid.xml.StyleDocument;
import com.reandroid.xml.StyleText;
import com.reandroid.xml.XMLUtil;
import java.io.IOException;
import java.util.Iterator;
import org.xmlpull.v1.XmlSerializer;

public class AaptXmlStringDecoder
implements XmlStringDecoder {
    @Override
    public void serializeText(StringItem stringItem, XmlSerializer serializer) throws IOException {
        StyleDocument styleDocument = stringItem.getStyleDocument();
        if (styleDocument != null) {
            AaptXmlStringDecoder.escapeStyleDocument(styleDocument);
            styleDocument.serialize(serializer);
        } else {
            serializer.text(this.decodePlainToAaptString(stringItem.getXml()));
        }
    }

    @Override
    public String decodeAttributeValue(StringItem stringItem) {
        return XMLUtil.escapeXmlChars(stringItem.getXml());
    }

    public static void escapeStyleDocument(StyleDocument styleDocument) {
        Iterator<StyleText> iterator = styleDocument.getStyleTexts();
        while (iterator.hasNext()) {
            StyleText styleText = iterator.next();
            styleText.setText(AaptXmlStringDecoder.escapeXmlValue(styleText.getText(false)));
        }
    }

    private String decodePlainToAaptString(String text) {
        return AaptXmlStringDecoder.escapeXmlValue(text);
    }

    public static String escapeXmlValue(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        char[] chars = str.toCharArray();
        StringBuilder out = new StringBuilder(str.length() + 10);
        switch (chars[0]) {
            case '#': 
            case '?': 
            case '@': {
                out.append('\\');
            }
        }
        boolean isInStyleTag = false;
        int startPos = 0;
        boolean enclose = false;
        boolean wasSpace = true;
        for (char c : chars) {
            if (isInStyleTag) {
                if (c == '>') {
                    isInStyleTag = false;
                    startPos = out.length() + 1;
                    enclose = false;
                }
            } else if (c == ' ') {
                if (wasSpace) {
                    enclose = true;
                }
                wasSpace = true;
            } else {
                wasSpace = false;
                switch (c) {
                    case '\"': 
                    case '\\': {
                        out.append('\\');
                        break;
                    }
                    case '\n': 
                    case '\'': {
                        enclose = true;
                        break;
                    }
                    case '<': {
                        isInStyleTag = true;
                        if (!enclose) break;
                        out.insert(startPos, '\"').append('\"');
                        break;
                    }
                }
            }
            out.append(c);
        }
        if (enclose || wasSpace) {
            out.insert(startPos, '\"').append('\"');
        }
        return out.toString();
    }
}

