/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.container;

import com.reandroid.arsc.array.TypeBlockArray;
import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockContainer;
import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.SpecBlock;
import com.reandroid.arsc.chunk.TypeBlock;
import com.reandroid.arsc.header.HeaderBlock;
import com.reandroid.arsc.header.InfoHeader;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.TypeString;
import com.reandroid.arsc.model.ResourceEntry;
import com.reandroid.arsc.pool.SpecStringPool;
import com.reandroid.arsc.pool.TableStringPool;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResConfig;
import com.reandroid.arsc.value.ValueItem;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.MergingIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Predicate;
import org.xmlpull.v1.XmlSerializer;

public class SpecTypePair
extends BlockContainer<Block>
implements Iterable<TypeBlock>,
JSONConvert<JSONObject>,
Comparable<SpecTypePair> {
    private final Block[] mChildes;
    private final SpecBlock mSpecBlock;
    private final TypeBlockArray mTypeBlockArray;
    public static final String NAME_types = "types";
    public static final String NAME_sparse_types = "sparse_types";

    public SpecTypePair(SpecBlock specBlock, TypeBlockArray typeBlockArray) {
        this.mSpecBlock = specBlock;
        this.mTypeBlockArray = typeBlockArray;
        this.mChildes = new Block[]{specBlock, typeBlockArray};
        specBlock.setIndex(0);
        typeBlockArray.setIndex(1);
        specBlock.setParent(this);
        typeBlockArray.setParent(this);
    }

    public SpecTypePair() {
        this(new SpecBlock(), new TypeBlockArray());
    }

    public Iterator<ValueItem> allValues() {
        return new MergingIterator<ValueItem>(new ComputeIterator<TypeBlock, Iterator>(this.getTypeBlocks(), TypeBlock::allValues));
    }

    public void trimConfigSizes(int resConfigSize) {
        Iterator<TypeBlock> iterator = this.getTypeBlocks();
        while (iterator.hasNext()) {
            ResConfig resConfig = iterator.next().getResConfig();
            resConfig.trimToSize(resConfigSize);
        }
    }

    public boolean isTypeAttr() {
        TypeString typeString = this.getTypeString();
        if (typeString != null) {
            return typeString.isTypeAttr();
        }
        return false;
    }

    public boolean isTypeId() {
        TypeString typeString = this.getTypeString();
        if (typeString != null) {
            return typeString.isTypeId();
        }
        return false;
    }

    public ResourceEntry getResource(int entryId) {
        if (entryId < 0 || entryId > this.getHighestEntryId()) {
            return null;
        }
        PackageBlock packageBlock = this.getPackageBlock();
        if (packageBlock == null) {
            return null;
        }
        int resourceId = packageBlock.getId() << 24;
        resourceId |= this.getId() << 16;
        return new ResourceEntry(packageBlock, resourceId |= entryId);
    }

    public ResourceEntry getResource(String name) {
        PackageBlock packageBlock = this.getPackageBlock();
        if (packageBlock == null) {
            return null;
        }
        SpecStringPool specStringPool = packageBlock.getSpecStringPool();
        int resourceId = specStringPool.resolveResourceId(this, name);
        if (resourceId == 0) {
            return null;
        }
        return new ResourceEntry(packageBlock, resourceId);
    }

    public Iterator<ResourceEntry> getResources() {
        final PackageBlock packageBlock = this.getPackageBlock();
        if (packageBlock == null) {
            return EmptyIterator.of();
        }
        final int end = this.getHighestEntryId();
        final int id = packageBlock.getId() << 24 | this.getId() << 16;
        return new Iterator<ResourceEntry>(){
            private int mIndex;

            @Override
            public boolean hasNext() {
                return this.mIndex <= end;
            }

            @Override
            public ResourceEntry next() {
                if (this.mIndex > end) {
                    throw new NoSuchElementException();
                }
                int resourceId = id | this.mIndex;
                ++this.mIndex;
                return new ResourceEntry(packageBlock, resourceId);
            }
        };
    }

    public Iterator<Entry> getEntries(int entryId) {
        return this.getEntries(entryId, false);
    }

    public Iterator<Entry> getEntries(int entryId, boolean skipNull) {
        return new ComputeIterator<TypeBlock, Entry>(this.getTypeBlocks(), typeBlock -> {
            Entry entry = typeBlock.getEntry(entryId);
            if (entry == null || skipNull && entry.isNull()) {
                return null;
            }
            return entry;
        });
    }

    public Iterator<TypeBlock> getTypeBlocks() {
        return this.getTypeBlockArray().iterator();
    }

    public Iterator<TypeBlock> getTypeBlocks(Predicate<TypeBlock> filter) {
        return this.getTypeBlockArray().iterator(filter);
    }

    public Iterator<TypeBlock> getTypeBlocks(ResConfig resConfig) {
        return this.getTypeBlockArray().iterator(resConfig);
    }

    public Boolean hasComplexEntry() {
        return this.getTypeBlockArray().hasComplexEntry();
    }

    public void linkTableStringsInternal(TableStringPool tableStringPool) {
        for (TypeBlock typeBlock : this) {
            typeBlock.getEntryArray().linkTableStringsInternal(tableStringPool);
        }
    }

    public void linkSpecStringsInternal(SpecStringPool specStringPool) {
        for (TypeBlock typeBlock : this) {
            typeBlock.getEntryArray().linkSpecStringsInternal(specStringPool);
        }
    }

    public void destroy() {
        this.getSpecBlock().destroy();
        this.getTypeBlockArray().destroy();
    }

    public Entry getAnyEntry(short entryId) {
        Entry result = null;
        Iterator iterator = this.getTypeBlockArray().iterator();
        while (iterator.hasNext()) {
            TypeBlock typeBlock = (TypeBlock)iterator.next();
            Entry entry = typeBlock.getEntry(entryId);
            if (entry == null) continue;
            if (!entry.isNull()) {
                return entry;
            }
            if (result != null) continue;
            result = entry;
        }
        return result;
    }

    public Entry getAnyEntry(String name) {
        Iterator iterator = this.getTypeBlockArray().iterator();
        while (iterator.hasNext()) {
            Entry entry;
            TypeBlock typeBlock = (TypeBlock)iterator.next();
            if (typeBlock == null || (entry = typeBlock.getEntry(name)) == null) continue;
            return entry;
        }
        return null;
    }

    public Entry getEntry(ResConfig resConfig, String entryName) {
        return this.getTypeBlockArray().getEntry(resConfig, entryName);
    }

    public Entry getEntry(ResConfig resConfig, int entryId) {
        return this.getTypeBlockArray().getEntry(resConfig, entryId);
    }

    public void sortTypes() {
        this.getTypeBlockArray().sort();
    }

    public boolean removeNullEntries(int startId) {
        startId = 0xFFFF & startId;
        boolean removed = this.getTypeBlockArray().removeNullEntries(startId);
        if (!removed) {
            return false;
        }
        this.getSpecBlock().setEntryCount(startId);
        return true;
    }

    public void removeEmptyTypeBlocks() {
        this.getTypeBlockArray().removeEmptyBlocks();
    }

    public boolean isEmpty() {
        return this.getTypeBlockArray().isEmpty();
    }

    public int countTypeBlocks() {
        return this.getTypeBlockArray().size();
    }

    public Entry getOrCreateEntry(short entryId, String qualifiers) {
        return this.getTypeBlockArray().getOrCreateEntry(entryId, qualifiers);
    }

    public Entry getOrCreateEntry(short entryId, ResConfig resConfig) {
        return this.getTypeBlockArray().getOrCreateEntry(entryId, resConfig);
    }

    public Entry getEntry(short entryId, String qualifiers) {
        return this.getTypeBlockArray().getEntry(entryId, qualifiers);
    }

    public TypeBlock getOrCreateTypeBlock(String qualifiers) {
        return this.getTypeBlockArray().getOrCreate(qualifiers);
    }

    public TypeBlock getOrCreateTypeBlock(ResConfig resConfig) {
        return this.getTypeBlockArray().getOrCreate(resConfig);
    }

    public TypeBlock getTypeBlock(String qualifiers) {
        return this.getTypeBlockArray().getTypeBlock(qualifiers);
    }

    public TypeBlock getTypeBlock(ResConfig resConfig) {
        return this.getTypeBlockArray().getTypeBlock(resConfig);
    }

    public Set<ResConfig> listResConfig() {
        return this.mTypeBlockArray.listResConfig();
    }

    public Iterator<ResConfig> getResConfigs() {
        return this.mTypeBlockArray.getResConfigs();
    }

    public Iterator<TypeBlock> iteratorNonEmpty() {
        return this.mTypeBlockArray.iteratorNonEmpty();
    }

    public boolean hasDuplicateResConfig(boolean ignoreEmpty) {
        return this.mTypeBlockArray.hasDuplicateResConfig(ignoreEmpty);
    }

    public byte getTypeId() {
        return this.mSpecBlock.getTypeId();
    }

    public int getId() {
        return this.mSpecBlock.getId();
    }

    public void setTypeId(byte id) {
        this.mSpecBlock.setTypeId(id);
        this.mTypeBlockArray.setTypeId(id);
    }

    public String getTypeName() {
        TypeString typeString = this.getTypeString();
        if (typeString != null) {
            return typeString.get();
        }
        return null;
    }

    public boolean isEqualTypeName(String typeName) {
        return TypeBlock.isEqualTypeName(this.getTypeName(), typeName);
    }

    public SpecBlock getSpecBlock() {
        return this.mSpecBlock;
    }

    public TypeBlockArray getTypeBlockArray() {
        return this.mTypeBlockArray;
    }

    public PackageBlock getPackageBlock() {
        return this.getParent(PackageBlock.class);
    }

    public List<Entry> listEntries(int entryId) {
        ArrayCollection<Entry> results = new ArrayCollection<Entry>();
        Iterator itr = this.mTypeBlockArray.iterator(true);
        while (itr.hasNext()) {
            TypeBlock typeBlock = (TypeBlock)itr.next();
            Entry entry = typeBlock.getEntry(entryId);
            if (entry == null || entry.isNull()) continue;
            results.add(entry);
        }
        return results;
    }

    public List<Entry> listEntries(String entryName) {
        ArrayCollection<Entry> results = new ArrayCollection<Entry>();
        Iterator itr = this.mTypeBlockArray.iterator(true);
        while (itr.hasNext()) {
            TypeBlock typeBlock = (TypeBlock)itr.next();
            Entry entry = typeBlock.getEntry(entryName);
            if (entry == null) continue;
            results.add(entry);
        }
        return results;
    }

    @Override
    public Iterator<TypeBlock> iterator() {
        return this.getTypeBlockArray().iterator();
    }

    @Override
    protected void onRefreshed() {
    }

    @Override
    public int getChildesCount() {
        return this.mChildes.length;
    }

    public Block[] getChildes() {
        return this.mChildes;
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        InfoHeader headerBlock = reader.readHeaderBlock();
        if (headerBlock == null) {
            return;
        }
        ChunkType chunkType = headerBlock.getChunkType();
        if (chunkType == ChunkType.TYPE) {
            this.readTypeBlock(reader);
            return;
        }
        if (chunkType != ChunkType.SPEC) {
            this.readUnexpectedNonSpecBlock(reader, headerBlock);
        }
        this.mSpecBlock.readBytes(reader);
    }

    private void readTypeBlock(BlockReader reader) throws IOException {
        TypeBlock typeBlock = (TypeBlock)this.mTypeBlockArray.createNext();
        typeBlock.readBytes(reader);
    }

    private void readUnexpectedNonSpecBlock(BlockReader reader, HeaderBlock headerBlock) throws IOException {
        throw new IOException("Unexpected block: " + headerBlock.toString() + ", Should be: " + (Object)((Object)ChunkType.SPEC));
    }

    public int getHighestEntryCount() {
        return this.getTypeBlockArray().getHighestEntryCount();
    }

    public int getHighestEntryId() {
        return this.getTypeBlockArray().getHighestEntryId();
    }

    public TypeString getTypeString() {
        PackageBlock packageBlock = this.getPackageBlock();
        if (packageBlock != null) {
            return packageBlock.getTypeStringPool().getById(this.getId());
        }
        return null;
    }

    public void serializePublicXml(XmlSerializer serializer) throws IOException {
        ResourceEntry last = this.getResource(this.getHighestEntryId());
        boolean lastWritten = false;
        if (last != null) {
            lastWritten = last.serializePublicXml(serializer);
        }
        Iterator<ResourceEntry> itr = this.getResources();
        while (itr.hasNext()) {
            ResourceEntry resourceEntry = itr.next();
            if (lastWritten && resourceEntry.equals(last)) continue;
            resourceEntry.serializePublicXml(serializer);
        }
    }

    @Override
    public JSONObject toJson() {
        return this.toJson(false);
    }

    @Override
    public void fromJson(JSONObject json) {
        this.getSpecBlock().fromJson(json.getJSONObject("spec"));
        this.getTypeBlockArray().fromJson(json.optJSONArray(NAME_types));
    }

    public JSONObject toJson(boolean specOnly) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("spec", this.getSpecBlock().toJson());
        if (!specOnly) {
            jsonObject.put(NAME_types, this.getTypeBlockArray().toJson());
        }
        return jsonObject;
    }

    public void merge(SpecTypePair typePair) {
        if (typePair == null || typePair == this) {
            return;
        }
        if (this.getTypeId() != typePair.getTypeId()) {
            throw new IllegalArgumentException("Can not merge different id types: " + this.getTypeId() + "!=" + typePair.getTypeId());
        }
        this.getSpecBlock().merge(typePair.getSpecBlock());
        this.getTypeBlockArray().merge(typePair.getTypeBlockArray());
    }

    @Override
    public int compareTo(SpecTypePair specTypePair) {
        return Integer.compare(this.getId(), specTypePair.getId());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(HexUtil.toHex2(this.getTypeId()));
        builder.append(" (");
        TypeString ts = this.getTypeString();
        if (ts != null) {
            builder.append(ts.get());
        } else {
            builder.append("null");
        }
        builder.append(") config count=");
        builder.append(this.getTypeBlockArray().size());
        return builder.toString();
    }
}

