/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.header;

import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.header.HeaderBlock;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.ByteItem;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.ShortItem;
import java.io.IOException;

public class SpecHeader
extends HeaderBlock {
    private final ByteItem id = new ByteItem();
    private final IntegerItem entryCount;

    public SpecHeader() {
        super(ChunkType.SPEC.ID);
        ByteItem res0 = new ByteItem();
        ShortItem res1 = new ShortItem();
        this.entryCount = new IntegerItem();
        this.addChild(this.id);
        this.addChild(res0);
        this.addChild(res1);
        this.addChild(this.entryCount);
    }

    public ByteItem getId() {
        return this.id;
    }

    public IntegerItem getEntryCount() {
        return this.entryCount;
    }

    @Override
    public String toString() {
        if (this.getChunkType() != ChunkType.SPEC) {
            return super.toString();
        }
        return this.getClass().getSimpleName() + " {id=" + this.getId().toHex() + ", entryCount=" + this.getEntryCount() + '}';
    }

    public static SpecHeader read(BlockReader reader) throws IOException {
        SpecHeader specHeader = new SpecHeader();
        if (reader.available() < specHeader.countBytes()) {
            throw new IOException("Too few bytes to read spec header, available = " + reader.available());
        }
        int pos = reader.getPosition();
        specHeader.readBytes(reader);
        reader.seek(pos);
        return specHeader;
    }
}

