/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.io;

import com.reandroid.arsc.header.InfoHeader;
import com.reandroid.arsc.header.SpecHeader;
import com.reandroid.arsc.header.TypeHeader;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BlockReader
extends InputStream {
    private final Object mLock = new Object();
    private byte[] BUFFER;
    private final int mStart;
    private final int mLength;
    private int mPosition;
    private boolean mIsClosed;
    private int mMark;

    public BlockReader(byte[] buffer, int start, int length) {
        this.BUFFER = buffer;
        this.mStart = start;
        this.mLength = length;
        this.mPosition = 0;
    }

    public BlockReader(byte[] buffer) {
        this(buffer, 0, buffer.length);
    }

    public BlockReader(InputStream in) throws IOException {
        this(BlockReader.loadBuffer(in));
    }

    public BlockReader(InputStream in, int length) throws IOException {
        this(BlockReader.loadBuffer(in, length));
    }

    public BlockReader(File file) throws IOException {
        this(BlockReader.loadBuffer(file));
    }

    public int readUnsignedShort() throws IOException {
        return 0xFFFF & this.readShort();
    }

    public short readShort() throws IOException {
        int pos = this.getPosition();
        byte[] bts = new byte[2];
        this.readFully(bts);
        this.seek(pos);
        return this.toShort(bts);
    }

    public int readInteger() throws IOException {
        int pos = this.getPosition();
        byte[] bytes = new byte[4];
        this.readFully(bytes);
        this.seek(pos);
        return this.toInt(bytes);
    }

    @Deprecated
    public SpecHeader readSpecHeader() throws IOException {
        return SpecHeader.read(this);
    }

    @Deprecated
    public TypeHeader readTypeHeader() throws IOException {
        return TypeHeader.read(this);
    }

    public InfoHeader readHeaderBlock() throws IOException {
        return InfoHeader.read(this);
    }

    private int toInt(byte[] bytes) {
        return bytes[0] & 0xFF | (bytes[1] & 0xFF) << 8 | (bytes[2] & 0xFF) << 16 | (bytes[3] & 0xFF) << 24;
    }

    private short toShort(byte[] bytes) {
        return (short)(bytes[0] & 0xFF | (bytes[1] & 0xFF) << 8);
    }

    public byte[] getBuffer() {
        return this.BUFFER;
    }

    public byte[] getBytes() {
        int len = this.length();
        if (this.BUFFER.length == len) {
            return this.BUFFER;
        }
        byte[] bytes = new byte[len];
        if (len == 0) {
            return bytes;
        }
        System.arraycopy(this.BUFFER, this.mStart, bytes, 0, len);
        return bytes;
    }

    public BlockReader create(int len) {
        return this.create(this.getPosition(), len);
    }

    public BlockReader create(int start, int len) {
        int max = start + len;
        if (len < 0 || max > this.mLength) {
            len = this.mLength - start;
        }
        return new BlockReader(this.BUFFER, start += this.mStart, len);
    }

    public boolean isAvailable() {
        if (this.mIsClosed) {
            return false;
        }
        return this.available() > 0;
    }

    public void offset(int off) {
        int pos = this.getPosition() + off;
        this.seek(pos);
    }

    public void seek(int position) {
        if (position < 0) {
            position = 0;
        } else if (position > this.length()) {
            position = this.length();
        }
        this.setPosition(position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPosition(int position) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPosition = position;
        }
    }

    public int length() {
        return this.mLength;
    }

    public byte[] readBytes(int length) throws IOException {
        byte[] result = new byte[length];
        if (length == 0) {
            return result;
        }
        int readLength = this.read(result);
        if (readLength < 0) {
            throw new EOFException("Finished reading: " + this.mPosition);
        }
        if (length == readLength) {
            return result;
        }
        byte[] bytes = new byte[readLength];
        System.arraycopy(result, 0, bytes, 0, readLength);
        return bytes;
    }

    public int readFully(byte[] bytes) throws IOException {
        return this.readFully(bytes, 0, bytes.length);
    }

    public int readFully(byte[] bytes, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        return this.readFully(bytes, 0, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readFully(byte[] bytes, int start, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        if (this.mIsClosed) {
            throw new IOException("Stream is closed");
        }
        if (this.mPosition >= this.mLength) {
            throw new EOFException("Finished reading: " + this.mPosition);
        }
        if (length > bytes.length) {
            length = bytes.length;
        }
        Object object = this.mLock;
        synchronized (object) {
            int i;
            int actualPosition = this.mStart + this.mPosition;
            for (i = 0; i < length; ++i) {
                bytes[start + i] = this.BUFFER[actualPosition + i];
                ++this.mPosition;
                if (this.mPosition < this.mLength) continue;
                ++i;
                break;
            }
            return i;
        }
    }

    public int getPosition() {
        return this.mPosition;
    }

    public int getActualPosition() {
        return this.mStart + this.mPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        int i;
        if (this.mIsClosed) {
            throw new IOException("Stream is closed");
        }
        if ((i = this.mPosition++) >= this.mLength) {
            throw new EOFException("Finished reading: " + i);
        }
        Object object = this.mLock;
        synchronized (object) {
            int actPos = this.mStart + i;
            int val = this.BUFFER[actPos] & 0xFF;
            return val;
        }
    }

    @Override
    public void mark(int pos) {
        this.mMark = pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int available() {
        return this.mLength - this.mPosition;
    }

    @Override
    public void reset() throws IOException {
        if (this.mIsClosed) {
            throw new IOException("Can not reset stream is closed");
        }
        this.mPosition = this.mMark;
    }

    @Override
    public void close() {
        this.mIsClosed = true;
        this.BUFFER = null;
        this.mMark = 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append(": ");
        if (this.mIsClosed) {
            builder.append("Closed");
        } else {
            int av = this.available();
            if (av == 0) {
                builder.append("Finished: ");
                builder.append(this.getPosition());
            } else {
                if (this.mStart > 0) {
                    builder.append("START=");
                    builder.append(this.mStart);
                    builder.append(", ACTUAL=");
                    builder.append(this.getActualPosition());
                    builder.append(", ");
                }
                builder.append("POS=");
                builder.append(this.getPosition());
                builder.append(", available=");
                builder.append(av);
            }
        }
        return builder.toString();
    }

    private static byte[] loadBuffer(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        byte[] result = BlockReader.loadBuffer(in);
        in.close();
        return result;
    }

    private static byte[] loadBuffer(InputStream in) throws IOException {
        int len;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buff = new byte[40960];
        while ((len = in.read(buff)) > 0) {
            outputStream.write(buff, 0, len);
        }
        if (in instanceof FileInputStream) {
            in.close();
        }
        outputStream.close();
        return outputStream.toByteArray();
    }

    private static byte[] loadBuffer(InputStream in, int length) throws IOException {
        byte[] buff = new byte[length];
        if (length == 0) {
            return buff;
        }
        int readLength = in.read(buff, 0, length);
        if (readLength < length) {
            throw new IOException("Read length is less than expected: length=" + length + ", read=" + readLength);
        }
        return buff;
    }

    public static InfoHeader readHeaderBlock(File file) throws IOException {
        return InfoHeader.readHeaderBlock(file);
    }

    public static InfoHeader readHeaderBlock(InputStream inputStream) throws IOException {
        return InfoHeader.readHeaderBlock(inputStream);
    }

    public static InfoHeader readHeaderBlock(byte[] bytes) throws IOException {
        return InfoHeader.readHeaderBlock(bytes);
    }
}

