/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.item;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.item.StringItem;
import com.reandroid.arsc.item.StyleItem;
import com.reandroid.arsc.value.Entry;
import com.reandroid.utils.CompareUtil;
import java.util.Iterator;
import java.util.function.Predicate;

public class SpecString
extends StringItem {
    public SpecString(boolean utf8) {
        super(utf8);
    }

    public int resolveResourceId(String typeName) {
        Iterator<Entry> itr = this.getEntries(typeName);
        if (itr.hasNext()) {
            return itr.next().getResourceId();
        }
        return 0;
    }

    public Iterator<Entry> getEntries(Predicate<Entry> filter) {
        return this.getUsers(Entry.class, filter);
    }

    public Iterator<Entry> getEntries(final int typeId) {
        return this.getUsers(Entry.class, new Predicate<Entry>(){

            @Override
            public boolean test(Entry item) {
                return typeId == item.getTypeId();
            }
        });
    }

    public Iterator<Entry> getEntries(final String typeName) {
        return this.getUsers(Entry.class, new Predicate<Entry>(){

            @Override
            public boolean test(Entry item) {
                return typeName == null || typeName.equals(item.getTypeName());
            }
        });
    }

    public Iterator<Entry> getEntries(final Block parentContext) {
        return this.getUsers(Entry.class, new Predicate<Entry>(){

            @Override
            public boolean test(Entry item) {
                return item.getParentInstance(parentContext.getClass()) == parentContext;
            }
        });
    }

    @Override
    public StyleItem getOrCreateStyle() {
        return null;
    }

    @Override
    public int compareStringValue(StringItem stringItem) {
        if (stringItem == null) {
            return -1;
        }
        if (stringItem == this) {
            return 0;
        }
        return CompareUtil.compare(this.get(), stringItem.get());
    }
}

