/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.item;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.coder.ThreeByteCharsetDecoder;
import com.reandroid.arsc.coder.XmlSanitizer;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.ReferenceItem;
import com.reandroid.arsc.item.ShortItem;
import com.reandroid.arsc.item.StringBlock;
import com.reandroid.arsc.item.StyleItem;
import com.reandroid.arsc.item.WeakStringReference;
import com.reandroid.arsc.list.StringItemList;
import com.reandroid.arsc.pool.StringPool;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.ObjectsStore;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.xml.StyleDocument;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.function.Predicate;
import org.xmlpull.v1.XmlSerializer;

public class StringItem
extends StringBlock
implements JSONConvert<JSONObject>,
Comparable<StringItem> {
    private boolean mUtf8;
    private Object mReferencedList;
    private StyleItem mStyleItem;
    private static final CharsetDecoder UTF16LE_DECODER = StandardCharsets.UTF_16LE.newDecoder();
    private static final CharsetDecoder DECODER_3B = ThreeByteCharsetDecoder.INSTANCE;
    public static final String NAME_string = ObjectsUtil.of("string");
    public static final String NAME_style = ObjectsUtil.of("style");

    public StringItem(boolean utf8) {
        this.mUtf8 = utf8;
    }

    public StyleDocument getStyleDocument() {
        if (this.hasStyle()) {
            return this.getStyle().build(this.get());
        }
        return null;
    }

    public <T extends Block> Iterator<T> getUsers(Class<T> parentClass) {
        return this.getUsers(parentClass, null);
    }

    public <T extends Block> Iterator<T> getUsers(Class<T> parentClass, Predicate<T> resultFilter) {
        return ComputeIterator.of(this.getReferences(), referenceItem -> {
            Object result = referenceItem.getReferredParent(parentClass);
            if (result == null || resultFilter != null && !resultFilter.test(result)) {
                result = null;
            }
            return result;
        });
    }

    public void removeReference(ReferenceItem reference) {
        this.mReferencedList = ObjectsStore.remove(this.mReferencedList, reference);
    }

    public void clearReferences() {
        this.mReferencedList = ObjectsStore.clear(this.mReferencedList);
    }

    public boolean hasReference() {
        this.ensureStringLinkUnlocked();
        return ObjectsStore.containsIf(this.mReferencedList, referenceItem -> !(referenceItem instanceof StyleItem.StyleIndexReference));
    }

    public int getReferencesSize() {
        return ObjectsStore.size(this.mReferencedList);
    }

    public Iterator<ReferenceItem> getReferences() {
        this.ensureStringLinkUnlocked();
        return ObjectsStore.iterator(this.mReferencedList);
    }

    void ensureStringLinkUnlocked() {
        StringPool stringPool = this.getParentInstance(StringPool.class);
        if (stringPool != null) {
            stringPool.ensureStringLinkUnlockedInternal();
        }
    }

    public void addReference(ReferenceItem reference) {
        if (reference != null) {
            this.mReferencedList = ObjectsStore.add(this.mReferencedList, reference);
            int index = this.getIndex();
            if (reference.get() != index) {
                reference.set(index);
            }
        }
    }

    private void reUpdateReferences(int newIndex) {
        Iterator iterator = ObjectsStore.clonedIterator(this.mReferencedList);
        while (iterator.hasNext()) {
            ReferenceItem reference = (ReferenceItem)iterator.next();
            reference.set(newIndex);
        }
    }

    public void onRemoved() {
        this.clearStyle();
        this.setParent(null);
    }

    @Override
    public void onIndexChanged(int oldIndex, int newIndex) {
        this.reUpdateReferences(newIndex);
    }

    @Override
    protected void onStringChanged(String old, String text) {
        super.onStringChanged(old, text);
        StringItemList stringPool = this.getParentInstance(StringItemList.class);
        if (stringPool != null) {
            stringPool.onStringChanged(old, this);
        }
    }

    public void serializeText(XmlSerializer serializer) throws IOException {
        this.serializeText(serializer, false);
    }

    public void serializeText(XmlSerializer serializer, boolean escapeValues) throws IOException {
        String text = this.get();
        if (text == null) {
            return;
        }
        text = escapeValues ? XmlSanitizer.escapeDecodedValue(text) : XmlSanitizer.escapeSpecialCharacter(text);
        serializer.text(text);
    }

    public void serializeAttribute(XmlSerializer serializer, String namespace, String name) throws IOException {
        String text = this.get();
        if (text == null) {
            text = "";
        }
        serializer.attribute(namespace, name, XmlSanitizer.escapeSpecialCharacter(text));
    }

    public String getHtml() {
        String text = this.get();
        if (text == null) {
            return null;
        }
        StyleItem styleItem = this.getStyle();
        if (styleItem == null) {
            return text;
        }
        return styleItem.applyStyle(text, false, false);
    }

    public String getXml() {
        return this.getXml(false);
    }

    public String getXml(boolean escapeXmlText) {
        String text = this.get();
        if (text == null) {
            return null;
        }
        StyleItem styleItem = this.getStyle();
        if (styleItem == null) {
            return text;
        }
        return styleItem.applyStyle(text, true, escapeXmlText);
    }

    @Override
    public void set(String str) {
        StyleItem style;
        boolean is_null = str == null;
        this.setNull(is_null);
        if (is_null && (style = this.getStyle()) != null) {
            style.clearStyle();
        }
        super.set(str);
    }

    public void set(StyleDocument document) {
        String old = this.getXml();
        if (this.countBytes() == 0) {
            old = null;
        }
        this.clearStyle();
        this.set(document.getStyledString(), false);
        if (document.hasElements()) {
            StyleItem styleItem = this.getOrCreateStyle();
            styleItem.parse(document);
        }
        String update = this.getXml();
        this.onStringChanged(old, update);
    }

    public void set(JSONObject jsonObject) {
        String old = this.getXml();
        if (this.countBytes() == 0) {
            old = null;
        }
        this.clearStyle();
        this.set(jsonObject.getString(NAME_string), false);
        JSONObject style = jsonObject.optJSONObject(NAME_style);
        if (style != null) {
            StyleItem styleItem = this.getOrCreateStyle();
            styleItem.fromJson(style);
        }
        String update = this.getXml();
        this.onStringChanged(old, update);
    }

    public boolean isUtf8() {
        return this.mUtf8;
    }

    public void setUtf8(boolean utf8) {
        if (utf8 != this.mUtf8) {
            this.mUtf8 = utf8;
            if (this.countBytes() != 0) {
                this.writeStringBytes(this.get());
            }
        }
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        if (reader.available() < 4) {
            return;
        }
        this.setBytesLength(this.calculateReadLength(reader), false);
        reader.readFully(this.getBytesInternal());
        this.onBytesChanged();
    }

    int calculateReadLength(BlockReader reader) throws IOException {
        if (reader.available() < 4) {
            return reader.available();
        }
        byte[] bytes = new byte[4];
        reader.readFully(bytes);
        reader.offset(-4);
        int[] lengthResult = this.isUtf8() ? StringItem.decodeUtf8StringByteLength(bytes) : StringItem.decodeUtf16StringByteLength(bytes);
        int add = this.isUtf8() ? 1 : 2;
        return lengthResult[0] + lengthResult[1] + add;
    }

    @Override
    protected String decodeString(byte[] bytes) {
        return this.decodeString(bytes, this.mUtf8);
    }

    @Override
    protected byte[] encodeString(String str) {
        if (this.mUtf8) {
            return StringItem.encodeUtf8ToBytes(str);
        }
        return StringItem.encodeUtf16ToBytes(str);
    }

    private String decodeString(byte[] encodedBytes, boolean isUtf8) {
        if (StringItem.isNullBytes(encodedBytes)) {
            if (encodedBytes == null || encodedBytes.length == 0) {
                return null;
            }
            return "";
        }
        int[] offLen = isUtf8 ? StringItem.decodeUtf8StringByteLength(encodedBytes) : StringItem.decodeUtf16StringByteLength(encodedBytes);
        CharsetDecoder charsetDecoder = isUtf8 ? UTF8_DECODER : UTF16LE_DECODER;
        try {
            ByteBuffer buffer = ByteBuffer.wrap(encodedBytes, offLen[0], offLen[1]);
            return charsetDecoder.decode(buffer).toString();
        }
        catch (CharacterCodingException ex) {
            if (isUtf8) {
                return this.tryThreeByteDecoder(encodedBytes, offLen[0], offLen[1]);
            }
            return new String(encodedBytes, offLen[0], offLen[1], StandardCharsets.UTF_16LE);
        }
    }

    private String tryThreeByteDecoder(byte[] bytes, int offset, int length) {
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes, offset, length);
            CharBuffer charBuffer = DECODER_3B.decode(byteBuffer);
            return charBuffer.toString();
        }
        catch (CharacterCodingException e) {
            return new String(bytes, offset, length, StandardCharsets.UTF_8);
        }
    }

    public boolean hasStyle() {
        StyleItem styleItem = this.getStyle();
        if (styleItem != null) {
            return styleItem.hasSpans();
        }
        return false;
    }

    public StyleItem getStyle() {
        return this.mStyleItem;
    }

    public StyleItem getOrCreateStyle() {
        StyleItem styleItem = this.getStyle();
        if (styleItem == null) {
            styleItem = (StyleItem)this.getParentInstance(StringPool.class).getStyleArray().createNext();
            this.linkStyleItemInternal(styleItem);
            styleItem = this.getStyle();
        }
        return styleItem;
    }

    public void linkStyleItemInternal(StyleItem styleItem) {
        if (styleItem == null) {
            throw new NullPointerException("Can not link null style item");
        }
        if (this.mStyleItem == styleItem) {
            return;
        }
        if (this.mStyleItem != null) {
            throw new IllegalStateException("Style item is already linked");
        }
        this.mStyleItem = styleItem;
        styleItem.setStringItemInternal(this);
    }

    public void unlinkStyleItemInternal(StyleItem styleItem) {
        if (this.mStyleItem == null) {
            return;
        }
        if (styleItem != this.mStyleItem) {
            throw new IllegalStateException("Wrong style item");
        }
        this.mStyleItem = null;
        styleItem.setStringItemInternal(null);
    }

    private void clearStyle() {
        StyleItem styleItem = this.getStyle();
        if (styleItem != null) {
            styleItem.clearStyle();
        }
    }

    public void transferReferences(StringItem source) {
        if (source == this || source == null || this.getParent() != source.getParent()) {
            return;
        }
        if (this.getIndex() < 0 || source.getIndex() < 0) {
            return;
        }
        Iterator iterator = ObjectsStore.clonedIterator(source.mReferencedList);
        while (iterator.hasNext()) {
            ReferenceItem reference = (ReferenceItem)iterator.next();
            if (!this.isTransferable(reference)) continue;
            source.removeReference(reference);
            this.addReference(reference);
        }
    }

    private boolean isTransferable(ReferenceItem referenceItem) {
        return !(referenceItem instanceof WeakStringReference);
    }

    public boolean merge(StringItem other) {
        if (!this.canMerge(other)) {
            return false;
        }
        this.clearStyle();
        this.set(other.get(), false);
        StyleItem otherStyle = other.getStyle();
        if (otherStyle != null && otherStyle.hasSpans()) {
            this.getOrCreateStyle().merge(otherStyle);
        }
        this.onStringChanged(null, this.getXml());
        return true;
    }

    boolean canMerge(StringItem stringItem) {
        if (stringItem == null || stringItem == this) {
            return false;
        }
        Block array1 = this.getParentInstance(StringItemList.class);
        Block array2 = stringItem.getParentInstance(StringItemList.class);
        return array1 != null && array2 != null && array1 != array2;
    }

    public boolean equalsValue(StyleDocument styled) {
        if (styled == null) {
            return this.isNull();
        }
        if (this.hasStyle()) {
            return styled.equals(this.getStyleDocument());
        }
        if (!styled.hasElements()) {
            return ObjectsUtil.equals(this.getXml(), styled.getXml());
        }
        return false;
    }

    public boolean equalsValue(String value) {
        if (value == null) {
            return this.isNull();
        }
        return value.equals(this.getXml());
    }

    @Override
    public int compareTo(StringItem stringItem) {
        if (stringItem == null) {
            return -1;
        }
        if (stringItem == this) {
            return 0;
        }
        int i = this.compareStringValue(stringItem);
        if (i != 0) {
            return i;
        }
        return this.compareReferences(stringItem);
    }

    public int compareStringValue(StringItem stringItem) {
        int i = -1 * CompareUtil.compare(this.hasStyle(), stringItem.hasStyle());
        if (i != 0) {
            return i;
        }
        return CompareUtil.compare(this.get(), stringItem.get());
    }

    public int compareReferences(StringItem stringItem) {
        return CompareUtil.compare(stringItem.getReferencesSize(), this.getReferencesSize());
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(NAME_string, this.get());
        if (this.hasStyle()) {
            jsonObject.put(NAME_style, this.getStyle().toJson());
        }
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        this.set(json);
    }

    @Override
    public String toString() {
        String xml = this.getXml();
        if (xml == null) {
            return this.getIndex() + ": NULL";
        }
        StringPool stringPool = this.getParentInstance(StringPool.class);
        if (stringPool != null && !stringPool.isStringLinkLocked()) {
            return this.getIndex() + ": USED BY=" + this.getReferencesSize() + "{" + xml + "}";
        }
        return this.getIndex() + ":" + xml;
    }

    private static int[] decodeUtf8StringByteLength(byte[] lengthBytes) {
        int length;
        int offset = 0;
        int val = lengthBytes[offset];
        offset = (val & 0x80) != 0 ? (offset += 2) : ++offset;
        val = lengthBytes[offset];
        ++offset;
        if ((val & 0x80) != 0) {
            int low = lengthBytes[offset] & 0xFF;
            length = val & 0x7F;
            length <<= 8;
            length += low;
        } else {
            length = val;
        }
        return new int[]{++offset, length};
    }

    private static int[] decodeUtf16StringByteLength(byte[] lengthBytes) {
        int val = (lengthBytes[1] & 0xFF) << 8 | lengthBytes[0] & 0xFF;
        if ((val & 0x8000) != 0) {
            int high = (lengthBytes[3] & 0xFF) << 8;
            int low = lengthBytes[2] & 0xFF;
            int len_value = ((val & Short.MAX_VALUE) << 16) + (high + low);
            return new int[]{4, len_value * 2};
        }
        return new int[]{2, val * 2};
    }

    static boolean isNullBytes(byte[] bytes) {
        if (bytes == null) {
            return true;
        }
        int length = bytes.length;
        if (length < 2) {
            return true;
        }
        for (int i = 2; i < length; ++i) {
            if (bytes[i] == 0) continue;
            return false;
        }
        return true;
    }

    private static byte[] encodeUtf8ToBytes(String str) {
        byte[] bytes;
        byte[] lenBytes = new byte[2];
        if (str != null) {
            bytes = str.getBytes(StandardCharsets.UTF_8);
            int strLen = bytes.length;
            if ((strLen & 0xFF80) != 0) {
                lenBytes = new byte[4];
                int l2 = strLen & 0xFF;
                int l1 = strLen - l2 >> 8;
                lenBytes[3] = (byte)l2;
                lenBytes[2] = (byte)(l1 | 0x80);
                strLen = str.length();
                l2 = strLen & 0xFF;
                l1 = strLen - l2 >> 8;
                lenBytes[1] = (byte)l2;
                lenBytes[0] = (byte)(l1 | 0x80);
            } else {
                lenBytes = new ShortItem((short)strLen).getBytesInternal();
                lenBytes[1] = lenBytes[0];
                lenBytes[0] = (byte)str.length();
            }
        } else {
            bytes = new byte[]{};
        }
        return StringItem.addBytes(lenBytes, bytes, new byte[1]);
    }

    private static byte[] encodeUtf16ToBytes(String str) {
        byte[] lenBytes;
        if (str == null) {
            return null;
        }
        byte[] bytes = StringItem.getUtf16Bytes(str);
        int strLen = bytes.length;
        if (((strLen /= 2) & Short.MIN_VALUE) != 0) {
            lenBytes = new byte[4];
            int low = strLen & 0xFF;
            int high = strLen - low & 0xFF00;
            int rem = strLen - low - high;
            lenBytes[3] = (byte)(high >> 8);
            lenBytes[2] = (byte)low;
            low = rem & 0xFF;
            high = (rem & 0xFF00) >> 8;
            lenBytes[1] = (byte)(high | 0x80);
            lenBytes[0] = (byte)low;
        } else {
            lenBytes = new ShortItem((short)strLen).getBytesInternal();
        }
        return StringItem.addBytes(lenBytes, bytes, new byte[2]);
    }

    static byte[] getUtf16Bytes(String str) {
        return str.getBytes(StandardCharsets.UTF_16LE);
    }

    private static byte[] addBytes(byte[] bytes1, byte[] bytes2, byte[] bytes3) {
        if (bytes1 == null && bytes2 == null && bytes3 == null) {
            return null;
        }
        int length = 0;
        if (bytes1 != null) {
            length = bytes1.length;
        }
        if (bytes2 != null) {
            length += bytes2.length;
        }
        if (bytes3 != null) {
            length += bytes3.length;
        }
        byte[] result = new byte[length];
        int start = 0;
        if (bytes1 != null) {
            start = bytes1.length;
            System.arraycopy(bytes1, 0, result, 0, start);
        }
        if (bytes2 != null) {
            System.arraycopy(bytes2, 0, result, start, bytes2.length);
            start += bytes2.length;
        }
        if (bytes3 != null) {
            System.arraycopy(bytes3, 0, result, start, bytes3.length);
        }
        return result;
    }
}

