/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.pool;

import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.chunk.xml.ResXmlIDMap;
import com.reandroid.arsc.item.ResXmlID;
import com.reandroid.arsc.item.ResXmlString;
import com.reandroid.arsc.list.ResXmlIDList;
import com.reandroid.arsc.list.StringItemList;
import com.reandroid.arsc.pool.StringPool;
import com.reandroid.utils.NumbersUtil;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.xml.StyleDocument;

public class ResXmlStringPool
extends StringPool<ResXmlString> {
    public ResXmlStringPool(boolean is_utf8) {
        super(is_utf8, false, ResXmlString::new);
    }

    @Override
    public ResXmlString getOrCreate(String str) {
        return this.getOrCreate(0, str);
    }

    @Override
    public ResXmlString getOrCreate(StyleDocument styleDocument) {
        String xml = styleDocument.getXml();
        if (!styleDocument.hasElements()) {
            return this.getOrCreate(0, xml);
        }
        ResXmlString xmlString = this.get(xml, resXmlString -> {
            if (!xml.equals(resXmlString.getXml()) || resXmlString.hasResourceId()) {
                return false;
            }
            return resXmlString.hasStyle();
        });
        if (xmlString == null) {
            xmlString = (ResXmlString)this.createNewString();
            xmlString.set(styleDocument);
        }
        return xmlString;
    }

    public ResXmlString getOrCreate(int resourceId, String str) {
        ResXmlString xmlString = this.get(str, resXmlString -> resXmlString.equalsValue(resourceId, str));
        if (xmlString == null) {
            xmlString = (ResXmlString)this.createNewString(str);
            xmlString.setResourceId(resourceId);
        }
        return xmlString;
    }

    public ResXmlString getNamespaceString(String uri, String prefix) {
        return this.get(uri, resXmlString -> resXmlString.equalsNamespace(uri, prefix));
    }

    public ResXmlString getOrCreateNamespaceString(String uri, String prefix) {
        ResXmlString prefixXmlString;
        if (uri == null || prefix == null || uri.equals(prefix)) {
            return null;
        }
        ResXmlString xmlString = this.getNamespaceString(uri, prefix);
        if (xmlString == null && (xmlString = this.get(uri, resXmlString -> !resXmlString.hasNamespacePrefix() && !resXmlString.hasResourceId() && !resXmlString.hasStyle())) != null) {
            prefixXmlString = this.getOrCreate(prefix);
            xmlString.linkNamespacePrefixInternal(prefixXmlString);
        }
        if (xmlString == null) {
            xmlString = (ResXmlString)this.createNewString(uri);
            prefixXmlString = this.getOrCreate(prefix);
            xmlString.linkNamespacePrefixInternal(prefixXmlString);
        }
        return xmlString;
    }

    @Override
    public void onPreAddInternal(int index, ResXmlString item) {
        ResXmlIDList xmlIDMap = this.getResXmlIDMap().getResXmlIDArray();
        if (index < xmlIDMap.size() - 1) {
            xmlIDMap.createAt(index);
        }
        super.onPreAddInternal(index, item);
    }

    @Override
    public void onSortedInternal() {
        super.onSortedInternal();
        this.getResXmlIDMap().getResXmlIDArray().sort();
    }

    private ResXmlIDMap getResXmlIDMap() {
        ResXmlDocument resXmlDocument = this.getParentInstance(ResXmlDocument.class);
        if (resXmlDocument != null) {
            return resXmlDocument.getResXmlIDMap();
        }
        return (ResXmlIDMap)ObjectsUtil.getNull();
    }

    public void linkResXmlIDMapInternal() {
        ResXmlIDMap resXmlIDMap = this.getResXmlIDMap();
        if (resXmlIDMap == null) {
            return;
        }
        StringItemList stringsArray = this.getStringsArray();
        int size = NumbersUtil.min(resXmlIDMap.size(), stringsArray.size());
        for (int i = 0; i < size; ++i) {
            ResXmlString resXmlString = (ResXmlString)stringsArray.get(i);
            ResXmlID xmlID = resXmlIDMap.get(i);
            resXmlString.linkResourceIdInternal(xmlID);
        }
    }

    @Override
    public void onChunkLoaded() {
        super.onChunkLoaded();
        this.linkResXmlIDMapInternal();
    }

    @Override
    protected void onPreRefresh() {
        super.onPreRefresh();
        this.sort();
    }
}

