/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.pool;

import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.UnknownChunk;
import com.reandroid.arsc.header.HeaderBlock;
import com.reandroid.arsc.header.TableHeader;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.TableString;
import com.reandroid.arsc.pool.StringPool;
import com.reandroid.xml.StyleDocument;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class TableStringPool
extends StringPool<TableString> {
    public TableStringPool(boolean is_utf8) {
        super(is_utf8, TableString::new);
    }

    public TableString getOrCreateStyled(String xmlString) throws IOException, XmlPullParserException {
        return (TableString)this.getOrCreate(StyleDocument.parseStyledString(xmlString));
    }

    public TableString getOrCreate(XmlPullParser parser) throws IOException, XmlPullParserException {
        return (TableString)this.getOrCreate(StyleDocument.parseNext(parser));
    }

    @Override
    void linkStrings() {
        super.linkStrings();
        TableBlock tableBlock = this.getParentInstance(TableBlock.class);
        if (tableBlock != null) {
            tableBlock.linkTableStringsInternal(this);
        }
    }

    public static TableStringPool readFromTable(InputStream inputStream) throws IOException {
        TableHeader tableHeader = new TableHeader();
        tableHeader.readBytes(inputStream);
        if (tableHeader.getChunkType() != ChunkType.TABLE) {
            throw new IOException("Not TableBlock: " + tableHeader);
        }
        UnknownChunk poolChunk = new UnknownChunk();
        poolChunk.readBytes(inputStream);
        Object poolHeader = poolChunk.getHeaderBlock();
        if (((HeaderBlock)poolHeader).getChunkType() != ChunkType.STRING) {
            throw new IOException("Not StringPool chunk: " + poolChunk);
        }
        BlockReader blockReader = new BlockReader(poolChunk.getBytes());
        TableStringPool stringPool = new TableStringPool(true);
        stringPool.readBytes(blockReader);
        blockReader.close();
        return stringPool;
    }
}

