/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.pool;

import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.arsc.item.TypeString;
import com.reandroid.arsc.list.StringItemList;
import com.reandroid.arsc.pool.StringPool;
import com.reandroid.utils.collection.CollectionUtil;

public class TypeStringPool
extends StringPool<TypeString> {
    private final IntegerReference typeIdOffsetReference;

    public TypeStringPool(boolean is_utf8, IntegerItem typeIdOffsetReference) {
        super(is_utf8, false, TypeString::new);
        this.typeIdOffsetReference = typeIdOffsetReference;
    }

    public int getLastId() {
        int count = this.size();
        return this.toTypeId(count - 1);
    }

    public int idOf(String typeName) {
        return this.idOf(this.getByName(typeName));
    }

    public int idOf(TypeString typeString) {
        if (typeString == null) {
            return 0;
        }
        return this.toTypeId(typeString.getIndex());
    }

    public TypeString getByName(String name) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            TypeString typeString = (TypeString)this.get(i);
            if (!name.equals(typeString.get())) continue;
            return typeString;
        }
        return null;
    }

    public TypeString getById(int id) {
        return (TypeString)super.get(this.toIndex(id));
    }

    public TypeString getOrCreate(int typeId, String typeName) {
        this.ensureStringsSize(this.toIndex(typeId) + 1);
        TypeString typeString = this.getById(typeId);
        typeString.set(typeName);
        return typeString;
    }

    private void ensureStringsSize(int size) {
        StringItemList stringsArray = this.getStringsArray();
        int current = stringsArray.size();
        if (size > current) {
            stringsArray.setSize(size);
            for (int i = current; i < size; ++i) {
                ((TypeString)stringsArray.get(i)).set("type-" + i);
            }
        }
    }

    private int toIndex(int typeId) {
        return typeId - 1 - this.typeIdOffsetReference.get();
    }

    private int toTypeId(int index) {
        return index + 1 + this.typeIdOffsetReference.get();
    }

    @Override
    @Deprecated
    public final TypeString getOrCreate(String str) {
        TypeString typeString = (TypeString)CollectionUtil.getSingle(this.getAll(str));
        if (typeString == null) {
            throw new IllegalArgumentException("Can not create TypeString (" + str + ") without type id. use getOrCreate(typeId, typeName)");
        }
        return typeString;
    }
}

