/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockCounter;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.FixedLengthString;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.model.ResourceLibrary;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.HexUtil;
import java.io.IOException;
import java.io.OutputStream;

public class LibraryInfo
extends Block
implements JSONConvert<JSONObject>,
ResourceLibrary {
    private final IntegerItem mPackageId = new IntegerItem();
    private final FixedLengthString mPackageName = new FixedLengthString(256);

    public LibraryInfo() {
        this.mPackageId.setIndex(0);
        this.mPackageId.setParent(this);
        this.mPackageName.setIndex(1);
        this.mPackageName.setParent(this);
    }

    @Override
    public int getId() {
        return this.mPackageId.get();
    }

    public void setId(int id) {
        this.mPackageId.set(id);
    }

    @Override
    public String getName() {
        return this.mPackageName.get();
    }

    public void setName(String packageName) {
        this.mPackageName.set(packageName);
    }

    @Override
    public String getPrefix() {
        return ResourceLibrary.toPrefix(this.getName());
    }

    @Override
    public String getUri() {
        if (this.getId() == 1 && ResourceLibrary.PREFIX_ANDROID.equals(this.getName())) {
            return ResourceLibrary.URI_ANDROID;
        }
        return ResourceLibrary.URI_RES_AUTO;
    }

    @Override
    public boolean packageNameMatches(String packageName) {
        return ResourceLibrary.packageNameMatches(this, packageName);
    }

    @Override
    public byte[] getBytes() {
        if (this.isNull()) {
            return null;
        }
        return LibraryInfo.addBytes(this.mPackageId.getBytes(), this.mPackageName.getBytes());
    }

    @Override
    public int countBytes() {
        if (this.isNull()) {
            return 0;
        }
        return this.mPackageId.countBytes() + this.mPackageName.countBytes();
    }

    @Override
    public void onCountUpTo(BlockCounter counter) {
        if (counter.FOUND) {
            return;
        }
        counter.setCurrent(this);
        if (counter.END == this) {
            counter.FOUND = true;
            return;
        }
        this.mPackageId.onCountUpTo(counter);
        this.mPackageName.onCountUpTo(counter);
    }

    @Override
    protected int onWriteBytes(OutputStream stream) throws IOException {
        int result = this.mPackageId.writeBytes(stream);
        return result += this.mPackageName.writeBytes(stream);
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        this.mPackageId.readBytes(reader);
        this.mPackageName.readBytes(reader);
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", this.getId());
        jsonObject.put("name", this.getName());
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        this.setId(json.getInt("id"));
        this.setName(json.getString("name"));
    }

    public void merge(LibraryInfo info) {
        if (info == null || info == this) {
            return;
        }
        if (this.getId() != info.getId()) {
            throw new IllegalArgumentException("Can not add different id libraries: " + this.getId() + "!=" + info.getId());
        }
        this.setName(info.getName());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LIBRARY{");
        builder.append(HexUtil.toHex2((byte)this.getId()));
        builder.append(':');
        String name = this.getName();
        if (name == null) {
            name = "NULL";
        }
        builder.append(name);
        builder.append('}');
        return builder.toString();
    }
}

