/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value;

import com.reandroid.arsc.array.CompoundItemArray;
import com.reandroid.arsc.array.ResValueMapArray;
import com.reandroid.arsc.item.TypeString;
import com.reandroid.arsc.refactor.ResourceMergeOption;
import com.reandroid.arsc.value.AttributeType;
import com.reandroid.arsc.value.CompoundEntry;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.EntryHeaderMap;
import com.reandroid.arsc.value.ResValueMap;
import com.reandroid.arsc.value.TableEntry;
import com.reandroid.arsc.value.ValueHeader;
import com.reandroid.arsc.value.ValueType;
import java.util.HashSet;
import java.util.Iterator;

public class ResTableMapEntry
extends CompoundEntry<ResValueMap, ResValueMapArray> {
    public ResTableMapEntry() {
        super(new ResValueMapArray());
    }

    public boolean isAttr() {
        boolean hasFormats = false;
        Iterator iterator = ((ResValueMapArray)this.getValue()).iterator();
        while (iterator.hasNext()) {
            ResValueMap valueMap = (ResValueMap)iterator.next();
            AttributeType attributeType = valueMap.getAttributeType();
            if (attributeType != null && attributeType.isPlural()) {
                return false;
            }
            if (attributeType != AttributeType.FORMATS) continue;
            if (hasFormats) {
                return false;
            }
            hasFormats = true;
        }
        return hasFormats;
    }

    public boolean isPlural() {
        HashSet<AttributeType> uniqueSet = new HashSet<AttributeType>();
        Iterator iterator = ((ResValueMapArray)this.getValue()).iterator();
        while (iterator.hasNext()) {
            ResValueMap valueMap = (ResValueMap)iterator.next();
            AttributeType attributeType = valueMap.getAttributeType();
            if (attributeType == null || !attributeType.isPlural()) {
                return false;
            }
            if (uniqueSet.contains((Object)attributeType)) {
                return false;
            }
            uniqueSet.add(attributeType);
        }
        return uniqueSet.size() > 0;
    }

    public boolean isArray() {
        int size = ((ResValueMapArray)this.getValue()).size();
        Iterator iterator = ((ResValueMapArray)this.getValue()).iterator();
        while (iterator.hasNext()) {
            ResValueMap valueMap = (ResValueMap)iterator.next();
            int id = valueMap.getArrayIndex();
            if (id >= 0 && id <= size) continue;
            return false;
        }
        if (size != 0) {
            return true;
        }
        Entry entry = this.getParentEntry();
        if (entry == null) {
            return false;
        }
        return TypeString.isTypeArray(entry.getTypeName());
    }

    public boolean isStyle() {
        if (this.getParentId() != 0) {
            return true;
        }
        Entry entry = this.getParentEntry();
        if (entry != null) {
            return TypeString.isTypeStyle(entry.getTypeName());
        }
        return false;
    }

    public void sortIfStyle() {
        if (this.isStyle()) {
            ((ResValueMapArray)this.getValue()).sort();
        }
    }

    public ValueType isAllSameValueType() {
        ValueType allValueType = null;
        Iterator iterator = ((ResValueMapArray)this.getValue()).iterator();
        while (iterator.hasNext()) {
            ResValueMap valueMap = (ResValueMap)iterator.next();
            ValueType valueType = valueMap.getValueType();
            if (valueType == null) {
                return null;
            }
            if (valueType == ValueType.REFERENCE) continue;
            if (allValueType == null) {
                allValueType = valueType;
                continue;
            }
            if (valueType == allValueType) continue;
            return null;
        }
        return allValueType;
    }

    @Override
    boolean canMerge(TableEntry<?, ?> tableEntry) {
        if (tableEntry == this || !(tableEntry instanceof ResTableMapEntry)) {
            return false;
        }
        ResValueMapArray coming = (ResValueMapArray)((ResTableMapEntry)tableEntry).getValue();
        if (coming.size() == 0) {
            return false;
        }
        return ((ResValueMapArray)this.getValue()).size() == 0;
    }

    @Override
    public void merge(TableEntry<?, ?> tableEntry) {
        if (tableEntry == null || tableEntry == this) {
            return;
        }
        ResTableMapEntry coming = (ResTableMapEntry)tableEntry;
        ((EntryHeaderMap)this.getHeader()).merge((ValueHeader)coming.getHeader());
        ((ResValueMapArray)this.getValue()).merge((CompoundItemArray)coming.getValue());
        this.refresh();
    }

    @Override
    public void mergeWithName(ResourceMergeOption mergeOption, TableEntry<?, ?> tableEntry) {
        if (tableEntry == null || tableEntry == this) {
            return;
        }
        ResTableMapEntry coming = (ResTableMapEntry)tableEntry;
        ((EntryHeaderMap)this.getHeader()).mergeWithName(mergeOption, (ValueHeader)coming.getHeader());
        ((ResValueMapArray)this.getValue()).mergeWithName(mergeOption, (CompoundItemArray)coming.getValue());
        this.refresh();
    }
}

